<?php
include 'include/header.php';
include '../config/conn.php';

// ✅ Ensure parent login
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    header('Location: ../portal_login.php');
    exit();
}

$parent_id = $_SESSION['user_id'];

// --- Fetch events (only for parents or all) ---
$sql = "SELECT * FROM events WHERE audience_type = 'parent' OR audience_type = 'all' ORDER BY event_date ASC, start_time ASC";
$stmt = $conn->prepare($sql);
$stmt->execute();
$result = $stmt->get_result();
$events = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<div class="bg-white p-6">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Upcoming Events</h2>
    </div>

    <div class="space-y-4">
        <?php if (!empty($events)): ?>
            <?php foreach ($events as $event): ?>
                <div class="p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                    <div class="flex items-start space-x-4">
                        <!-- Date Badge -->
                        <div class="flex-shrink-0 w-14 h-14 bg-green-100 rounded-lg flex flex-col items-center justify-center">
                            <span class="text-green-600 font-bold text-lg">
                                <?php echo date('d', strtotime($event['event_date'])); ?>
                            </span>
                            <span class="text-xs text-gray-500">
                                <?php echo date('M', strtotime($event['event_date'])); ?>
                            </span>
                        </div>

                        <!-- Event Details -->
                        <div class="flex-1">
                            <h3 class="text-lg font-semibold text-gray-800">
                                <a href="view_event_detail.php?id=<?php echo $event['id']; ?>" 
                                   class="text-blue-600 hover:underline">
                                   <?php echo htmlspecialchars($event['title']); ?>
                                </a>
                            </h3>
                            <p class="text-sm text-gray-600 mt-1">
                                <?php echo !empty($event['description']) ? nl2br(htmlspecialchars($event['description'])) : 'No description provided'; ?>
                            </p>
                            <div class="mt-2 text-xs text-gray-500">
                                <p><i class="fas fa-clock mr-1"></i> 
                                    <?php echo date('g:i A', strtotime($event['start_time'])); ?> 
                                    - <?php echo date('g:i A', strtotime($event['end_time'])); ?>
                                </p>
                                <p><i class="fas fa-map-marker-alt mr-1"></i> 
                                    <?php echo htmlspecialchars($event['location']); ?>
                                </p>
                            </div>
                        </div>

                        <!-- Optional Image -->
                        <?php if (!empty($event['image_path'])): ?>
                            <div class="w-20 h-20 flex-shrink-0">
                                <img src="../uploads/events/<?php echo htmlspecialchars($event['image_path']); ?>" 
                                     alt="Event Image" 
                                     class="w-full h-full object-cover rounded-md border">
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p class="text-gray-500 text-center py-6">No upcoming events found.</p>
        <?php endif; ?>
    </div>
</div>

<?php include 'include/footer.php'; ?>
