<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Toggle sidebar on mobile
        const menuBtn = document.querySelector('.menu-btn');
        const sidebar = document.querySelector('.sidebar');
        const overlay = document.querySelector('.overlay');
        
        menuBtn.addEventListener('click', function() {
            sidebar.classList.toggle('open');
            overlay.classList.toggle('open');
        });
        
        overlay.addEventListener('click', function() {
            sidebar.classList.remove('open');
            overlay.classList.remove('open');
        });
        
        // Toggle submenus
        const toggleSubmenu = (btnClass) => {
            const btn = document.querySelector(btnClass);
            btn.addEventListener('click', function() {
                const submenu = this.nextElementSibling;
                const icon = this.querySelector('.fa-chevron-down');
                
                submenu.classList.toggle('open');
                icon.classList.toggle('rotate-180');
            });
        };
        
        // Initialize all submenu toggles
        toggleSubmenu('.student-btn');
        toggleSubmenu('.staff-btn');
        toggleSubmenu('.academic-btn');
        toggleSubmenu('.finance-btn');
        toggleSubmenu('.library-btn');
        toggleSubmenu('.transport-btn');
        toggleSubmenu('.hostel-btn');
        
        // Search functionality
        const searchInput = document.querySelector('input[type="text"]');
        const searchButton = document.querySelector('.search-btn');
        
        searchButton.addEventListener('click', function() {
            performSearch();
        });
        
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                performSearch();
            }
        });
        
        function performSearch() {
            const searchTerm = searchInput.value.trim();
            if (searchTerm) {
                alert(`Searching for: ${searchTerm}`);
                // In a real application, you would submit the search or filter results
            }
        }
        
        // Mobile search functionality
        const mobileSearchBtn = document.querySelector('.mobile-search-btn');
        const mobileSearchOverlay = document.querySelector('.mobile-search-overlay');
        const mobileSearchContainer = document.querySelector('.mobile-search-container');
        const mobileSearchClose = document.querySelector('.mobile-search-close');
        const mobileSearchInput = document.querySelector('.mobile-search-container input');
        
        mobileSearchBtn.addEventListener('click', function() {
            mobileSearchOverlay.classList.add('open');
            mobileSearchContainer.classList.add('open');
            mobileSearchInput.focus();
        });
        
        mobileSearchClose.addEventListener('click', function() {
            mobileSearchOverlay.classList.remove('open');
            mobileSearchContainer.classList.remove('open');
        });
        
        mobileSearchOverlay.addEventListener('click', function() {
            mobileSearchOverlay.classList.remove('open');
            mobileSearchContainer.classList.remove('open');
        });
        
        mobileSearchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                const searchTerm = mobileSearchInput.value.trim();
                if (searchTerm) {
                    alert(`Searching for: ${searchTerm}`);
                    mobileSearchOverlay.classList.remove('open');
                    mobileSearchContainer.classList.remove('open');
                }
            }
        });
    });
</script>
</body>
</html>