<?php
session_start();

// Update the session activity time
if (isset($_SESSION['last_activity'])) {
    $_SESSION['last_activity'] = time();
    
    // Return success response for AJAX calls
    if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
        header('Content-Type: application/json');
        echo json_encode(['success' => true]);
        exit();
    }
}

// If not an AJAX request, redirect to homepage
header("Location: index.php");
exit();
?>