<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

$parent_id = $_SESSION['user_id'];
$user_type = 'parent';

// Get student IDs for this parent
$students_query = "SELECT student_id FROM parent_students WHERE parent_id = $parent_id";
$students_result = mysqli_query($conn, $students_query);
$student_ids = [];
while ($row = mysqli_fetch_assoc($students_result)) {
    $student_ids[] = $row['student_id'];
}

// Mark notifications as read when viewed
if (isset($_GET['mark_read']) && $_GET['mark_read'] == 'all') {
    if (!empty($student_ids)) {
        $student_ids_str = implode(',', $student_ids);
        $mark_read_query = "UPDATE notifications SET is_read = 1 WHERE user_id IN ($student_ids_str) AND user_type = 'student'";
        mysqli_query($conn, $mark_read_query);
    }
}

// Fetch notifications for all students of this parent
$notifications = [];
if (!empty($student_ids)) {
    $student_ids_str = implode(',', $student_ids);
    $notifications_query = "SELECT n.*, s.full_name as student_name 
                           FROM notifications n
                           JOIN students s ON n.user_id = s.id
                           WHERE n.user_id IN ($student_ids_str) AND n.user_type = 'student' 
                           ORDER BY n.created_at DESC";
    $notifications_result = mysqli_query($conn, $notifications_query);
    while ($notification = mysqli_fetch_assoc($notifications_result)) {
        $notifications[] = $notification;
    }
}

// Count unread notifications
$unread_count = 0;
if (!empty($student_ids)) {
    $student_ids_str = implode(',', $student_ids);
    $unread_query = "SELECT COUNT(*) as count FROM notifications 
                    WHERE user_id IN ($student_ids_str) AND user_type = 'student' AND is_read = 0";
    $unread_result = mysqli_query($conn, $unread_query);
    $unread_count = mysqli_fetch_assoc($unread_result)['count'];
}
?>

<div class="bg-white p-6 rounded-lg shadow-md">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Children's Notifications</h2>
        <div class="flex items-center">
            <?php if ($unread_count > 0): ?>
                <span class="bg-red-500 text-white text-xs font-medium px-2.5 py-0.5 rounded-full mr-3">
                    <?php echo $unread_count; ?> unread
                </span>
            <?php endif; ?>
            <a href="?mark_read=all" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm">
                <i class="fas fa-check-double mr-1"></i> Mark all as read
            </a>
        </div>
    </div>

    <div class="space-y-4">
        <?php if (!empty($notifications)): ?>
            <?php foreach ($notifications as $notification): ?>
                <div class="border border-gray-200 rounded-lg p-4 <?php echo $notification['is_read'] ? 'bg-white' : 'bg-blue-50'; ?>">
                    <div class="flex justify-between items-start">
                        <div class="flex-1">
                            <div class="flex items-center mb-2">
                                <span class="bg-purple-100 text-purple-800 text-xs font-medium px-2.5 py-0.5 rounded-full mr-2">
                                    <?php echo $notification['student_name']; ?>
                                </span>
                                <h3 class="font-semibold text-gray-800"><?php echo $notification['title']; ?></h3>
                            </div>
                            <p class="text-gray-600 mt-1"><?php echo $notification['message']; ?></p>
                            <p class="text-sm text-gray-500 mt-2">
                                <i class="far fa-clock mr-1"></i> 
                                <?php echo date('M j, Y g:i A', strtotime($notification['created_at'])); ?>
                            </p>
                        </div>
                        <?php if (!$notification['is_read']): ?>
                            <span class="bg-blue-500 text-white text-xs font-medium px-2 py-1 rounded-full ml-3">
                                New
                            </span>
                        <?php endif; ?>
                    </div>
                    
                    <?php if ($notification['type'] == 'assignment' && !empty($notification['related_id'])): ?>
                        <div class="mt-3 pt-3 border-t border-gray-100">
                            <a href="view_assignment.php?id=<?php echo $notification['related_id']; ?>" 
                               class="text-blue-600 hover:text-blue-800 text-sm">
                                <i class="fas fa-external-link-alt mr-1"></i> View Assignment
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="text-center py-8">
                <i class="far fa-bell text-4xl text-gray-300 mb-3"></i>
                <p class="text-gray-500">No notifications for your children yet.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php
include 'include/footer.php';
ob_end_flush();
?>