<?php
// Include header
include 'include/header.php';

// Check if parent is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    header('Location: ../portal_login.php');
    exit();
}

include '../config/conn.php';

// Parent ID
$parent_id = $_SESSION['user_id'];

// Get all children of this parent
$children_query = "SELECT s.id, s.full_name, s.student_id, s.roll_number, c.class_name, sec.section_name
                   FROM students s
                   LEFT JOIN classes c ON s.class = c.id
                   LEFT JOIN sections sec ON s.section = sec.id
                   WHERE s.parent_id = ?";
$stmt = $conn->prepare($children_query);
$stmt->bind_param("i", $parent_id);
$stmt->execute();
$children_result = $stmt->get_result();
$children = $children_result->fetch_all(MYSQLI_ASSOC);
$stmt->close();

if (empty($children)) {
    echo "<div class='bg-white p-6   text-center text-gray-600'>
            <i class='fas fa-info-circle text-2xl mb-2'></i>
            <p>No children linked to your account.</p>
          </div>";
    include 'include/footer.php';
    exit();
}

// Select which child to view (default: first child)
$selected_child_id = isset($_GET['child_id']) ? intval($_GET['child_id']) : $children[0]['id'];

// Get selected child info
$student = null;
foreach ($children as $child) {
    if ($child['id'] == $selected_child_id) {
        $student = $child;
        break;
    }
}

if (!$student) {
    echo "<div class='p-6 text-center text-red-500'>Invalid student selected.</div>";
    include 'include/footer.php';
    exit();
}

// Month filter
$month = isset($_GET['month']) ? $_GET['month'] : date('Y-m');
$first_day = date('N', strtotime($month . '-01'));
$days_in_month = date('t', strtotime($month . '-01'));
$month_name = date('F Y', strtotime($month . '-01'));

// Attendance data
$attendance_data = [];
$start_date = date('Y-m-01', strtotime($month));
$end_date = date('Y-m-t', strtotime($month));

$query = "SELECT attendance_date, status 
          FROM attendance 
          WHERE student_id = ? 
          AND attendance_date BETWEEN ? AND ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("iss", $selected_child_id, $start_date, $end_date);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $attendance_data[$row['attendance_date']] = $row['status'];
}
$stmt->close();
?>

<div class="bg-white p-2  ">
    <h2 class="text-xl font-bold text-gray-800 mb-4">
        <i class="fas fa-calendar-check mr-2"></i>
        Attendance Records (<?php echo $month_name; ?>)
    </h2>

    <!-- Child Selector -->
    <form method="GET" action="" class="flex flex-wrap gap-3 mb-4">
        <select name="child_id" class="px-4 py-2 border ">
            <?php foreach ($children as $child): ?>
                <option value="<?php echo $child['id']; ?>" 
                    <?php echo $child['id'] == $selected_child_id ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($child['full_name']) . " (" . $child['class_name'] . " - " . $child['section_name'] . ")"; ?>
                </option>
            <?php endforeach; ?>
        </select>

        <input type="month" name="month" value="<?php echo $month; ?>" 
               class="px-4 py-2 border ">

        <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 ">
            <i class="fas fa-eye mr-1"></i> View
        </button>
    </form>

    <!-- Student Info -->
    <div class="bg-blue-50 p-4  mb-6">
        <h3 class="font-semibold text-blue-800">
            <?php echo htmlspecialchars($student['full_name']); ?> 
            <span class="text-sm text-gray-500">(<?php echo htmlspecialchars($student['student_id']); ?>)</span>
        </h3>
        <p class="text-blue-600">
            <i class="fas fa-graduation-cap"></i> Class: <?php echo $student['class_name']; ?> |
            <i class="fas fa-layer-group"></i> Section: <?php echo $student['section_name']; ?> |
            <i class="fas fa-hashtag"></i> Roll: <?php echo $student['roll_number']; ?>
        </p>
    </div>

    <!-- Attendance Calendar -->
    <div class="grid grid-cols-7 gap-2 mb-6">
        <?php
        $weekdays = ['Mon','Tue','Wed','Thu','Fri','Sat','Sun'];
        foreach ($weekdays as $d) echo "<div class='text-center font-medium'>$d</div>";

        for ($i = 1; $i < $first_day; $i++) {
            echo "<div class='h-16 bg-gray-100 '></div>";
        }

        for ($day = 1; $day <= $days_in_month; $day++) {
            $current_date = $month . '-' . str_pad($day, 2, '0', STR_PAD_LEFT);
            $status = $attendance_data[$current_date] ?? null;

            $bg = "bg-gray-50";
            $icon = "fa-minus-circle text-gray-400";
            $title = "No Record";

            if ($status === "present") {
                $bg = "bg-green-100"; $icon = "fa-check-circle text-green-600"; $title = "Present";
            } elseif ($status === "absent") {
                $bg = "bg-red-100"; $icon = "fa-times-circle text-red-600"; $title = "Absent";
            } elseif ($status === "late") {
                $bg = "bg-yellow-100"; $icon = "fa-clock text-yellow-600"; $title = "Late";
            } elseif ($status === "half_day") {
                $bg = "bg-blue-100"; $icon = "fa-adjust text-blue-600"; $title = "Half Day";
            }

            echo "<div class='h-16 p-1  text-center $bg' title='$title'>
                    <div class='text-sm font-medium'>$day</div>
                    <i class='fas $icon'></i>
                    <div class='text-xs'>$title</div>
                  </div>";
        }
        ?>
    </div>
</div>

<?php include 'include/footer.php'; ?>
