<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$admin_id = $_SESSION['user_id'];
$admin_name = $_SESSION['user_name'];

$errors = [];
$success = '';

// Initialize form variables
$fullname = $username = $email = $gender = $birth = $address = $contact = '';
$edit_mode = false;
$parent_id = '';

// Check if we're editing an existing parent
if (isset($_GET['edit_id'])) {
    $edit_mode = true;
    $parent_id = mysqli_real_escape_string($conn, $_GET['edit_id']);
    
    $query = "SELECT * FROM parents WHERE id = $parent_id";
    $result = mysqli_query($conn, $query);
    
    if (mysqli_num_rows($result) == 1) {
        $parent = mysqli_fetch_assoc($result);
        $fullname = htmlspecialchars($parent['fullname']);
        $username = htmlspecialchars($parent['username']);
        $email = htmlspecialchars($parent['email']);
        $gender = htmlspecialchars($parent['gender']);
        $birth = htmlspecialchars($parent['birth']);
        $address = htmlspecialchars($parent['address']);
        $contact = htmlspecialchars($parent['contact']);
    } else {
        $_SESSION['message'] = "Parent not found";
        $_SESSION['message_type'] = "error";
        header('Location: parents.php');
        exit();
    }
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get form data and sanitize
    $fullname = mysqli_real_escape_string($conn, trim($_POST['fullname']));
    $username = mysqli_real_escape_string($conn, trim($_POST['username']));
    $email = mysqli_real_escape_string($conn, trim($_POST['email']));
    $gender = mysqli_real_escape_string($conn, $_POST['gender']);
    $birth = mysqli_real_escape_string($conn, $_POST['birth']);
    $address = mysqli_real_escape_string($conn, trim($_POST['address']));
    $contact = mysqli_real_escape_string($conn, trim($_POST['contact']));
    $password = mysqli_real_escape_string($conn, $_POST['password']);
    $confirm_password = mysqli_real_escape_string($conn, $_POST['confirm_password']);
    
    // Validate required fields
    if (empty($fullname)) $errors[] = "Full name is required";
    if (empty($username)) $errors[] = "Username is required";
    if (empty($email)) $errors[] = "Email is required";
    if (empty($gender)) $errors[] = "Gender is required";
    if (empty($birth)) $errors[] = "Date of birth is required";
    if (empty($address)) $errors[] = "Address is required";
    if (empty($contact)) $errors[] = "Contact number is required";
    
    // Validate email format
    if (!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Invalid email format";
    }
    
    // Validate contact number (basic validation for 10-15 digits)
    if (!empty($contact) && !preg_match('/^[0-9]{10,15}$/', $contact)) {
        $errors[] = "Contact number must be 10-15 digits";
    }
    
    // If creating new parent, validate password
    if (!$edit_mode) {
        if (empty($password)) {
            $errors[] = "Password is required";
        } elseif (strlen($password) < 8) {
            $errors[] = "Password must be at least 8 characters long";
        } elseif ($password !== $confirm_password) {
            $errors[] = "Passwords do not match";
        }
    } elseif (!empty($password)) {
        // If editing and password is provided, validate it
        if (strlen($password) < 8) {
            $errors[] = "Password must be at least 8 characters long";
        } elseif ($password !== $confirm_password) {
            $errors[] = "Passwords do not match";
        }
    }
    
    // Check if username already exists (excluding current parent in edit mode)
    $check_username = "SELECT id FROM parents WHERE username = '$username'";
    if ($edit_mode) {
        $check_username .= " AND id != $parent_id";
    }
    $result = mysqli_query($conn, $check_username);
    if (mysqli_num_rows($result) > 0) {
        $errors[] = "Username already exists";
    }
    
    // Check if email already exists (excluding current parent in edit mode)
    $check_email = "SELECT id FROM parents WHERE email = '$email'";
    if ($edit_mode) {
        $check_email .= " AND id != $parent_id";
    }
    $result = mysqli_query($conn, $check_email);
    if (mysqli_num_rows($result) > 0) {
        $errors[] = "Email already exists";
    }
    
    // Handle file upload
    $picture_path = '';
    if (isset($_FILES['picture']) && $_FILES['picture']['error'] == 0) {
        $allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
        $file_type = $_FILES['picture']['type'];
        $file_size = $_FILES['picture']['size'];
        $max_file_size = 5 * 1024 * 1024; // 5MB
        
        if ($file_size > $max_file_size) {
            $errors[] = "Image size must be less than 5MB";
        } elseif (in_array($file_type, $allowed_types)) {
            $upload_dir = '../uploads/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0777, true);
            }
            
            $file_extension = pathinfo($_FILES['picture']['name'], PATHINFO_EXTENSION);
            $filename = uniqid() . '.' . $file_extension;
            $target_path = $upload_dir . $filename;
            
            if (move_uploaded_file($_FILES['picture']['tmp_name'], $target_path)) {
                $picture_path = $target_path;
                
                // If editing, delete old picture
                if ($edit_mode && !empty($parent['picture']) && file_exists($parent['picture'])) {
                    unlink($parent['picture']);
                }
            } else {
                $errors[] = "Failed to upload picture";
            }
        } else {
            $errors[] = "Only JPG, PNG and GIF files are allowed";
        }
    }
    
    // If no errors, insert into database
    if (empty($errors)) {
        if ($edit_mode) {
            // Update existing parent
            $query = "UPDATE parents SET 
                     fullname = '$fullname', 
                     username = '$username', 
                     email = '$email', 
                     gender = '$gender', 
                     birth = '$birth', 
                     address = '$address', 
                     contact = '$contact'";
            
            if (!empty($picture_path)) {
                $query .= ", picture = '$picture_path'";
            }
            
            if (!empty($password)) {
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $query .= ", password = '$hashed_password'";
            }
            
            $query .= " WHERE id = $parent_id";
        } else {
            // Create new parent
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            
            $query = "INSERT INTO parents (fullname, username, email, gender, birth, address, contact, picture, password) 
                     VALUES ('$fullname', '$username', '$email', '$gender', '$birth', '$address', '$contact', '$picture_path', '$hashed_password')";
        }
        
        if (mysqli_query($conn, $query)) {
            if ($edit_mode) {
                $_SESSION['message'] = "Parent updated successfully";
            } else {
                $_SESSION['message'] = "Parent added successfully";
            }
            $_SESSION['message_type'] = "success";
            header('Location: parents.php');
            exit();
        } else {
            $errors[] = "Database error: " . mysqli_error($conn);
        }
    }
}
ob_end_flush();
?>

<div class="bg-white p-6 rounded-lg shadow-md">
    <h2 class="text-2xl font-bold text-gray-800 mb-6"><?php echo $edit_mode ? 'Edit Parent' : 'Add New Parent'; ?></h2>
    
    <?php if (!empty($errors)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <ul>
                <?php foreach ($errors as $error): ?>
                    <li><?php echo $error; ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>
    
    <form action="" method="POST" enctype="multipart/form-data" class="grid grid-cols-1 md:grid-cols-2 gap-6" onsubmit="return validateForm()">
        <div class="md:col-span-2 flex flex-col items-center mb-4">
            <div class="relative w-32 h-32 rounded-full overflow-hidden border-4 border-gray-300 mb-4">
                <?php if ($edit_mode && !empty($parent['picture'])): ?>
                    <img id="preview" src="<?php echo $parent['picture']; ?>" alt="Parent Photo" class="w-full h-full object-cover">
                <?php else: ?>
                    <img id="preview" src="" alt="Parent Photo" class="w-full h-full object-cover hidden">
                    <div id="placeholder" class="w-full h-full bg-gray-200 flex items-center justify-center">
                        <i class="fas fa-user text-gray-400 text-4xl"></i>
                    </div>
                <?php endif; ?>
            </div>
            <input type="file" id="picture" name="picture" accept="image/*" class="hidden" onchange="previewImage(this)">
            <button type="button" onclick="document.getElementById('picture').click()" class="bg-gray-200 hover:bg-gray-300 text-gray-800 px-4 py-2 rounded">
                <i class="fas fa-upload mr-2"></i> Upload Photo
            </button>
            <p class="text-sm text-gray-500 mt-2">Max file size: 5MB (JPG, PNG, GIF)</p>
        </div>
        
        <div>
            <label for="fullname" class="block text-gray-700 mb-2">Full Name *</label>
            <input type="text" id="fullname" name="fullname" value="<?php echo $fullname; ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div>
            <label for="username" class="block text-gray-700 mb-2">Username *</label>
            <input type="text" id="username" name="username" value="<?php echo $username; ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div>
            <label for="email" class="block text-gray-700 mb-2">Email *</label>
            <input type="email" id="email" name="email" value="<?php echo $email; ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div>
            <label for="gender" class="block text-gray-700 mb-2">Gender *</label>
            <select id="gender" name="gender" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                <option value="">Select Gender</option>
                <option value="Male" <?php echo $gender == 'Male' ? 'selected' : ''; ?>>Male</option>
                <option value="Female" <?php echo $gender == 'Female' ? 'selected' : ''; ?>>Female</option>
                <option value="Other" <?php echo $gender == 'Other' ? 'selected' : ''; ?>>Other</option>
            </select>
        </div>
        
        <div>
            <label for="birth" class="block text-gray-700 mb-2">Date of Birth *</label>
            <input type="date" id="birth" name="birth" value="<?php echo $birth; ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div>
            <label for="contact" class="block text-gray-700 mb-2">Contact Number *</label>
            <input type="tel" id="contact" name="contact" value="<?php echo $contact; ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required pattern="[0-9]{10,15}" title="10-15 digit phone number">
            <p class="text-sm text-gray-500 mt-1">10-15 digits only</p>
        </div>
        
        <div class="md:col-span-2">
            <label for="address" class="block text-gray-700 mb-2">Address *</label>
            <textarea id="address" name="address" rows="3" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required><?php echo $address; ?></textarea>
        </div>
        
        <?php if (!$edit_mode): ?>
            <div>
                <label for="password" class="block text-gray-700 mb-2">Password *</label>
                <input type="password" id="password" name="password" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required onkeyup="validatePassword()">
                <p class="text-sm text-gray-500 mt-1">Minimum 8 characters</p>
            </div>
            
            <div>
                <label for="confirm_password" class="block text-gray-700 mb-2">Confirm Password *</label>
                <input type="password" id="confirm_password" name="confirm_password" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required onkeyup="validatePassword()">
                <p id="passwordMessage" class="text-red-500 text-sm mt-1 hidden">Passwords do not match</p>
            </div>
        <?php else: ?>
            <div class="md:col-span-2">
                <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded">
                    <p>Leave password fields blank if you don't want to change the password.</p>
                </div>
            </div>
            
            <div>
                <label for="password" class="block text-gray-700 mb-2">New Password</label>
                <input type="password" id="password" name="password" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" onkeyup="validatePassword()">
                <p class="text-sm text-gray-500 mt-1">Minimum 8 characters</p>
            </div>
            
            <div>
                <label for="confirm_password" class="block text-gray-700 mb-2">Confirm New Password</label>
                <input type="password" id="confirm_password" name="confirm_password" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" onkeyup="validatePassword()">
                <p id="passwordMessage" class="text-red-500 text-sm mt-1 hidden">Passwords do not match</p>
            </div>
        <?php endif; ?>
        
        <div class="md:col-span-2 flex justify-end space-x-4 mt-4">
            <a href="parents.php" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-2 rounded-lg transition duration-200">Cancel</a>
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition duration-200">
                <?php echo $edit_mode ? 'Update Parent' : 'Add Parent'; ?>
            </button>
        </div>
    </form>
</div>

<script>
function previewImage(input) {
    const preview = document.getElementById('preview');
    const placeholder = document.getElementById('placeholder');
    const file = input.files[0];
    
    if (file) {
        const reader = new FileReader();
        
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.classList.remove('hidden');
            if (placeholder) placeholder.classList.add('hidden');
        }
        
        reader.readAsDataURL(file);
    }
}

function validatePassword() {
    const password = document.getElementById('password').value;
    const confirmPassword = document.getElementById('confirm_password').value;
    const message = document.getElementById('passwordMessage');
    
    if (password && confirmPassword && password !== confirmPassword) {
        message.classList.remove('hidden');
        return false;
    } else {
        message.classList.add('hidden');
        return true;
    }
}

function validateForm() {
    // Validate password match
    const password = document.getElementById('password').value;
    const confirmPassword = document.getElementById('confirm_password').value;
    
    if (password || confirmPassword) {
        if (!validatePassword()) {
            alert('Passwords do not match');
            return false;
        }
    }
    
    // Validate contact number
    const contact = document.getElementById('contact').value;
    const contactPattern = /^[0-9]{10,15}$/;
    
    if (!contactPattern.test(contact)) {
        alert('Contact number must be 10-15 digits');
        return false;
    }
    
    return true;
}
</script>

<?php
include 'include/footer.php';
mysqli_close($conn);
?>