<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Initialize variables
$class_id = isset($_GET['class_id']) ? intval($_GET['class_id']) : 0;
$section_id = isset($_GET['section_id']) ? intval($_GET['section_id']) : 0;
$exam_id = isset($_GET['exam_id']) ? intval($_GET['exam_id']) : 0;
$subject_id = isset($_GET['subject_id']) ? intval($_GET['subject_id']) : 0;
$success = '';
$error = '';

// Fetch all classes
$classes_query = "SELECT id, class_name FROM classes WHERE status = 'active' ORDER BY class_name";
$classes_result = mysqli_query($conn, $classes_query);

// Fetch all exams
$exams_query = "SELECT id, exam_name FROM exams WHERE status = 'active' ORDER BY exam_date DESC";
$exams_result = mysqli_query($conn, $exams_query);

// Fetch all subjects
$subjects_query = "SELECT id, subject_name FROM subjects WHERE status = 'active' ORDER BY subject_name";
$subjects_result = mysqli_query($conn, $subjects_query);

// Fetch sections based on selected class
$sections = [];
if ($class_id > 0) {
    $sections_query = "SELECT id, section_name FROM sections WHERE class_id = $class_id AND status = 'active' ORDER BY section_name";
    $sections_result = mysqli_query($conn, $sections_query);
    while ($section = mysqli_fetch_assoc($sections_result)) {
        $sections[] = $section;
    }
}

// Fetch students based on selected class and section
$students = [];
if ($class_id > 0 && $section_id > 0) {
    $students_query = "SELECT id, student_id, full_name, roll_number 
                       FROM students 
                       WHERE class = $class_id AND section = $section_id AND status = 'active' 
                       ORDER BY roll_number";
    $students_result = mysqli_query($conn, $students_query);
    while ($student = mysqli_fetch_assoc($students_result)) {
        $students[] = $student;
    }
}

// Check if scores already exist for the selected exam, subject, class, and section
$scores_exist = false;
$existing_scores = [];
if ($class_id > 0 && $section_id > 0 && $exam_id > 0 && $subject_id > 0) {
    $check_scores_query = "SELECT student_id, ca_score, exam_score 
                           FROM exam_results 
                           WHERE exam_id = $exam_id 
                           AND subject_id = $subject_id 
                           AND class_id = $class_id 
                           AND section_id = $section_id";
    $check_scores_result = mysqli_query($conn, $check_scores_query);
    
    if (mysqli_num_rows($check_scores_result) > 0) {
        $scores_exist = true;
        while ($row = mysqli_fetch_assoc($check_scores_result)) {
            $existing_scores[$row['student_id']] = [
                'ca_score' => $row['ca_score'],
                'exam_score' => $row['exam_score']
            ];
        }
    }
}

// Get exam details for total marks
$exam_details = [];
if ($exam_id > 0) {
    $exam_query = "SELECT total_marks FROM exams WHERE id = $exam_id";
    $exam_result = mysqli_query($conn, $exam_query);
    if ($exam_result && mysqli_num_rows($exam_result) > 0) {
        $exam_details = mysqli_fetch_assoc($exam_result);
    }
}

// Handle score submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_scores'])) {
    $class_id = intval($_POST['class_id']);
    $section_id = intval($_POST['section_id']);
    $exam_id = intval($_POST['exam_id']);
    $subject_id = intval($_POST['subject_id']);
    $ca_scores = $_POST['ca_scores'];
    $exam_scores = $_POST['exam_scores'];
    
    // Validate inputs
    if (empty($class_id) || empty($section_id) || empty($exam_id) || empty($subject_id)) {
        $error = "Please select all required fields.";
    } else {
        // Begin transaction
        mysqli_begin_transaction($conn);
        
        try {
            // Use INSERT...ON DUPLICATE KEY UPDATE to handle duplicates
            foreach ($ca_scores as $student_id => $ca_score) {
                $student_id = intval($student_id);
                $ca_score = floatval($ca_score);
                $exam_score = floatval($exam_scores[$student_id]);
                
                // Calculate total marks (CA + Exam only)
                $marks_obtained = $ca_score + $exam_score;
                
                // Calculate percentage if total marks available
                $percentage = 0;
                if ($exam_details && $exam_details['total_marks'] > 0) {
                    $percentage = ($marks_obtained / $exam_details['total_marks']) * 100;
                }
                
                // Determine grade based on percentage (customize as needed)
                $grade = '';
                if ($percentage >= 90) $grade = 'A+';
                elseif ($percentage >= 80) $grade = 'A';
                elseif ($percentage >= 70) $grade = 'B+';
                elseif ($percentage >= 60) $grade = 'B';
                elseif ($percentage >= 50) $grade = 'C';
                elseif ($percentage >= 40) $grade = 'D';
                else $grade = 'F';
                
                $insert_query = "INSERT INTO exam_results (student_id, exam_id, subject_id, class_id, section_id, ca_score, exam_score, percentage, grade, recorded_by, recorded_at) 
                                 VALUES ($student_id, $exam_id, $subject_id, $class_id, $section_id, $ca_score, $exam_score, $percentage, '$grade', {$_SESSION['user_id']}, NOW())
                                 ON DUPLICATE KEY UPDATE 
                                 ca_score = $ca_score, 
                                 exam_score = $exam_score, 
                                 percentage = $percentage, 
                                 grade = '$grade', 
                                 recorded_by = {$_SESSION['user_id']}, 
                                 recorded_at = NOW()";
                mysqli_query($conn, $insert_query);
            }
            
            // Commit transaction
            mysqli_commit($conn);
            $success = "Scores recorded successfully!";
            
        } catch (Exception $e) {
            // Rollback transaction on error
            mysqli_rollback($conn);
            $error = "Error recording scores: " . $e->getMessage();
        }
    }
}

// Get class, section, exam, and subject names for display
$class_name = '';
$section_name = '';
$exam_name = '';
$subject_name = '';

if ($class_id > 0) {
    $class_name_query = "SELECT class_name FROM classes WHERE id = $class_id";
    $class_name_result = mysqli_query($conn, $class_name_query);
    if ($class_name_result && mysqli_num_rows($class_name_result) > 0) {
        $class_name = mysqli_fetch_assoc($class_name_result)['class_name'];
    }
}

if ($section_id > 0) {
    $section_name_query = "SELECT section_name FROM sections WHERE id = $section_id";
    $section_name_result = mysqli_query($conn, $section_name_query);
    if ($section_name_result && mysqli_num_rows($section_name_result) > 0) {
        $section_name = mysqli_fetch_assoc($section_name_result)['section_name'];
    }
}

if ($exam_id > 0) {
    $exam_name_query = "SELECT exam_name FROM exams WHERE id = $exam_id";
    $exam_name_result = mysqli_query($conn, $exam_name_query);
    if ($exam_name_result && mysqli_num_rows($exam_name_result) > 0) {
        $exam_name = mysqli_fetch_assoc($exam_name_result)['exam_name'];
    }
}

if ($subject_id > 0) {
    $subject_name_query = "SELECT subject_name FROM subjects WHERE id = $subject_id";
    $subject_name_result = mysqli_query($conn, $subject_name_query);
    if ($subject_name_result && mysqli_num_rows($subject_name_result) > 0) {
        $subject_name = mysqli_fetch_assoc($subject_name_result)['subject_name'];
    }
}
?>

<div class="bg-white p-6 ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Student Score Management</h2>
    </div>

    <?php if (!empty($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo $success; ?>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>

    <!-- Filter Section -->
    <div class="mb-6 bg-gray-50 p-4 ">
        <form method="GET" action="" class="grid grid-cols-1 md:grid-cols-5 gap-4">
            <!-- Class Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Select Class</label>
                <select name="class_id" id="class_filter" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    <option value="">Select Class</option>
                    <?php 
                    // Reset pointer and loop through classes again
                    mysqli_data_seek($classes_result, 0);
                    while ($class = mysqli_fetch_assoc($classes_result)): 
                    ?>
                        <option value="<?php echo $class['id']; ?>" <?php echo ($class_id == $class['id']) ? 'selected' : ''; ?>>
                            <?php echo $class['class_name']; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <!-- Section Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Select Section</label>
                <select name="section_id" id="section_filter" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" <?php echo ($class_id == 0) ? 'disabled' : ''; ?> required>
                    <option value="">Select Section</option>
                    <?php foreach ($sections as $section): ?>
                        <option value="<?php echo $section['id']; ?>" <?php echo ($section_id == $section['id']) ? 'selected' : ''; ?>>
                            <?php echo $section['section_name']; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <!-- Exam Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Select Exam</label>
                <select name="exam_id" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    <option value="">Select Exam</option>
                    <?php 
                    // Reset pointer and loop through exams again
                    mysqli_data_seek($exams_result, 0);
                    while ($exam = mysqli_fetch_assoc($exams_result)): 
                    ?>
                        <option value="<?php echo $exam['id']; ?>" <?php echo ($exam_id == $exam['id']) ? 'selected' : ''; ?>>
                            <?php echo $exam['exam_name']; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <!-- Subject Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Select Subject</label>
                <select name="subject_id" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    <option value="">Select Subject</option>
                    <?php 
                    // Reset pointer and loop through subjects again
                    mysqli_data_seek($subjects_result, 0);
                    while ($subject = mysqli_fetch_assoc($subjects_result)): 
                    ?>
                        <option value="<?php echo $subject['id']; ?>" <?php echo ($subject_id == $subject['id']) ? 'selected' : ''; ?>>
                            <?php echo $subject['subject_name']; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <!-- Buttons -->
            <div class="flex items-end space-x-2">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2  flex items-center h-10">
                    <i class="fas fa-filter mr-2"></i> Load Students
                </button>
                <a href="add_score.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2  flex items-center h-10">
                    <i class="fas fa-times mr-2"></i> Clear
                </a>
            </div>
        </form>
    </div>

    <?php if ($class_id > 0 && $section_id > 0 && $exam_id > 0 && $subject_id > 0): ?>
        <!-- Score Form -->
        <div class="mb-6 bg-white p-4  ">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-semibold text-gray-800">
                    Enter Scores for 
                    <?php 
                    echo $class_name . " - " . $section_name . " - " . $exam_name . " - " . $subject_name;
                    if ($exam_details && $exam_details['total_marks'] > 0) {
                        echo " (Total Marks: " . $exam_details['total_marks'] . ")";
                    }
                    ?>
                </h3>
                
                <?php if ($scores_exist): ?>
                    <span class="bg-blue-100 text-blue-800 text-xs font-medium px-2.5 py-0.5 rounded-full">
                        <i class="fas fa-info-circle mr-1"></i> Scores already recorded for this exam
                    </span>
                <?php endif; ?>
            </div>
            
            <?php if (!empty($students)): ?>
                <form method="POST" action="">
                    <input type="hidden" name="class_id" value="<?php echo $class_id; ?>">
                    <input type="hidden" name="section_id" value="<?php echo $section_id; ?>">
                    <input type="hidden" name="exam_id" value="<?php echo $exam_id; ?>">
                    <input type="hidden" name="subject_id" value="<?php echo $subject_id; ?>">
                    
                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-200 text-gray-700">
                                <tr>
                                    <th class="py-3 px-4 text-left">Roll No</th>
                                    <th class="py-3 px-4 text-left">Student ID</th>
                                    <th class="py-3 px-4 text-left">Name</th>
                                    <th class="py-3 px-4 text-left">CA Score</th>
                                    <th class="py-3 px-4 text-left">Exam Score</th>
                                    <th class="py-3 px-4 text-left">Total</th>
                                    <?php if ($exam_details && $exam_details['total_marks'] > 0): ?>
                                        <th class="py-3 px-4 text-left">Percentage</th>
                                        <th class="py-3 px-4 text-left">Grade</th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600">
                                <?php foreach ($students as $student): 
                                    // FIX: Convert empty strings to 0 to prevent addition errors
                                    $existing_ca = isset($existing_scores[$student['id']]['ca_score']) ? 
                                        (is_numeric($existing_scores[$student['id']]['ca_score']) ? $existing_scores[$student['id']]['ca_score'] : 0) : 0;
                                    $existing_exam = isset($existing_scores[$student['id']]['exam_score']) ? 
                                        (is_numeric($existing_scores[$student['id']]['exam_score']) ? $existing_scores[$student['id']]['exam_score'] : 0) : 0;
                                    
                                    $total_marks = $existing_ca + $existing_exam;
                                    $percentage = 0;
                                    $grade = '';
                                    
                                    if ($exam_details && $exam_details['total_marks'] > 0 && $total_marks > 0) {
                                        $percentage = ($total_marks / $exam_details['total_marks']) * 100;
                                        
                                        // Determine grade based on percentage
                                        if ($percentage >= 90) $grade = 'A+';
                                        elseif ($percentage >= 80) $grade = 'A';
                                        elseif ($percentage >= 70) $grade = 'B+';
                                        elseif ($percentage >= 60) $grade = 'B';
                                        elseif ($percentage >= 50) $grade = 'C';
                                        elseif ($percentage >= 40) $grade = 'D';
                                        else $grade = 'F';
                                    }
                                ?>
                                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                                        <td class="py-3 px-4"><?php echo $student['roll_number']; ?></td>
                                        <td class="py-3 px-4"><?php echo $student['student_id']; ?></td>
                                        <td class="py-3 px-4"><?php echo $student['full_name']; ?></td>
                                        <td class="py-3 px-4">
                                            <input type="number" 
                                                   name="ca_scores[<?php echo $student['id']; ?>]" 
                                                   value="<?php echo $existing_ca; ?>" 
                                                   step="0.01" 
                                                   min="0" 
                                                   class="w-20 px-2 py-1 border rounded focus:outline-none focus:ring-1 focus:ring-blue-500"
                                                   required>
                                        </td>
                                        <td class="py-3 px-4">
                                            <input type="number" 
                                                   name="exam_scores[<?php echo $student['id']; ?>]" 
                                                   value="<?php echo $existing_exam; ?>" 
                                                   step="0.01" 
                                                   min="0" 
                                                   class="w-20 px-2 py-1 border rounded focus:outline-none focus:ring-1 focus:ring-blue-500"
                                                   required>
                                        </td>
                                        <td class="py-3 px-4 font-medium">
                                            <?php echo $total_marks > 0 ? number_format($total_marks, 2) : '0.00'; ?>
                                        </td>
                                        <?php if ($exam_details && $exam_details['total_marks'] > 0): ?>
                                            <td class="py-3 px-4">
                                                <?php echo $total_marks > 0 ? number_format($percentage, 2) . '%' : '0.00%'; ?>
                                            </td>
                                            <td class="py-3 px-4">
                                                <?php echo $grade ?: '-'; ?>
                                            </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-6 flex justify-center">
                        <button type="submit" name="submit_scores" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2  flex items-center">
                            <i class="fas fa-save mr-2"></i> Save Scores
                        </button>
                    </div>
                </form>
            <?php else: ?>
                <p class="text-center py-4 text-gray-500">
                    No students found in this class and section.
                </p>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <div class="bg-white p-8   text-center">
            <i class="fas fa-chart-bar text-4xl text-gray-300 mb-4"></i>
            <h3 class="text-lg font-medium text-gray-600">Please select class, section, exam, and subject to enter scores</h3>
        </div>
    <?php endif; ?>
</div>

<script>
// JavaScript to handle dynamic section loading based on class selection
document.getElementById('class_filter').addEventListener('change', function() {
    const classId = this.value;
    const sectionSelect = document.getElementById('section_filter');
    
    if (classId) {
        // Enable section dropdown
        sectionSelect.disabled = false;
        
        // Fetch sections for the selected class via AJAX
        fetch('get_section.php?class_id=' + classId)
            .then(response => response.json())
            .then(sections => {
                // Clear existing options except the first one
                while (sectionSelect.options.length > 1) {
                    sectionSelect.remove(1);
                }
                
                // Add new options
                sections.forEach(section => {
                    const option = document.createElement('option');
                    option.value = section.id;
                    option.textContent = section.section_name;
                    sectionSelect.appendChild(option);
                });
            })
            .catch(error => console.error('Error fetching sections:', error));
    } else {
        // Disable and clear section dropdown if no class is selected
        sectionSelect.disabled = true;
        while (sectionSelect.options.length > 1) {
            sectionSelect.remove(1);
        }
    }
});

// Auto-calculate totals when scores are entered
document.addEventListener('DOMContentLoaded', function() {
    const caInputs = document.querySelectorAll('input[name^="ca_scores"]');
    const examInputs = document.querySelectorAll('input[name^="exam_scores"]');
    
    // Function to calculate and update totals
    function updateTotals() {
        for (let i = 0; i < caInputs.length; i++) {
            const row = caInputs[i].closest('tr');
            const caScore = parseFloat(caInputs[i].value) || 0;
            const examScore = parseFloat(examInputs[i].value) || 0;
            
            const total = caScore + examScore;
            
            // Update total cell
            const totalCell = row.querySelector('td:nth-child(6)');
            if (totalCell) totalCell.textContent = total.toFixed(2);
            
            // Update percentage and grade if applicable
            const percentageCell = row.querySelector('td:nth-child(7)');
            const gradeCell = row.querySelector('td:nth-child(8)');
            
            if (percentageCell && gradeCell && <?php echo $exam_details && $exam_details['total_marks'] > 0 ? 'true' : 'false'; ?>) {
                const totalMarks = <?php echo $exam_details['total_marks'] ?? 0; ?>;
                if (totalMarks > 0) {
                    const percentage = (total / totalMarks) * 100;
                    percentageCell.textContent = percentage.toFixed(2) + '%';
                    
                    // Determine grade
                    let grade = '';
                    if (percentage >= 90) grade = 'A+';
                    else if (percentage >= 80) grade = 'A';
                    else if (percentage >= 70) grade = 'B+';
                    else if (percentage >= 60) grade = 'B';
                    else if (percentage >= 50) grade = 'C';
                    else if (percentage >= 40) grade = 'D';
                    else grade = 'F';
                    
                    gradeCell.textContent = grade;
                }
            }
        }
    }
    
    // Add event listeners to all score inputs
    caInputs.forEach(input => input.addEventListener('input', updateTotals));
    examInputs.forEach(input => input.addEventListener('input', updateTotals));
});
</script>

<?php
include 'include/footer.php';
ob_end_flush();
?>