<?php
session_start();
include '../config/conn.php';
require '../vendor/autoload.php';

use Endroid\QrCode\QrCode;
use Endroid\QrCode\Writer\SvgWriter;

header('Content-Type: application/json');

// Enable error reporting for debugging (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not authorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $qr_class_id = intval($_POST['qr_class_id']);
        $qr_section_id = intval($_POST['qr_section_id']);
        $qr_token = bin2hex(random_bytes(16));

        // Set expiry time to 1 year
        $expiry_time = date('Y-m-d H:i:s', strtotime('+1 year'));
        
        // Insert token
        $insert_result = mysqli_query($conn, "INSERT INTO qr_attendance_tokens (token, class_id, section_id, expiry_time, created_by, is_yearly) 
                             VALUES ('$qr_token', '$qr_class_id', '$qr_section_id', '$expiry_time', {$_SESSION['user_id']}, 1)");
        
        if (!$insert_result) {
            throw new Exception('Database insert failed: ' . mysqli_error($conn));
        }

        // Generate dynamic URL (FIXED - remove localhost)
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'];
        $target_url = $protocol . "://" . $host . "/mobile_attendances.php?token=$qr_token";
        
        // Generate QR code
        $qr_code = new QrCode($target_url);
        $qr_code->setSize(300);
        $qr_code->setMargin(10);

        $writer = new SvgWriter();
        $result = $writer->write($qr_code);
        
        // Create directory with proper permissions (relative to current admin directory)
        $qr_dir = __DIR__ . '/qr_codes'; // This points to admin/qr_codes/
        
        if (!file_exists($qr_dir)) {
            if (!mkdir($qr_dir, 0755, true)) {
                throw new Exception('Failed to create QR directory: ' . $qr_dir);
            }
        }

        if (!is_writable($qr_dir)) {
            throw new Exception('QR directory is not writable: ' . $qr_dir);
        }

        // Save QR code
        $qr_filename = $qr_dir . '/' . $qr_token . '.svg';
        $file_result = file_put_contents($qr_filename, $result->getString());
        
        if ($file_result === false) {
            throw new Exception('Failed to save QR code file: ' . $qr_filename);
        }

        // Web-accessible path for response (relative to your script)
        $web_filename = 'qr_codes/' . $qr_token . '.svg';

        echo json_encode([
            'success' => true,
            'message' => 'Yearly QR code generated successfully! This code will be valid for 1 year.',
            'qr_filename' => $web_filename,
            'expiry_time' => $expiry_time,
            'alternative_url' => $target_url
        ]);

    } catch (Exception $e) {
        error_log("QR Generation Error: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
?>