<?php
session_start();
include '../config/conn.php';
require '../vendor/autoload.php';

use Endroid\QrCode\QrCode;
use Endroid\QrCode\Writer\SvgWriter;

header('Content-Type: application/json');

// Enable error reporting for debugging but don't display errors
error_reporting(E_ALL);
ini_set('display_errors', 0);

// Check authorization

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not authorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $qr_token = bin2hex(random_bytes(16));

        // Set expiry time to exactly 1 year from now
        $expiry_time = date('Y-m-d H:i:s', strtotime('+1 year'));
        
        // Check if the required columns exist
        $check_column = mysqli_query($conn, "SHOW COLUMNS FROM qr_attendance_tokens LIKE 'expiry_time'");
        if (mysqli_num_rows($check_column) === 0) {
            throw new Exception('Database column "expiry_time" does not exist. Please run the SQL migration first.');
        }
        
        // Insert token into database for teachers
        $user_id = mysqli_real_escape_string($conn, $_SESSION['user_id']);
        $insert_query = "INSERT INTO qr_attendance_tokens (token, expiry_time, created_by, is_teacher) 
                         VALUES ('$qr_token', '$expiry_time', '$user_id', 1)";
        
        $insert_result = mysqli_query($conn, $insert_query);
        
        if (!$insert_result) {
            throw new Exception('Database insert failed: ' . mysqli_error($conn));
        }

        // Generate dynamic URL for teacher attendance
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'];
        
        // Get the correct base path
        $base_path = rtrim(dirname(dirname($_SERVER['SCRIPT_NAME'])), '/');
        if ($base_path === '\\' || $base_path === '/') {
            $base_path = '';
        }
        
        // URL for teacher mobile attendance
        $target_url = $protocol . "://" . $host . $base_path . "/mobile_attendance.php?token=$qr_token";
        
        // Generate QR code
        $qr_code = new QrCode($target_url);
        $qr_code->setSize(300);
        $qr_code->setMargin(10);

        $writer = new SvgWriter();
        $result = $writer->write($qr_code);
        
        // Create directory with proper permissions
        $qr_dir = __DIR__ . '/qr_codes';
        
        if (!file_exists($qr_dir)) {
            if (!mkdir($qr_dir, 0755, true)) {
                throw new Exception('Failed to create QR directory: ' . $qr_dir);
            }
        }

        if (!is_writable($qr_dir)) {
            throw new Exception('QR directory is not writable: ' . $qr_dir);
        }

        // Save QR code
        $qr_filename = $qr_dir . '/' . $qr_token . '.svg';
        $file_result = file_put_contents($qr_filename, $result->getString());
        
        if ($file_result === false) {
            throw new Exception('Failed to save QR code file: ' . $qr_filename);
        }

        // Web-accessible path for response
        $web_filename = 'qr_codes/' . $qr_token . '.svg';

        echo json_encode([
            'success' => true,
            'message' => 'Teacher QR code generated successfully! Valid for 1 year until ' . date('F j, Y', strtotime($expiry_time)),
            'qr_filename' => $web_filename,
            'expiry_time' => $expiry_time,
            'alternative_url' => $target_url,
            'token' => $qr_token
        ]);

    } catch (Exception $e) {
        error_log("Teacher QR Generation Error: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}

mysqli_close($conn);
?>