<?php
session_start();
include '../config/conn.php';

// Check if logged in
if (!isset($_SESSION['user_id'])) {
    echo '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">Unauthorized access</div>';
    exit();
}

$attendance_date = isset($_POST['attendance_date']) ? $_POST['attendance_date'] : date('Y-m-d');

// Fetch teachers
$teachers_query = "SELECT id, teacher_id, full_name, email FROM users WHERE role = 'teacher' AND status = 'active' ORDER BY full_name";
$teachers_result = mysqli_query($conn, $teachers_query);

// Check existing attendance
$existing_attendance = [];
$attendance_exists = false;
if (!empty($attendance_date)) {
    $check_attendance_query = "SELECT teacher_id, status, recorded_at 
                               FROM teacher_attendance 
                               WHERE attendance_date = '$attendance_date'";
    $check_attendance_result = mysqli_query($conn, $check_attendance_query);
    if ($check_attendance_result) {
        if (mysqli_num_rows($check_attendance_result) > 0) {
            $attendance_exists = true;
            while ($row = mysqli_fetch_assoc($check_attendance_result)) {
                $existing_attendance[$row['teacher_id']] = $row;
            }
        }
    }
}

if (mysqli_num_rows($teachers_result) > 0): ?>
    <!-- Attendance Form -->
    <div class="mb-6 bg-white p-4 rounded-lg shadow">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-lg font-semibold text-gray-800">
                Mark Teacher Attendance for <?php echo date('d M Y', strtotime($attendance_date)); ?>
            </h3>
            
            <?php if ($attendance_exists): ?>
                <span class="bg-blue-100 text-blue-800 text-xs font-medium px-2.5 py-0.5 rounded-full">
                    <i class="fas fa-info-circle mr-1"></i> Attendance already recorded for this date
                </span>
            <?php endif; ?>
        </div>
        
        <form id="attendance-form" method="POST" action="">
            <input type="hidden" name="attendance_date" value="<?php echo $attendance_date; ?>">
            <input type="hidden" name="submit_attendance" value="1">
            
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white">
                    <thead class="bg-gray-200 text-gray-700">
                        <tr>
                            <th class="py-3 px-4 text-left">Teacher ID</th>
                            <th class="py-3 px-4 text-left">Name</th>
                            <th class="py-3 px-4 text-left">Status</th>
                            <th class="py-3 px-4 text-left">Time</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-600">
                        <?php 
                        while ($teacher = mysqli_fetch_assoc($teachers_result)): 
                            $status = isset($existing_attendance[$teacher['id']]) ? $existing_attendance[$teacher['id']]['status'] : '';
                            $time = isset($existing_attendance[$teacher['id']]) ? date('H:i', strtotime($existing_attendance[$teacher['id']]['recorded_at'])) : '';
                        ?>
                            <tr class="border-b border-gray-200 hover:bg-gray-50">
                                <td class="py-3 px-4"><?php echo $teacher['teacher_id']; ?></td>
                                <td class="py-3 px-4"><?php echo $teacher['full_name']; ?></td>
                                <td class="py-3 px-4">
                                    <div class="flex flex-wrap gap-4">
                                        <label class="inline-flex items-center">
                                            <input type="radio" name="attendance[<?php echo $teacher['id']; ?>]" value="present" 
                                                <?php echo ($status == 'present') ? 'checked' : 'checked'; ?> 
                                                class="form-radio h-4 w-4 text-green-600">
                                            <span class="ml-2 text-green-600">Present</span>
                                        </label>
                                        <label class="inline-flex items-center">
                                            <input type="radio" name="attendance[<?php echo $teacher['id']; ?>]" value="absent" 
                                                <?php echo ($status == 'absent') ? 'checked' : ''; ?> 
                                                class="form-radio h-4 w-4 text-red-600">
                                            <span class="ml-2 text-red-600">Absent</span>
                                        </label>
                                        <label class="inline-flex items-center">
                                            <input type="radio" name="attendance[<?php echo $teacher['id']; ?>]" value="late" 
                                                <?php echo ($status == 'late') ? 'checked' : ''; ?> 
                                                class="form-radio h-4 w-4 text-yellow-600">
                                            <span class="ml-2 text-yellow-600">Late</span>
                                        </label>
                                        <label class="inline-flex items-center">
                                            <input type="radio" name="attendance[<?php echo $teacher['id']; ?>]" value="half_day" 
                                                <?php echo ($status == 'half_day') ? 'checked' : ''; ?> 
                                                class="form-radio h-4 w-4 text-purple-600">
                                            <span class="ml-2 text-purple-600">Half Day</span>
                                        </label>
                                    </div>
                                </td>
                                <td class="py-3 px-4">
                                    <?php if (!empty($time)): ?>
                                        <span class="attendance-status status-<?php echo $status; ?>">
                                            <?php echo $time; ?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
            
            <div class="mt-6 flex justify-center space-x-4">
                <button type="button" onclick="selectAllPresent()" class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded">
                    <i class="fas fa-check-circle mr-2"></i> Mark All Present
                </button>
                <button type="button" onclick="selectAllAbsent()" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded">
                    <i class="fas fa-times-circle mr-2"></i> Mark All Absent
                </button>
                <button type="submit" id="save-attendance-btn" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded flex items-center">
                    <i class="fas fa-save mr-2"></i> Save Attendance
                </button>
            </div>
        </form>
    </div>
<?php else: ?>
    <p class="text-center py-4 text-gray-500">
        No active teachers found.
    </p>
<?php endif; ?>

<?php mysqli_close($conn); ?>