<?php
include '../config/conn.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_class = mysqli_real_escape_string($conn, $_POST['current_class']);
    $current_section = mysqli_real_escape_string($conn, $_POST['current_section']);
    $target_class = mysqli_real_escape_string($conn, $_POST['target_class']);
    $target_section = mysqli_real_escape_string($conn, $_POST['target_section']);
    
    if (isset($_POST['student_ids']) && is_array($_POST['student_ids']) && !empty($_POST['student_ids'])) {
        $student_ids = array_map(function($id) use ($conn) {
            return mysqli_real_escape_string($conn, $id);
        }, $_POST['student_ids']);
        
        $ids_string = "'" . implode("','", $student_ids) . "'";
        
        // Update students with new class and section
        $update_query = "UPDATE students SET class = '$target_class', section = '$target_section' 
                         WHERE id IN ($ids_string) AND class = '$current_class' AND section = '$current_section'";
        
        if (mysqli_query($conn, $update_query)) {
            $affected_rows = mysqli_affected_rows($conn);
            echo json_encode([
                'success' => true,
                'message' => "Successfully promoted $affected_rows student(s) to new class!"
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => "Error promoting students: " . mysqli_error($conn)
            ]);
        }
    } else {
        echo json_encode([
            'success' => false,
            'message' => "Please select at least one student to promote."
        ]);
    }
} else {
    echo json_encode([
        'success' => false,
        'message' => "Invalid request method."
    ]);
}
?>