<?php
// ajax_questions.php
include '../config/conn.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not authorized']);
    exit();
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

if ($action === 'add_question' || $action === 'update_question') {
    $quiz_id = intval($_POST['quiz_id']);
    $question_text = mysqli_real_escape_string($conn, $_POST['question_text']);
    $question_type = $_POST['question_type'];
    $marks = floatval($_POST['marks']);
    
    if (empty($question_text) || empty($quiz_id)) {
        echo json_encode(['success' => false, 'message' => 'Please enter question text.']);
        exit();
    }
    
    if ($action === 'add_question') {
        // Insert question
        $insert_question = "INSERT INTO quiz_questions (quiz_id, question_text, question_type, marks, created_at) 
                            VALUES ($quiz_id, '$question_text', '$question_type', $marks, NOW())";
        
        if (mysqli_query($conn, $insert_question)) {
            $question_id = mysqli_insert_id($conn);
            $message = "Question added successfully!";
        } else {
            echo json_encode(['success' => false, 'message' => 'Error adding question: ' . mysqli_error($conn)]);
            exit();
        }
    } else {
        // Update question
        $question_id = intval($_POST['question_id']);
        $update_question = "UPDATE quiz_questions SET 
                            question_text = '$question_text', 
                            question_type = '$question_type', 
                            marks = $marks 
                            WHERE id = $question_id";
        
        if (!mysqli_query($conn, $update_question)) {
            echo json_encode(['success' => false, 'message' => 'Error updating question: ' . mysqli_error($conn)]);
            exit();
        }
        $message = "Question updated successfully!";
    }
    
    // Delete existing options if updating
    if ($action === 'update_question') {
        $delete_options = "DELETE FROM quiz_question_options WHERE question_id = $question_id";
        mysqli_query($conn, $delete_options);
    }
    
    // Handle options based on question type
    if ($question_type === 'multiple_choice') {
        $options = $_POST['options'];
        $correct_answer = intval($_POST['correct_answer']);
        
        foreach ($options as $index => $option_text) {
            if (!empty(trim($option_text))) {
                $is_correct = ($index == $correct_answer) ? 1 : 0;
                $option_text = mysqli_real_escape_string($conn, $option_text);
                
                $insert_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                                  VALUES ($question_id, '$option_text', $is_correct)";
                mysqli_query($conn, $insert_option);
            }
        }
    } else if ($question_type === 'true_false') {
        $correct_answer = $_POST['true_false_answer'];
        
        // Add both True and False options, mark the correct one
        $true_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                        VALUES ($question_id, 'True', " . ($correct_answer === 'true' ? 1 : 0) . ")";
        mysqli_query($conn, $true_option);
        
        $false_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                         VALUES ($question_id, 'False', " . ($correct_answer === 'false' ? 1 : 0) . ")";
        mysqli_query($conn, $false_option);
    } else if ($question_type === 'short_answer') {
        $expected_answer = mysqli_real_escape_string($conn, $_POST['short_answer']);
        if (!empty($expected_answer)) {
            $insert_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                              VALUES ($question_id, '$expected_answer', 1)";
            mysqli_query($conn, $insert_option);
        }
    } else if ($question_type === 'essay') {
        $guidelines = mysqli_real_escape_string($conn, $_POST['essay_guidelines']);
        if (!empty($guidelines)) {
            $insert_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                              VALUES ($question_id, '$guidelines', 1)";
            mysqli_query($conn, $insert_option);
        }
    }
    
    echo json_encode(['success' => true, 'message' => $message]);
    
} elseif ($action === 'delete_question') {
    $question_id = intval($_POST['question_id']);
    
    // First delete related answers
    $delete_answers_query = "DELETE FROM quiz_answers WHERE option_id IN (
        SELECT id FROM quiz_question_options WHERE question_id = $question_id
    )";
    mysqli_query($conn, $delete_answers_query);
    
    // Then delete related options
    $delete_options_query = "DELETE FROM quiz_question_options WHERE question_id = $question_id";
    mysqli_query($conn, $delete_options_query);
    
    // Then delete the question
    $delete_query = "DELETE FROM quiz_questions WHERE id = $question_id";
    if (mysqli_query($conn, $delete_query)) {
        echo json_encode(['success' => true, 'message' => 'Question deleted successfully!']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error deleting question: ' . mysqli_error($conn)]);
    }
    
} elseif ($action === 'get_questions') {
    $quiz_id = intval($_GET['quiz_id']);
    
    // Fetch questions for this quiz
    $questions_query = "SELECT * FROM quiz_questions WHERE quiz_id = $quiz_id ORDER BY created_at";
    $questions_result = mysqli_query($conn, $questions_query);
    $quiz_questions = [];
    
    while ($question = mysqli_fetch_assoc($questions_result)) {
        // Fetch options for all question types
        $options = [];
        $options_query = "SELECT * FROM quiz_question_options WHERE question_id = {$question['id']}";
        $options_result = mysqli_query($conn, $options_query);
        while ($option = mysqli_fetch_assoc($options_result)) {
            $options[] = $option;
        }
        $question['options'] = $options;
        $quiz_questions[] = $question;
    }
    
    // Generate HTML for questions
    $html = '';
    if (!empty($quiz_questions)) {
        $html .= '<div class="space-y-4">';
        foreach ($quiz_questions as $index => $question) {
            $html .= '<div class="p-4 border rounded-lg" id="question-' . $question['id'] . '">';
            $html .= '<div class="flex justify-between items-start mb-2">';
            $html .= '<p class="font-medium">Q' . ($index + 1) . ': ' . $question['question_text'] . '</p>';
            $html .= '<span class="bg-gray-200 text-gray-700 text-xs font-medium px-2 py-1 rounded">';
            $html .= ucfirst(str_replace('_', ' ', $question['question_type'])) . ' (' . $question['marks'] . ' marks)';
            $html .= '</span>';
            $html .= '</div>';
            
            if ($question['question_type'] === 'multiple_choice' && !empty($question['options'])) {
                $html .= '<div class="ml-4 mt-2">';
                foreach ($question['options'] as $option) {
                    $html .= '<div class="flex items-center mb-1">';
                    $html .= '<input type="radio" ' . ($option['is_correct'] ? 'checked' : '') . ' disabled class="mr-2">';
                    $html .= '<span>' . $option['option_text'] . '</span>';
                    $html .= '</div>';
                }
                $html .= '</div>';
            } elseif ($question['question_type'] === 'true_false' && !empty($question['options'])) {
                $html .= '<div class="ml-4 mt-2">';
                foreach ($question['options'] as $option) {
                    $html .= '<div class="flex items-center mb-1">';
                    $html .= '<input type="radio" ' . ($option['is_correct'] ? 'checked' : '') . ' disabled class="mr-2">';
                    $html .= '<span>' . $option['option_text'] . '</span>';
                    $html .= '</div>';
                }
                $html .= '</div>';
            } elseif ($question['question_type'] === 'short_answer' && !empty($question['options'])) {
                $html .= '<div class="ml-4 mt-2">';
                foreach ($question['options'] as $option) {
                    $html .= '<div class="mb-1">';
                    $html .= '<span class="text-sm font-medium">Expected answer:</span>';
                    $html .= '<p class="text-sm">' . $option['option_text'] . '</p>';
                    $html .= '</div>';
                }
                $html .= '</div>';
            } elseif ($question['question_type'] === 'essay' && !empty($question['options'])) {
                $html .= '<div class="ml-4 mt-2">';
                foreach ($question['options'] as $option) {
                    $html .= '<div class="mb-1">';
                    $html .= '<span class="text-sm font-medium">Guidelines:</span>';
                    $html .= '<p class="text-sm">' . $option['option_text'] . '</p>';
                    $html .= '</div>';
                }
                $html .= '</div>';
            }
            
            $html .= '<div class="mt-3 flex justify-end space-x-2">';
            $html .= '<a href="quiz.php?action=add_questions&quiz_id=' . $quiz_id . '&question_id=' . $question['id'] . '" class="text-yellow-600 hover:text-yellow-800 text-sm">';
            $html .= '<i class="fas fa-edit mr-1"></i> Edit';
            $html .= '</a>';
            $html .= '<a href="#" class="text-red-600 hover:text-red-800 text-sm delete-question" data-id="' . $question['id'] . '">';
            $html .= '<i class="fas fa-trash mr-1"></i> Delete';
            $html .= '</a>';
            $html .= '</div>';
            $html .= '</div>';
        }
        $html .= '</div>';
    } else {
        $html = '<p class="text-center py-4 text-gray-500">No questions added yet.</p>';
    }
    
    echo json_encode(['success' => true, 'html' => $html]);
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid action']);
}
?>