<?php
session_start();
include '../config/conn.php';

// Include PHPMailer
require '../vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not authorized']);
    exit;
}

// Function to send email notification
function sendAttendanceEmailNotification($student_name, $student_email, $attendance_date, $status, $class_name, $section_name) {
    // Get admin email from database
    global $conn;
    $admin_query = "SELECT email FROM users WHERE role = 'admin' LIMIT 1";
    $admin_result = mysqli_query($conn, $admin_query);
    
    if (mysqli_num_rows($admin_result) === 0) {
        error_log("No admin found in database");
        return false;
    }
    
    $admin = mysqli_fetch_assoc($admin_result);
    $admin_email = $admin['email'];
    
    $mail = new PHPMailer(true);
    try {
        // Server settings - Updated to use Adinoheightschool email
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'holuwaseunisrael@gmail.com';
        $mail->Password   = 'ceae tepn tfyx oxjn';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port       = 465;

        // Recipients - Updated with Adinoheightschool branding
        $mail->setFrom('attendance@adinoheightschool.com', 'Adinoheightschool Attendance System');
        $mail->addAddress($admin_email);
        if (!empty($student_email)) {
            $mail->addAddress($student_email);
        }
        $mail->addReplyTo('noreply@adinoheightschool.com', 'Adinoheightschool No Reply');

        // Content - Updated with Adinoheightschool branding
        $mail->isHTML(true);
        $mail->Subject = "Adinoheightschool Attendance - $student_name - $attendance_date";
        $mail->Body = "
        <html>
        <head>
            <title>Adinoheightschool Attendance Notification</title>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); color: white; padding: 20px; text-align: center; border-radius: 8px 8px 0 0; }
                .content { background-color: #f9fafb; padding: 25px; border-radius: 0 0 8px 8px; }
                .info-table { width: 100%; border-collapse: collapse; margin: 20px 0; }
                .info-table td { padding: 10px; border-bottom: 1px solid #e5e7eb; }
                .info-table tr:last-child td { border-bottom: none; }
                .status-present { color: #065f46; font-weight: bold; }
                .status-absent { color: #b91c1c; font-weight: bold; }
                .status-late { color: #9a3412; font-weight: bold; }
                .school-name { font-weight: bold; color: #1e40af; }
                .footer { background-color: #f3f4f6; padding: 15px; text-align: center; margin-top: 20px; border-radius: 8px; font-size: 12px; }
            </style>
        </head>
        <body>
            <div class='container'>
                <div class='header'>
                    <h2>Adinoheightschool Attendance System</h2>
                </div>
                <div class='content'>
                    <p>Hello,</p>
                    <p>Attendance has been recorded for <strong>$student_name</strong>.</p>
                    
                    <table class='info-table'>
                        <tr>
                            <td><strong>Student:</strong></td>
                            <td>$student_name</td>
                        </tr>
                        <tr>
                            <td><strong>Date:</strong></td>
                            <td>$attendance_date</td>
                        </tr>
                        <tr>
                            <td><strong>Class:</strong></td>
                            <td>$class_name - $section_name</td>
                        </tr>
                        <tr>
                            <td><strong>Status:</strong></td>
                            <td class='status-$status'>" . ucfirst($status) . "</td>
                        </tr>
                        <tr>
                            <td><strong>Recorded At:</strong></td>
                            <td>" . date('Y-m-d H:i:s') . "</td>
                        </tr>
                    </table>
                    
                    <p>If you believe this is an error, please contact the school administration.</p>
                </div>
                <div class='footer'>
                    <p>This is an automated notification from <span class='school-name'>Adinoheightschool</span></p>
                    <p>Please do not reply to this email</p>
                </div>
            </div>
        </body>
        </html>";
        
        return $mail->send();
    } catch (Exception $e) {
        error_log("Mailer Error: {$mail->ErrorInfo}");
        return false;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if required parameters are set
    if (!isset($_POST['attendance_date']) || !isset($_POST['class_id']) || !isset($_POST['section_id']) || !isset($_POST['attendance'])) {
        echo json_encode(['success' => false, 'message' => 'Missing required parameters']);
        exit;
    }
    
    $attendance_date = $_POST['attendance_date'];
    $class_id = intval($_POST['class_id']);
    $section_id = intval($_POST['section_id']);
    $attendance_data = $_POST['attendance'];
    
    // Validate date format
    if (!DateTime::createFromFormat('Y-m-d', $attendance_date)) {
        echo json_encode(['success' => false, 'message' => 'Invalid date format']);
        exit;
    }
    
    // Get class and section names for email
    $class_query = mysqli_query($conn, "SELECT class_name FROM classes WHERE id = $class_id");
    $section_query = mysqli_query($conn, "SELECT section_name FROM sections WHERE id = $section_id");
    
    if (!$class_query || !$section_query) {
        echo json_encode(['success' => false, 'message' => 'Error fetching class/section information']);
        exit;
    }
    
    $class_name = mysqli_fetch_assoc($class_query)['class_name'] ?? 'Unknown Class';
    $section_name = mysqli_fetch_assoc($section_query)['section_name'] ?? 'Unknown Section';
    
    if (!empty($attendance_data) && $class_id > 0 && $section_id > 0) {
        mysqli_begin_transaction($conn);
        try {
            // Delete existing attendance for this date, class, and section
            $delete_query = "DELETE FROM attendance WHERE attendance_date = '$attendance_date' AND class_id = $class_id AND section_id = $section_id";
            if (!mysqli_query($conn, $delete_query)) {
                throw new Exception("Error deleting existing attendance: " . mysqli_error($conn));
            }
            
            // Array to track email sending results
            $email_results = [];
            
            foreach ($attendance_data as $student_id => $status) {
                $student_id = intval($student_id);
                $status = mysqli_real_escape_string($conn, $status);
                
                // Validate status
                $valid_statuses = ['present', 'absent', 'late', 'half_day'];
                if (!in_array($status, $valid_statuses)) {
                    continue; // Skip invalid status
                }
                
                // Insert attendance record
                $insert_query = "INSERT INTO attendance (student_id, class_id, section_id, attendance_date, status, recorded_by, recorded_at) 
                                VALUES ($student_id, $class_id, $section_id, '$attendance_date', '$status', {$_SESSION['user_id']}, NOW())";
                
                if (!mysqli_query($conn, $insert_query)) {
                    throw new Exception("Error inserting attendance: " . mysqli_error($conn));
                }
                
                // Get student details for email notification
                $student_query = mysqli_query($conn, "SELECT full_name, email FROM students WHERE id = $student_id");
                if ($student_query && mysqli_num_rows($student_query) > 0) {
                    $student = mysqli_fetch_assoc($student_query);
                    
                    // Send email notification (only for present/late status to avoid spam)
                    if ($status === 'present' || $status === 'late') {
                        $email_sent = sendAttendanceEmailNotification(
                            $student['full_name'],
                            $student['email'],
                            $attendance_date,
                            $status,
                            $class_name,
                            $section_name
                        );
                        
                        $email_results[$student_id] = $email_sent;
                    }
                }
            }
            
            mysqli_commit($conn);
            
            // Count successful emails
            $successful_emails = count(array_filter($email_results));
            $total_emails = count($email_results);
            
            $message = 'Attendance recorded successfully!';
            if ($total_emails > 0) {
                $message .= " Emails sent: $successful_emails/$total_emails";
            }
            
            echo json_encode(['success' => true, 'message' => $message, 'emails_sent' => $successful_emails]);
            
        } catch (Exception $e) {
            mysqli_rollback($conn);
            error_log("Attendance Error: " . $e->getMessage());
            echo json_encode(['success' => false, 'message' => 'Error recording attendance: ' . $e->getMessage()]);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'No attendance data submitted or invalid class/section.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
?>