<?php
session_start();
include '../config/conn.php';

header('Content-Type: application/json');

// Check if logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit();
}

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_attendance'])) {
    $attendance_date = $_POST['attendance_date'];
    $attendance_data = $_POST['attendance'];
    
    if (!empty($attendance_data)) {
        mysqli_begin_transaction($conn);
        try {
            // Delete existing attendance for this date
            $delete_query = "DELETE FROM teacher_attendance WHERE attendance_date = '$attendance_date'";
            if (!mysqli_query($conn, $delete_query)) {
                throw new Exception("Error deleting existing attendance: " . mysqli_error($conn));
            }
            
            // Get current time for late calculation
            $current_time = date('H:i:s');
            
            foreach ($attendance_data as $teacher_id => $status) {
                $teacher_id = intval($teacher_id);
                $status = mysqli_real_escape_string($conn, $status);
                
                $insert_query = "INSERT INTO teacher_attendance (teacher_id, attendance_date, status, recorded_by, recorded_at) 
                                VALUES ($teacher_id, '$attendance_date', '$status', {$_SESSION['user_id']}, NOW())";
                if (!mysqli_query($conn, $insert_query)) {
                    throw new Exception("Error inserting attendance: " . mysqli_error($conn));
                }
            }
            
            mysqli_commit($conn);
            $response = ['success' => true, 'message' => 'Teacher attendance recorded successfully!'];
        } catch (Exception $e) {
            mysqli_rollback($conn);
            $response = ['success' => false, 'message' => 'Error recording attendance: ' . $e->getMessage()];
        }
    } else {
        $response = ['success' => false, 'message' => 'No attendance data submitted.'];
    }
} else {
    $response = ['success' => false, 'message' => 'Invalid request.'];
}

echo json_encode($response);
mysqli_close($conn);
?>