<?php
// Enable output buffering
ob_start();

// Secure session cookie parameters


// Start session
session_start();

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// Check session expiry (1 hour)
$inactive = 3600;
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $inactive)) {
    session_unset();
    session_destroy();
    header("Location: ../login.php?timeout=1");
    exit();
}
$_SESSION['last_activity'] = time();

// Restrict to admin only
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
    header("Location: ../login.php?access=denied");
    exit();
}

// ✅ Fetch admin details from database
include '../config/conn.php';
$user_id = $_SESSION['user_id'];

// Fetch name, role, and image (admin column)
$query = "SELECT full_name, role, image FROM users WHERE id = ? LIMIT 1";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $admin = $result->fetch_assoc();
    $user_name  = $admin['full_name'];
    $user_role  = $admin['role'];
    $user_image = !empty($admin['image']) ? $admin['image'] : 'default.png'; // fallback
} else {
    // Admin not found, force logout
    session_destroy();
    header("Location: ../login.php");
    exit();
}

$stmt->close();
ob_end_flush();
?>
