<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// ✅ Ensure only admin can access
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit();
}

// Initialize variables
$success = '';
$error = '';
$camera_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$action = isset($_GET['action']) ? $_GET['action'] : '';

// Handle Add/Edit Camera
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_camera'])) {
        $name = mysqli_real_escape_string($conn, $_POST['name']);
        $location = mysqli_real_escape_string($conn, $_POST['location']);
        $stream_url = mysqli_real_escape_string($conn, $_POST['stream_url']);
        $rtsp_url = mysqli_real_escape_string($conn, $_POST['rtsp_url']);
        $ip_address = mysqli_real_escape_string($conn, $_POST['ip_address']);
        $port = intval($_POST['port']);
        $username = mysqli_real_escape_string($conn, $_POST['username']);
        $password = mysqli_real_escape_string($conn, $_POST['password']);
        $status = mysqli_real_escape_string($conn, $_POST['status']);
        $is_public = isset($_POST['is_public']) ? 1 : 0;

        $query = "INSERT INTO cctv_cameras (name, location, stream_url, rtsp_url, ip_address, port, username, password, status, is_public) 
                  VALUES ('$name', '$location', '$stream_url', '$rtsp_url', '$ip_address', $port, '$username', '$password', '$status', $is_public)";

        if (mysqli_query($conn, $query)) {
            $success = "✅ CCTV camera added successfully!";
        } else {
            $error = "❌ Error adding camera: " . mysqli_error($conn);
        }
    }
    elseif (isset($_POST['edit_camera'])) {
        $name = mysqli_real_escape_string($conn, $_POST['name']);
        $location = mysqli_real_escape_string($conn, $_POST['location']);
        $stream_url = mysqli_real_escape_string($conn, $_POST['stream_url']);
        $rtsp_url = mysqli_real_escape_string($conn, $_POST['rtsp_url']);
        $ip_address = mysqli_real_escape_string($conn, $_POST['ip_address']);
        $port = intval($_POST['port']);
        $username = mysqli_real_escape_string($conn, $_POST['username']);
        $password = mysqli_real_escape_string($conn, $_POST['password']);
        $status = mysqli_real_escape_string($conn, $_POST['status']);
        $is_public = isset($_POST['is_public']) ? 1 : 0;
        $camera_id = intval($_POST['camera_id']);

        // If password is empty, don't update it
        if (empty($password)) {
            $query = "UPDATE cctv_cameras SET 
                      name = '$name', 
                      location = '$location', 
                      stream_url = '$stream_url', 
                      rtsp_url = '$rtsp_url', 
                      ip_address = '$ip_address', 
                      port = $port, 
                      username = '$username', 
                      status = '$status', 
                      is_public = $is_public 
                      WHERE id = $camera_id";
        } else {
            $query = "UPDATE cctv_cameras SET 
                      name = '$name', 
                      location = '$location', 
                      stream_url = '$stream_url', 
                      rtsp_url = '$rtsp_url', 
                      ip_address = '$ip_address', 
                      port = $port, 
                      username = '$username', 
                      password = '$password', 
                      status = '$status', 
                      is_public = $is_public 
                      WHERE id = $camera_id";
        }

        if (mysqli_query($conn, $query)) {
            $success = "✅ CCTV camera updated successfully!";
        } else {
            $error = "❌ Error updating camera: " . mysqli_error($conn);
        }
    }
}

// Handle Delete
if ($action === 'delete' && $camera_id > 0) {
    $query = "DELETE FROM cctv_cameras WHERE id = $camera_id";
    if (mysqli_query($conn, $query)) {
        $success = "✅ CCTV camera deleted successfully!";
    } else {
        $error = "❌ Error deleting camera: " . mysqli_error($conn);
    }
}

// Handle Status Toggle
if ($action === 'toggle_status' && $camera_id > 0) {
    $query = "UPDATE cctv_cameras SET status = IF(status='active', 'inactive', 'active') WHERE id = $camera_id";
    if (mysqli_query($conn, $query)) {
        $success = "✅ Camera status updated successfully!";
    } else {
        $error = "❌ Error updating camera status: " . mysqli_error($conn);
    }
}

// Fetch all cameras
$cameras_result = mysqli_query($conn, "SELECT * FROM cctv_cameras ORDER BY location, name");

$edit_camera = null;
if ($action === 'edit' && $camera_id > 0) {
    $edit_query = "SELECT * FROM cctv_cameras WHERE id = $camera_id";
    $edit_result = mysqli_query($conn, $edit_query);
    if (mysqli_num_rows($edit_result) > 0) {
        $edit_camera = mysqli_fetch_assoc($edit_result);
    }
}
?>

<div class="bg-white p-6 rounded-lg">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">CCTV Camera Monitoring</h2>
        <button onclick="toggleCameraForm()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center">
            <i class="fas fa-video mr-2"></i> Add New Camera
        </button>
    </div>

    <?php if (!empty($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo $success; ?>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>

    <!-- Camera Form -->
    <div id="cameraForm" class="mb-6 bg-gray-50 p-4 rounded-lg <?php echo !$edit_camera ? 'hidden' : ''; ?>">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">
            <?php echo $edit_camera ? 'Edit Camera' : 'Add New Camera'; ?>
        </h3>
        
        <form method="POST" action="">
            <?php if ($edit_camera): ?>
                <input type="hidden" name="camera_id" value="<?php echo $edit_camera['id']; ?>">
            <?php endif; ?>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Camera Name *</label>
                    <input type="text" name="name" value="<?php echo $edit_camera ? $edit_camera['name'] : ''; ?>" 
                        class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Location *</label>
                    <input type="text" name="location" value="<?php echo $edit_camera ? $edit_camera['location'] : ''; ?>" 
                        class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Stream URL (HLS/MP4) *</label>
                    <input type="url" name="stream_url" value="<?php echo $edit_camera ? $edit_camera['stream_url'] : ''; ?>" 
                        class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" 
                        placeholder="https://example.com/stream.m3u8" required>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">RTSP URL (Optional)</label>
                    <input type="url" name="rtsp_url" value="<?php echo $edit_camera ? $edit_camera['rtsp_url'] : ''; ?>" 
                        class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" 
                        placeholder="rtsp://username:password@ip:port/stream">
                </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">IP Address</label>
                    <input type="text" name="ip_address" value="<?php echo $edit_camera ? $edit_camera['ip_address'] : ''; ?>" 
                        class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" 
                        placeholder="192.168.1.100">
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Port</label>
                    <input type="number" name="port" value="<?php echo $edit_camera ? $edit_camera['port'] : '554'; ?>" 
                        class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" 
                        min="1" max="65535">
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                    <select name="status" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="active" <?php echo ($edit_camera && $edit_camera['status'] == 'active') ? 'selected' : ''; ?>>Active</option>
                        <option value="inactive" <?php echo ($edit_camera && $edit_camera['status'] == 'inactive') ? 'selected' : ''; ?>>Inactive</option>
                        <option value="maintenance" <?php echo ($edit_camera && $edit_camera['status'] == 'maintenance') ? 'selected' : ''; ?>>Maintenance</option>
                    </select>
                </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Username</label>
                    <input type="text" name="username" value="<?php echo $edit_camera ? $edit_camera['username'] : ''; ?>" 
                        class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Password</label>
                    <input type="password" name="password" 
                        class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" 
                        placeholder="<?php echo $edit_camera ? 'Leave blank to keep current password' : ''; ?>">
                </div>
            </div>
            
            <div class="mb-4">
                <label class="inline-flex items-center">
                    <input type="checkbox" name="is_public" value="1" 
                        <?php echo ($edit_camera && $edit_camera['is_public'] == 1) ? 'checked' : ''; ?>
                        class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                    <span class="ml-2 text-sm text-gray-700">Make this camera publicly accessible</span>
                </label>
            </div>
            
            <div class="flex justify-end space-x-2">
                <button type="button" onclick="cancelEdit()" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                    Cancel
                </button>
                <button type="submit" name="<?php echo $edit_camera ? 'edit_camera' : 'add_camera'; ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                    <?php echo $edit_camera ? 'Update Camera' : 'Add Camera'; ?>
                </button>
            </div>
        </form>
    </div>

    <!-- Live Camera Grid -->
    <div class="mb-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Live Camera Feeds</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4" id="cameraGrid">
            <?php 
            mysqli_data_seek($cameras_result, 0);
            while ($camera = mysqli_fetch_assoc($cameras_result)): 
                $status_class = '';
                switch ($camera['status']) {
                    case 'active': $status_class = 'bg-green-500'; break;
                    case 'inactive': $status_class = 'bg-red-500'; break;
                    case 'maintenance': $status_class = 'bg-yellow-500'; break;
                }
            ?>
                <div class="bg-gray-800 rounded-lg overflow-hidden shadow-lg">
                    <div class="relative">
                        <!-- Camera Feed -->
                        <div class="aspect-video bg-black flex items-center justify-center">
                            <?php if ($camera['status'] === 'active'): ?>
                                <video class="w-full h-full object-cover" controls muted playsinline>
                                    <source src="<?php echo htmlspecialchars($camera['stream_url']); ?>" type="application/x-mpegURL">
                                    Your browser does not support the video tag.
                                </video>
                            <?php else: ?>
                                <div class="text-white text-center p-4">
                                    <i class="fas fa-video-slash text-4xl mb-2"></i>
                                    <p>Camera <?php echo strtoupper($camera['status']); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Status Indicator -->
                        <div class="absolute top-2 right-2 flex space-x-2">
                            <span class="<?php echo $status_class; ?> w-3 h-3 rounded-full"></span>
                        </div>
                    </div>
                    
                    <div class="p-3 bg-gray-900 text-white">
                        <div class="flex justify-between items-center">
                            <h4 class="font-semibold truncate"><?php echo htmlspecialchars($camera['name']); ?></h4>
                            <span class="text-xs bg-gray-700 px-2 py-1 rounded"><?php echo htmlspecialchars($camera['location']); ?></span>
                        </div>
                        
                        <div class="flex justify-between items-center mt-2">
                            <span class="text-xs text-gray-400">
                                <?php echo $camera['is_public'] ? 'Public' : 'Private'; ?>
                            </span>
                            <div class="flex space-x-1">
                                <button onclick="toggleCameraStatus(<?php echo $camera['id']; ?>)" 
                                    class="text-xs bg-blue-600 hover:bg-blue-700 px-2 py-1 rounded">
                                    <i class="fas fa-power-off"></i>
                                </button>
                                <a href="?action=edit&id=<?php echo $camera['id']; ?>" 
                                    class="text-xs bg-yellow-600 hover:bg-yellow-700 px-2 py-1 rounded">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="?action=delete&id=<?php echo $camera['id']; ?>" 
                                    class="text-xs bg-red-600 hover:bg-red-700 px-2 py-1 rounded"
                                    onclick="return confirm('Are you sure you want to delete this camera?');">
                                    <i class="fas fa-trash"></i>
                                </a>
                                <button onclick="viewCameraFullscreen(<?php echo $camera['id']; ?>)" 
                                    class="text-xs bg-green-600 hover:bg-green-700 px-2 py-1 rounded">
                                    <i class="fas fa-expand"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
    </div>

    <!-- Camera List Table -->
    <div class="bg-white p-4 rounded-lg shadow">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">All Cameras</h3>
        
        <?php if (mysqli_num_rows($cameras_result) > 0): ?>
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white">
                    <thead class="bg-gray-200 text-gray-700">
                        <tr>
                            <th class="py-3 px-4 text-left">Name</th>
                            <th class="py-3 px-4 text-left">Location</th>
                            <th class="py-3 px-4 text-left">IP Address</th>
                            <th class="py-3 px-4 text-left">Status</th>
                            <th class="py-3 px-4 text-left">Visibility</th>
                            <th class="py-3 px-4 text-left">Last Updated</th>
                            <th class="py-3 px-4 text-left">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-600">
                        <?php 
                        mysqli_data_seek($cameras_result, 0);
                        while ($camera = mysqli_fetch_assoc($cameras_result)): 
                            $status_class = '';
                            switch ($camera['status']) {
                                case 'active': $status_class = 'bg-green-100 text-green-800'; break;
                                case 'inactive': $status_class = 'bg-red-100 text-red-800'; break;
                                case 'maintenance': $status_class = 'bg-yellow-100 text-yellow-800'; break;
                            }
                        ?>
                            <tr class="border-b border-gray-200 hover:bg-gray-50">
                                <td class="py-3 px-4 font-medium"><?php echo $camera['name']; ?></td>
                                <td class="py-3 px-4"><?php echo $camera['location']; ?></td>
                                <td class="py-3 px-4"><?php echo $camera['ip_address'] ?: 'N/A'; ?></td>
                                <td class="py-3 px-4">
                                    <span class="text-xs font-medium px-2.5 py-0.5 rounded-full <?php echo $status_class; ?>">
                                        <?php echo ucfirst($camera['status']); ?>
                                    </span>
                                </td>
                                <td class="py-3 px-4">
                                    <span class="text-xs font-medium px-2.5 py-0.5 rounded-full bg-gray-100 text-gray-800">
                                        <?php echo $camera['is_public'] ? 'Public' : 'Private'; ?>
                                    </span>
                                </td>
                                <td class="py-3 px-4"><?php echo date('M j, Y H:i', strtotime($camera['updated_at'])); ?></td>
                                <td class="py-3 px-4">
                                    <div class="flex space-x-2">
                                        <a href="?action=toggle_status&id=<?php echo $camera['id']; ?>" 
                                           class="text-blue-600 hover:text-blue-800" title="Toggle Status">
                                            <i class="fas fa-power-off"></i>
                                        </a>
                                        <a href="?action=edit&id=<?php echo $camera['id']; ?>" 
                                           class="text-yellow-600 hover:text-yellow-800" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="?action=delete&id=<?php echo $camera['id']; ?>" 
                                           class="text-red-600 hover:text-red-800" 
                                           onclick="return confirm('Are you sure you want to delete this camera?');"
                                           title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                        <button onclick="viewCameraFullscreen(<?php echo $camera['id']; ?>)" 
                                                class="text-green-600 hover:text-green-800" title="Fullscreen">
                                            <i class="fas fa-expand"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p class="text-center py-4 text-gray-500">No CCTV cameras configured yet.</p>
        <?php endif; ?>
    </div>
</div>

<!-- Fullscreen Camera Modal -->
<div id="fullscreenModal" class="fixed inset-0 bg-black z-50 hidden">
    <div class="relative w-full h-full">
        <button onclick="closeFullscreen()" class="absolute top-4 right-4 z-10 bg-red-600 hover:bg-red-700 text-white p-2 rounded-full">
            <i class="fas fa-times"></i>
        </button>
        <div class="w-full h-full flex items-center justify-center">
            <video id="fullscreenVideo" class="max-w-full max-h-full" controls autoplay muted playsinline>
                Your browser does not support the video tag.
            </video>
        </div>
        <div id="fullscreenInfo" class="absolute bottom-4 left-4 text-white bg-black bg-opacity-50 p-2 rounded"></div>
    </div>
</div>

<script>
// Toggle camera form visibility
function toggleCameraForm() {
    const form = document.getElementById('cameraForm');
    form.classList.toggle('hidden');
    
    if (!form.classList.contains('hidden')) {
        form.scrollIntoView({ behavior: 'smooth' });
    }
}

// Cancel edit and hide form
function cancelEdit() {
    window.location.href = 'cctv.php';
}

// View camera in fullscreen
function viewCameraFullscreen(cameraId) {
    // In a real implementation, you would fetch camera details via AJAX
    const cameraElement = document.querySelector(`[onclick="viewCameraFullscreen(${cameraId})"]`).closest('.bg-gray-800');
    const videoSrc = cameraElement.querySelector('video source').src;
    const cameraName = cameraElement.querySelector('h4').textContent;
    const cameraLocation = cameraElement.querySelector('span').textContent;
    
    const fullscreenVideo = document.getElementById('fullscreenVideo');
    const fullscreenInfo = document.getElementById('fullscreenInfo');
    
    // Clear existing sources
    while (fullscreenVideo.firstChild) {
        fullscreenVideo.removeChild(fullscreenVideo.firstChild);
    }
    
    // Add new source
    const source = document.createElement('source');
    source.src = videoSrc;
    source.type = 'application/x-mpegURL';
    fullscreenVideo.appendChild(source);
    
    // Load the video
    fullscreenVideo.load();
    
    // Set info
    fullscreenInfo.innerHTML = `${cameraName} - ${cameraLocation}`;
    
    // Show modal
    document.getElementById('fullscreenModal').classList.remove('hidden');
    
    // Enter fullscreen
    if (fullscreenVideo.requestFullscreen) {
        fullscreenVideo.requestFullscreen();
    }
}

// Close fullscreen
function closeFullscreen() {
    document.getElementById('fullscreenModal').classList.add('hidden');
    
    if (document.fullscreenElement) {
        document.exitFullscreen();
    }
}

// Toggle camera status
function toggleCameraStatus(cameraId) {
    if (confirm('Are you sure you want to toggle this camera status?')) {
        window.location.href = `?action=toggle_status&id=${cameraId}`;
    }
}

// Auto-refresh camera feeds every 30 seconds
setInterval(() => {
    document.querySelectorAll('video').forEach(video => {
        if (video.paused) {
            video.load();
        }
    });
}, 30000);

// Handle fullscreen change
document.addEventListener('fullscreenchange', function() {
    if (!document.fullscreenElement) {
        closeFullscreen();
    }
});
</script>

<style>
/* Custom styles for video players */
video {
    background: #000;
}

.aspect-video {
    aspect-ratio: 16 / 9;
}

/* Fullscreen modal styles */
#fullscreenModal video {
    max-width: 95vw;
    max-height: 95vh;
}
</style>

<?php
include 'include/footer.php';
?>