<?php
include 'include/header.php';
include '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$admin_id = $_SESSION['user_id'];
$admin_name = $_SESSION['user_name'];

$success = '';
$error = '';

// Get teacher ID from URL
$teacher_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch teacher data (only from users table where role=teacher)
$teacher = null;
if ($teacher_id > 0) {
    $sql = "SELECT * FROM users WHERE id = '$teacher_id' AND role = 'teacher'";
    $result = mysqli_query($conn, $sql);

    if (mysqli_num_rows($result) > 0) {
        $teacher = mysqli_fetch_assoc($result);
    } else {
        $error = "Teacher not found with ID: $teacher_id";
        $teacher_id = 0;
    }
} else {
    $error = "Invalid teacher ID";
}

// Function to safely get POST values
function getPostValue($key, $default = '') {
    return isset($_POST[$key]) ? mysqli_real_escape_string($GLOBALS['conn'], $_POST[$key]) : $default;
}

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST' && $teacher_id > 0) {
    $fullName = getPostValue('fullName', $teacher['full_name']);
    $username = getPostValue('username', $teacher['name']);
    $dob = getPostValue('dob', $teacher['dob']);
    $gender = getPostValue('gender', $teacher['gender']);
    $nationality = getPostValue('nationality', $teacher['nationality']);
    $idNumber = getPostValue('idNumber', $teacher['id_number']);
    $address = getPostValue('address', $teacher['address']);
    $phone = getPostValue('phone', $teacher['phone']);
    $email = getPostValue('email', $teacher['email']);
    $emergencyContact = getPostValue('emergencyContact', $teacher['emergency_contact']);
    $emergencyPhone = getPostValue('emergencyPhone', $teacher['emergency_phone']);
    $hireDate = getPostValue('hireDate', $teacher['hire_date']);
    $highestDegree = getPostValue('highestDegree', $teacher['highest_degree']);
    $university = getPostValue('university', $teacher['university']);
    $graduationYear = getPostValue('graduationYear', $teacher['graduation_year']);
    $experience = getPostValue('experience', $teacher['experience']);
    $salary = getPostValue('salary', $teacher['salary']);
    $bankAccount = getPostValue('bankAccount', $teacher['bank_account']);
    $bankName = getPostValue('bankName', $teacher['bank_name']);
    $medicalConditions = getPostValue('medicalConditions', $teacher['medical_conditions']);
    $allergies = getPostValue('allergies', $teacher['allergies']);
    $bloodGroup = getPostValue('bloodGroup', $teacher['blood_group']);
    $subject = getPostValue('subject', $teacher['subjects']);
    $classesToTeach = isset($_POST['classesToTeach']) ? $_POST['classesToTeach'] : [];
    $classesString = !empty($classesToTeach) ? implode(',', $classesToTeach) : $teacher['grades'];

    // Handle password change (optional)
    $password = getPostValue('password');
    $confirm_password = getPostValue('confirm_password');

    if (!empty($password) && $password !== $confirm_password) {
        $error = "Passwords do not match.";
    } else {
        $photoPath = $teacher['image']; // keep old photo

        // Handle file upload
        if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
            $targetDir = "../uploads/";
            if (!is_dir($targetDir)) {
                mkdir($targetDir, 0777, true);
            }

            $fileName = time() . '_' . basename($_FILES['photo']['name']);
            $targetFilePath = $targetDir . $fileName;
            $fileType = pathinfo($targetFilePath, PATHINFO_EXTENSION);

            $allowTypes = array('jpg', 'png', 'jpeg', 'gif');
            if (in_array($fileType, $allowTypes)) {
                if (move_uploaded_file($_FILES['photo']['tmp_name'], $targetFilePath)) {
                    if (!empty($teacher['image']) && file_exists($teacher['image'])) {
                        unlink($teacher['image']);
                    }
                    $photoPath = $targetFilePath;
                }
            }
        }
$userSql = "UPDATE users SET
    username = '$username',
    name = '$username',
    full_name = '$fullName',
    dob = '$dob',
    gender = '$gender',
    nationality = '$nationality',
    id_number = '$idNumber',
    address = '$address',
    phone = '$phone',
    email = '$email',
    emergency_contact = '$emergencyContact',
    emergency_phone = '$emergencyPhone',
    hire_date = '$hireDate',
    highest_degree = '$highestDegree',
    university = '$university',
    graduation_year = '$graduationYear',
    experience = '$experience',
    salary = '$salary',
    bank_account = '$bankAccount',
    bank_name = '$bankName',
    medical_conditions = '$medicalConditions',
    allergies = '$allergies',
    blood_group = '$bloodGroup',
    subjects = '$subject',
    grades = '$classesString',
    image = '$photoPath',
    updated_by = '$admin_id',
    updated_at = NOW()";

        if (!empty($password)) {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $userSql .= ", password = '$hashed_password'";
        }

        $userSql .= " WHERE id = '$teacher_id' AND role = 'teacher'";

        if (mysqli_query($conn, $userSql)) {
            $success = "Teacher information updated successfully! (Updated by " . $admin_name . " at " . date('Y-m-d H:i:s') . ")";
            $result = mysqli_query($conn, "SELECT * FROM users WHERE id = '$teacher_id' AND role = 'teacher'");
            if (mysqli_num_rows($result) > 0) {
                $teacher = mysqli_fetch_assoc($result);
            }
        } else {
            $error = "Error updating teacher: " . mysqli_error($conn);
        }
    }
}
?>


<style>
    .bg-white {
        background-color: white;
    }
    .p-6 {
        padding: 1.5rem;
    }
    .rounded-lg {
        border-radius: 0.5rem;
    }
    .shadow-md {
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    }
    .text-2xl {
        font-size: 1.5rem;
    }
    .font-bold {
        font-weight: 700;
    }
    .text-gray-800 {
        color: #2d3748;
    }
    .mb-6 {
        margin-bottom: 1.5rem;
    }
    .grid {
        display: grid;
    }
    .grid-cols-1 {
        grid-template-columns: repeat(1, minmax(0, 1fr));
    }
    .md\:grid-cols-2 {
        grid-template-columns: repeat(2, minmax(0, 1fr));
    }
    .gap-6 {
        gap: 1.5rem;
    }
    .block {
        display: block;
    }
    .text-gray-700 {
        color: #4a5568;
    }
    .mb-2 {
        margin-bottom: 0.5rem;
    }
    .w-full {
        width: 100%;
    }
    .px-4 {
        padding-left: 1rem;
        padding-right: 1rem;
    }
    .py-2 {
        padding-top: 0.5rem;
        padding-bottom: 0.5rem;
    }
    .border {
        border-width: 1px;
    }
    .rounded-lg {
        border-radius: 0.5rem;
    }
    .focus\:outline-none:focus {
        outline: none;
    }
    .focus\:ring-2:focus {
        box-shadow: 0 0 0 2px rgba(66, 153, 225, 0.5);
    }
    .focus\:ring-blue-500:focus {
        --tw-ring-color: #4299e1;
    }
    .md\:col-span-2 {
        grid-column: span 2 / span 2;
    }
    .flex {
        display: flex;
    }
    .justify-end {
        justify-content: flex-end;
    }
    .space-x-4 > * + * {
        margin-left: 1rem;
    }
    .mt-4 {
        margin-top: 1rem;
    }
    .bg-gray-500 {
        background-color: #6b7280;
    }
    .hover\:bg-gray-600:hover {
        background-color: #4b5563;
    }
    .text-white {
        color: white;
    }
    .px-6 {
        padding-left: 1.5rem;
        padding-right: 1.5rem;
    }
    .py-2 {
        padding-top: 0.5rem;
        padding-bottom: 0.5rem;
    }
    .rounded-lg {
        border-radius: 0.5rem;
    }
    .bg-blue-600 {
        background-color: #2563eb;
    }
    .hover\:bg-blue-700:hover {
        background-color: #1d4ed8;
    }
    .relative {
        position: relative;
    }
    .w-32 {
        width: 8rem;
    }
    .h-32 {
        height: 8rem;
    }
    .rounded-full {
        border-radius: 9999px;
    }
    .overflow-hidden {
        overflow: hidden;
    }
    .border-4 {
        border-width: 4px;
    }
    .border-gray-300 {
        border-color: #d1d5db;
    }

    .bg-gray-200 {
        background-color: #e5e7eb;
    }
    .hover\:bg-gray-300:hover {
        background-color: #d1d5db;
    }
    .text-gray-800 {
        color: #2d3748;
    }
    .mr-2 {
        margin-right: 0.5rem;
    }
    .bg-red-100 {
        background-color: #fed7d7;
    }
    .border-red-400 {
        border-color: #f56565;
    }
    .text-red-700 {
        color: #c53030;
    }
    .px-4 {
        padding-left: 1rem;
        padding-right: 1rem;
    }
    .py-3 {
        padding-top: 0.75rem;
        padding-bottom: 0.75rem;
    }
    .rounded {
        border-radius: 0.25rem;
    }
    .mb-4 {
        margin-bottom: 1rem;
    }
    .bg-yellow-100 {
        background-color: #feebc8;
    }
    .border-yellow-400 {
        border-color: #f6ad55;
    }
    .text-yellow-700 {
        color: #b7791f;
    }
    .flex-col {
        flex-direction: column;
    }
    .items-center {
        align-items: center;
    }
    .object-cover {
        object-fit: cover;
    }
    .text-4xl {
        font-size: 2.25rem;
    }
    .text-gray-400 {
        color: #9ca3af;
    }
    
    /* Additional styles for form layout */
    .form-section {
        margin-bottom: 25px;
        padding-bottom: 20px;
        border-bottom: 1px solid #eaeaea;
    }
    
    .section-title {
        color: #2563eb;
        font-size: 1.3rem;
        margin-bottom: 15px;
        padding-bottom: 8px;
        border-bottom: 2px solid #2563eb;
        display: flex;
        align-items: center;
    }
    
    .section-title i {
        margin-right: 10px;
    }
    
    .form-row {
        display: flex;
        flex-wrap: wrap;
        margin: 0 -10px 15px;
    }
    
    .form-group {
        flex: 1 0 300px;
        padding: 0 10px;
        margin-bottom: 15px;
    }
    
    .required::after {
        content: " *";
        color: #e22;
    }
    
    .photo-upload {
        display: flex;
        flex-direction: column;
        align-items: center;
        margin-top: 10px;
    }
    
    .photo-preview {
        width: 120px;
        height: 120px;
        border: 2px dashed #d1d5db;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 15px;
        overflow: hidden;
    }
    
    .photo-preview img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    
    .upload-btn {
        background: #eff6ff;
        color: #2563eb;
        border: 1px solid #2563eb;
        padding: 8px 20px;
        border-radius: 5px;
        cursor: pointer;
        transition: all 0.3s;
    }
    
    .upload-btn:hover {
        background: #2563eb;
        color: white;
    }
    
    .alert {
        padding: 15px;
        margin: 20px 0;
        border-radius: 5px;
        text-align: center;
    }
    
    .alert-success {
        background-color: #d1fae5;
        color: #065f46;
        border: 1px solid #a7f3d0;
    }
    
    .alert-error {
        background-color: #fee2e2;
        color: #991b1b;
        border: 1px solid #fecaca;
    }
    
    .teacher-id-badge {
        background: #2563eb;
        color: white;
        padding: 8px 15px;
        border-radius: 20px;
        font-weight: bold;
        margin-left: 15px;
        font-size: 0.9em;
    }
    
    @media (max-width: 768px) {
        .form-group {
            flex: 1 0 100%;
        }
        
        .teacher-id-badge {
            margin-left: 0;
            margin-top: 10px;
            display: inline-block;
        }
    }
</style>

<div class="bg-white p-6 rounded-lg ">
    <h2 class="text-2xl font-bold text-gray-800 mb-6">
        Edit Teacher 
        <?php if ($teacher_id > 0): ?>
            <span class="teacher-id-badge">ID: <?php echo $teacher_id; ?></span>
        <?php endif; ?>
    </h2>
    
    <?php if (!empty($success)): ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="alert alert-error"><?php echo $error; ?></div>
    <?php endif; ?>
    
    <?php if ($teacher_id === 0): ?>
        <div class="alert alert-error">Cannot edit teacher. Invalid teacher ID provided.</div>
    <?php else: ?>
        <form id="teacherForm" method="POST" enctype="multipart/form-data" class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Photo Upload Section -->
            <div class="md:col-span-2 flex flex-col items-center mb-4">
                <div class="relative w-32 h-32 rounded-full overflow-hidden border-4 border-gray-300 mb-4">
                    <?php if (!empty($teacher['photo'])): ?>
                        <img id="previewImg" src="<?php echo htmlspecialchars($teacher['photo']); ?>" alt="Teacher Photo" class="w-full h-full object-cover">
                        <div id="placeholder" class="w-full h-full bg-gray-200 flex items-center justify-center hidden">
                            <i class="fas fa-user text-gray-400 text-4xl"></i>
                        </div>
                    <?php else: ?>
                        <img id="previewImg" src="" alt="Teacher Photo" class="w-full h-full object-cover hidden">
                        <div id="placeholder" class="w-full h-full bg-gray-200 flex items-center justify-center">
                            <i class="fas fa-user text-gray-400 text-4xl"></i>
                        </div>
                    <?php endif; ?>
                </div>
                <input type="file" id="photo" name="photo" accept="image/*" class="hidden" onchange="previewImage()">
                <button type="button" onclick="document.getElementById('photo').click()" class="bg-gray-200 hover:bg-gray-300 text-gray-800 px-4 py-2 rounded">
                    <i class="fas fa-upload mr-2"></i> Change Photo
                </button>
            </div>
            
            <!-- Account Information Section -->
            <div class="md:col-span-2">
                <div class="section-title">
                    <i class="fas fa-user-circle"></i> Account Information
                </div>
            </div>
            
            <div class="form-group">
                <label for="username" class="block text-gray-700 mb-2 required">Username</label>
                <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($teacher['username']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="password" class="block text-gray-700 mb-2">New Password (leave blank to keep current)</label>
                <input type="password" id="password" name="password" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" onkeyup="validatePassword()">
            </div>
            
            <div class="form-group">
                <label for="confirm_password" class="block text-gray-700 mb-2">Confirm New Password</label>
                <input type="password" id="confirm_password" name="confirm_password" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" onkeyup="validatePassword()">
                <p id="passwordMessage" class="text-red-500 text-sm mt-1 hidden">Passwords do not match</p>
            </div>
            
            <!-- Personal Information Section -->
            <div class="md:col-span-2">
                <div class="section-title">
                    <i class="fas fa-user"></i> Personal Information
                </div>
            </div>
            
            <div class="form-group">
                <label for="fullName" class="block text-gray-700 mb-2 required">Full Name</label>
                <input type="text" id="fullName" name="fullName" value="<?php echo htmlspecialchars($teacher['full_name']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="dob" class="block text-gray-700 mb-2 required">Date of Birth</label>
                <input type="date" id="dob" name="dob" value="<?php echo htmlspecialchars($teacher['dob']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="gender" class="block text-gray-700 mb-2 required">Gender</label>
                <select id="gender" name="gender" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    <option value="">Select Gender</option>
                    <option value="male" <?php echo ($teacher['gender'] == 'male') ? 'selected' : ''; ?>>Male</option>
                    <option value="female" <?php echo ($teacher['gender'] == 'female') ? 'selected' : ''; ?>>Female</option>
                    <option value="other" <?php echo ($teacher['gender'] == 'other') ? 'selected' : ''; ?>>Other</option>
                </select>
            </div>
            
            <div class="form-group">
                <label for="nationality" class="block text-gray-700 mb-2">Nationality</label>
                <input type="text" id="nationality" name="nationality" value="<?php echo htmlspecialchars($teacher['nationality']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <div class="form-group">
                <label for="idNumber" class="block text-gray-700 mb-2">Government ID Number</label>
                <input type="text" id="idNumber" name="idNumber" value="<?php echo htmlspecialchars($teacher['id_number']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <!-- Contact Information Section -->
            <div class="md:col-span-2">
                <div class="section-title">
                    <i class="fas fa-address-book"></i> Contact Information
                </div>
            </div>
            
            <div class="md:col-span-2 form-group">
                <label for="address" class="block text-gray-700 mb-2 required">Residential Address</label>
                <textarea id="address" name="address" rows="3" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required><?php echo htmlspecialchars($teacher['address']); ?></textarea>
            </div>
            
            <div class="form-group">
                <label for="phone" class="block text-gray-700 mb-2 required">Phone Number</label>
                <input type="tel" id="phone" name="phone" value="<?php echo htmlspecialchars($teacher['phone']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="email" class="block text-gray-700 mb-2 required">Email Address</label>
                <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($teacher['email']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="emergencyContact" class="block text-gray-700 mb-2">Emergency Contact Person</label>
                <input type="text" id="emergencyContact" name="emergencyContact" value="<?php echo htmlspecialchars($teacher['emergency_contact']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <div class="form-group">
                <label for="emergencyPhone" class="block text-gray-700 mb-2">Emergency Contact Phone</label>
                <input type="tel" id="emergencyPhone" name="emergencyPhone" value="<?php echo htmlspecialchars($teacher['emergency_phone']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <!-- Professional Information Section -->
            <div class="md:col-span-2">
                <div class="section-title">
                    <i class="fas fa-briefcase"></i> Professional Information
                </div>
            </div>
            
            <div class="form-group">
                <label for="hireDate" class="block text-gray-700 mb-2 required">Hire Date</label>
                <input type="date" id="hireDate" name="hireDate" value="<?php echo htmlspecialchars($teacher['hire_date']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="highestDegree" class="block text-gray-700 mb-2 required">Highest Degree</label>
                <input type="text" id="highestDegree" name="highestDegree" value="<?php echo htmlspecialchars($teacher['highest_degree']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="university" class="block text-gray-700 mb-2 required">University/Institution</label>
                <input type="text" id="university" name="university" value="<?php echo htmlspecialchars($teacher['university']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="graduationYear" class="block text-gray-700 mb-2 required">Year of Graduation</label>
                <input type="number" id="graduationYear" name="graduationYear" min="1950" max="<?php echo date('Y'); ?>" value="<?php echo htmlspecialchars($teacher['graduation_year']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="experience" class="block text-gray-700 mb-2 required">Years of Experience</label>
                <input type="number" id="experience" name="experience" min="0" value="<?php echo htmlspecialchars($teacher['experience']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="salary" class="block text-gray-700 mb-2 required">Salary</label>
                <input type="number" id="salary" name="salary" min="0" step="0.01" value="<?php echo htmlspecialchars($teacher['salary']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            
            <div class="form-group">
                <label for="bankAccount" class="block text-gray-700 mb-2">Bank Account Number</label>
                <input type="text" id="bankAccount" name="bankAccount" value="<?php echo htmlspecialchars($teacher['bank_account']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <div class="form-group">
                <label for="bankName" class="block text-gray-700 mb-2">Bank Name</label>
                <input type="text" id="bankName" name="bankName" value="<?php echo htmlspecialchars($teacher['bank_name']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <!-- Medical Information Section -->
            <div class="md:col-span-2">
                <div class="section-title">
                    <i class="fas fa-heartbeat"></i> Medical Information
                </div>
            </div>
            
            <div class="md:col-span-2 form-group">
                <label for="medicalConditions" class="block text-gray-700 mb-2">Medical Conditions</label>
                <textarea id="medicalConditions" name="medicalConditions" rows="2" placeholder="e.g., Asthma, Diabetes" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo htmlspecialchars($teacher['medical_conditions']); ?></textarea>
            </div>
            
            <div class="form-group">
                <label for="allergies" class="block text-gray-700 mb-2">Allergies</label>
                <input type="text" id="allergies" name="allergies" placeholder="e.g., Peanuts, Dust" value="<?php echo htmlspecialchars($teacher['allergies']); ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <div class="form-group">
                <label for="bloodGroup" class="block text-gray-700 mb-2">Blood Group</label>
                <select id="bloodGroup" name="bloodGroup" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Select Blood Group</option>
                    <option value="A+" <?php echo ($teacher['blood_group'] == 'A+') ? 'selected' : ''; ?>>A+</option>
                    <option value="A-" <?php echo ($teacher['blood_group'] == 'A-') ? 'selected' : ''; ?>>A-</option>
                    <option value="B+" <?php echo ($teacher['blood_group'] == 'B+') ? 'selected' : ''; ?>>B+</option>
                    <option value="B-" <?php echo ($teacher['blood_group'] == 'B-') ? 'selected' : ''; ?>>B-</option>
                    <option value="AB+" <?php echo ($teacher['blood_group'] == 'AB+') ? 'selected' : ''; ?>>AB+</option>
                    <option value="AB-" <?php echo ($teacher['blood_group'] == 'AB-') ? 'selected' : ''; ?>>AB-</option>
                    <option value="O+" <?php echo ($teacher['blood_group'] == 'O+') ? 'selected' : ''; ?>>O+</option>
                    <option value="O-" <?php echo ($teacher['blood_group'] == 'O-') ? 'selected' : ''; ?>>O-</option>
                </select>
            </div>
            
            <div class="md:col-span-2 flex justify-end space-x-4 mt-4">
                <a href="teachers.php" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-2 rounded-lg">Cancel</a>
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg">
                    Update Teacher
                </button>
            </div>
        </form>
    <?php endif; ?>
</div>

<script>
    // Photo preview functionality
    function previewImage() {
        const file = document.getElementById('photo').files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const previewImg = document.getElementById('previewImg');
                previewImg.src = e.target.result;
                previewImg.classList.remove('hidden');
                document.getElementById('placeholder').classList.add('hidden');
            }
            reader.readAsDataURL(file);
        }
    }
    
    // Password validation
    function validatePassword() {
        const password = document.getElementById('password').value;
        const confirmPassword = document.getElementById('confirm_password').value;
        const message = document.getElementById('passwordMessage');
        
        if (password !== confirmPassword && confirmPassword !== '') {
            message.classList.remove('hidden');
        } else {
            message.classList.add('hidden');
        }
    }
    
    // Add event listeners for password validation
    document.getElementById('password').addEventListener('keyup', validatePassword);
    document.getElementById('confirm_password').addEventListener('keyup', validatePassword);
    
    // Form validation before submission
    document.getElementById('teacherForm').addEventListener('submit', function(e) {
        const password = document.getElementById('password').value;
        const confirmPassword = document.getElementById('confirm_password').value;
        
        if (password !== confirmPassword) {
            e.preventDefault();
            alert('Passwords do not match. Please correct and try again.');
            return false;
        }
    });
</script>

<?php include 'include/footer.php'; ?>