<?php
include 'include/header.php';
include '../config/conn.php';

// Add PHPMailer for email functionality
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../vendor/autoload.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$admin_id = $_SESSION['user_id'];
$admin_name = $_SESSION['user_name'];

$success = '';
$error = '';

// Function to send email notifications
function sendEventNotifications($conn, $event_id, $title, $description, $event_date, $start_time, $end_time, $location) {
    // Get event details for the email
    $formatted_date = date('F j, Y', strtotime($event_date));
    $formatted_time = date('g:i A', strtotime($start_time)) . ' - ' . date('g:i A', strtotime($end_time));
    
    // Determine recipients based on audience type
    $recipients = getEventRecipients($conn, $event_id);
    
    if (empty($recipients)) {
        return false;
    }
    
    // Email content
    $subject = "New School Event: $title";
    $message = "
    <!DOCTYPE html>
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background-color: #3b82f6; color: white; padding: 15px; text-align: center; border-radius: 5px 5px 0 0; }
            .content { background-color: #f9fafb; padding: 20px; border: 1px solid #e5e7eb; }
            .footer { background-color: #f3f4f6; padding: 15px; text-align: center; font-size: 12px; color: #6b7280; border-radius: 0 0 5px 5px; }
            .event-details { background-color: white; padding: 15px; border-radius: 5px; margin-bottom: 15px; border: 1px solid #e5e7eb; }
            .button { display: inline-block; padding: 10px 20px; background-color: #3b82f6; color: white; text-decoration: none; border-radius: 5px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>New School Event</h1>
            </div>
            <div class='content'>
                <h2>$title</h2>
                <div class='event-details'>
                    <p><strong>Date:</strong> $formatted_date</p>
                    <p><strong>Time:</strong> $formatted_time</p>
    ";
    
    if (!empty($location)) {
        $message .= "<p><strong>Location:</strong> $location</p>";
    }
    
    if (!empty($description)) {
        $message .= "<p><strong>Description:</strong><br>" . nl2br(htmlspecialchars($description)) . "</p>";
    }
    
    $message .= "
                </div>
                <p>Please mark your calendar and plan to attend this event.</p>
                <p>For more details, please visit the school portal or contact the administration.</p>
            </div>
            <div class='footer'>
                <p>This is an automated notification from School Event System. Please do not reply to this email.</p>
                <p>&copy; " . date('Y') . " School Name. All rights reserved.</p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    // Send emails
    $mail = new PHPMailer(true);
    
    try {
        // Server settings - Update these with your SMTP details
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com'; // Your SMTP server
        $mail->SMTPAuth   = true;
     $mail->Username   = 'holuwaseunisrael@gmail.com';
        $mail->Password   = 'ceae tepn tfyx oxjn';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port       = 465;
        
        $mail->setFrom('noreply@yourschool.com', 'School Event System');
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body = $message;
        $mail->AltBody = strip_tags($message); // Plain text version
        
        // Add all recipients
        foreach ($recipients as $email => $name) {
            $mail->addAddress($email, $name);
        }
        
        return $mail->send();
        
    } catch (Exception $e) {
        error_log("Email could not be sent. Mailer Error: {$mail->ErrorInfo}");
        return false;
    }
}

// Function to get recipients based on event audience
function getEventRecipients($conn, $event_id) {
    $recipients = [];
    
    // Get event details
    $event_query = "SELECT audience_type, target_id FROM events WHERE id = '$event_id'";
    $event_result = mysqli_query($conn, $event_query);
    $event = mysqli_fetch_assoc($event_result);
    
    if (!$event) return $recipients;
    
    $audience_type = $event['audience_type'];
    $target_id = $event['target_id'];
    
    if ($audience_type === 'all') {
        // Get all teachers
        $teachers_query = "SELECT email, full_name FROM users WHERE role='teacher' AND status='active' AND email != ''";
        $teachers_result = mysqli_query($conn, $teachers_query);
        while ($teacher = mysqli_fetch_assoc($teachers_result)) {
            $recipients[$teacher['email']] = $teacher['full_name'];
        }
        
        // Get all students and their parents
        $students_query = "SELECT s.email as student_email, s.full_name as student_name, 
                          p.email as parent_email, p.fullname as parent_name 
                          FROM students s 
                          LEFT JOIN parents p ON s.parent_id = p.id 
                          WHERE s.status='active' AND (s.email != '' OR p.email != '')";
        $students_result = mysqli_query($conn, $students_query);
        while ($student = mysqli_fetch_assoc($students_result)) {
            if (!empty($student['student_email'])) {
                $recipients[$student['student_email']] = $student['student_name'];
            }
            if (!empty($student['parent_email'])) {
                $recipients[$student['parent_email']] = $student['parent_name'];
            }
        }
        
    } elseif ($audience_type === 'class') {
        // Get class-specific recipients
        $class_id = str_replace('class_', '', $target_id);
        
        // Get students in this class and their parents
        $class_query = "SELECT s.email as student_email, s.full_name as student_name, 
                       p.email as parent_email, p.fullname as parent_name 
                       FROM students s 
                       LEFT JOIN parents p ON s.parent_id = p.id 
                       WHERE s.class = '$class_id' AND s.status='active' 
                       AND (s.email != '' OR p.email != '')";
        $class_result = mysqli_query($conn, $class_query);
        while ($student = mysqli_fetch_assoc($class_result)) {
            if (!empty($student['student_email'])) {
                $recipients[$student['student_email']] = $student['student_name'];
            }
            if (!empty($student['parent_email'])) {
                $recipients[$student['parent_email']] = $student['parent_name'];
            }
        }
        
        // Get class teacher if any
        $teacher_query = "SELECT u.email, u.full_name 
                         FROM users u 
                         WHERE u.role='teacher' AND u.status='active' 
                         AND u.id IN (SELECT teacher_id FROM classes WHERE id='$class_id')";
        $teacher_result = mysqli_query($conn, $teacher_query);
        if ($teacher = mysqli_fetch_assoc($teacher_result)) {
            $recipients[$teacher['email']] = $teacher['full_name'];
        }
        
    } elseif ($audience_type === 'teacher') {
        // Get specific teacher
        $teacher_id = str_replace('teacher_', '', $target_id);
        $teacher_query = "SELECT email, full_name FROM users WHERE id='$teacher_id' AND status='active'";
        $teacher_result = mysqli_query($conn, $teacher_query);
        if ($teacher = mysqli_fetch_assoc($teacher_result)) {
            $recipients[$teacher['email']] = $teacher['full_name'];
        }
    }
    
    return $recipients;
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Add Event
    if (isset($_POST['add_event'])) {
        $title = mysqli_real_escape_string($conn, $_POST['title']);
        $description = mysqli_real_escape_string($conn, $_POST['description']);
        $event_date = mysqli_real_escape_string($conn, $_POST['event_date']);
        $start_time = mysqli_real_escape_string($conn, $_POST['start_time']);
        $end_time = mysqli_real_escape_string($conn, $_POST['end_time']);
        $location = mysqli_real_escape_string($conn, $_POST['location']);
        $audience_type = mysqli_real_escape_string($conn, $_POST['audience_type']);
        $target_id = mysqli_real_escape_string($conn, $_POST['target_id']);
        
        if (empty($title) || empty($event_date) || empty($start_time) || empty($end_time)) {
            $error = "Please fill in all required fields";
        } else {
            // Handle image upload
            $image_path = '';
            if (isset($_FILES['event_image']) && $_FILES['event_image']['error'] == 0) {
                $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];
                $file_name = $_FILES['event_image']['name'];
                $file_size = $_FILES['event_image']['size'];
                $file_tmp = $_FILES['event_image']['tmp_name'];
                $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
                
                if (!in_array($file_ext, $allowed_extensions)) {
                    $error = "Invalid file type. Allowed: JPG, JPEG, PNG, GIF";
                } elseif ($file_size > 5242880) { // 5MB
                    $error = "File size must be less than 5MB";
                } else {
                    $new_file_name = uniqid() . '_' . time() . '.' . $file_ext;
                    $upload_path = '../uploads/events/' . $new_file_name;
                    
                    // Create directory if it doesn't exist
                    if (!file_exists('../uploads/events/')) {
                        mkdir('../uploads/events/', 0777, true);
                    }
                    
                    if (move_uploaded_file($file_tmp, $upload_path)) {
                        $image_path = mysqli_real_escape_string($conn, $new_file_name);
                    } else {
                        $error = "Error uploading file";
                    }
                }
            }
            
            if (empty($error)) {
                $insert_query = "INSERT INTO events (title, description, event_date, start_time, end_time, 
                                location, audience_type, target_id, image_path, created_by) 
                                VALUES ('$title', '$description', '$event_date', '$start_time', '$end_time', 
                                        '$location', '$audience_type', '$target_id', '$image_path', '$admin_id')";
                
                if (mysqli_query($conn, $insert_query)) {
                    $event_id = mysqli_insert_id($conn);
                    $email_sent = sendEventNotifications($conn, $event_id, $title, $description, $event_date, $start_time, $end_time, $location);
                    $success = "Event created successfully!" . ($email_sent ? " Email notifications sent." : "");
                } else {
                    $error = "Error: " . mysqli_error($conn);
                    
                    // Delete uploaded file if database insertion failed
                    if (!empty($image_path) && file_exists('../uploads/events/' . $image_path)) {
                        unlink('../uploads/events/' . $image_path);
                    }
                }
            }
        }
    }
    
    // Edit Event
    if (isset($_POST['edit_event'])) {
        $event_id = mysqli_real_escape_string($conn, $_POST['event_id']);
        $title = mysqli_real_escape_string($conn, $_POST['title']);
        $description = mysqli_real_escape_string($conn, $_POST['description']);
        $event_date = mysqli_real_escape_string($conn, $_POST['event_date']);
        $start_time = mysqli_real_escape_string($conn, $_POST['start_time']);
        $end_time = mysqli_real_escape_string($conn, $_POST['end_time']);
        $location = mysqli_real_escape_string($conn, $_POST['location']);
        $audience_type = mysqli_real_escape_string($conn, $_POST['audience_type']);
        $target_id = mysqli_real_escape_string($conn, $_POST['target_id']);
        
        if (empty($title) || empty($event_date) || empty($start_time) || empty($end_time)) {
            $error = "Please fill in all required fields";
        } else {
            // Get current image path
            $current_image_query = "SELECT image_path FROM events WHERE id = '$event_id'";
            $current_image_result = mysqli_query($conn, $current_image_query);
            $current_image = mysqli_fetch_assoc($current_image_result)['image_path'];
            
            // Handle new image upload
            $image_path = $current_image;
            if (isset($_FILES['event_image']) && $_FILES['event_image']['error'] == 0) {
                $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];
                $file_name = $_FILES['event_image']['name'];
                $file_size = $_FILES['event_image']['size'];
                $file_tmp = $_FILES['event_image']['tmp_name'];
                $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
                
                if (!in_array($file_ext, $allowed_extensions)) {
                    $error = "Invalid file type. Allowed: JPG, JPEG, PNG, GIF";
                } elseif ($file_size > 5242880) { // 5MB
                    $error = "File size must be less than 5MB";
                } else {
                    $new_file_name = uniqid() . '_' . time() . '.' . $file_ext;
                    $upload_path = '../uploads/events/' . $new_file_name;
                    
                    // Create directory if it doesn't exist
                    if (!file_exists('../uploads/events/')) {
                        mkdir('../uploads/events/', 0777, true);
                    }
                    
                    if (move_uploaded_file($file_tmp, $upload_path)) {
                        $image_path = mysqli_real_escape_string($conn, $new_file_name);
                        
                        // Delete old image if it exists
                        if (!empty($current_image) && file_exists('../uploads/events/' . $current_image)) {
                            unlink('../uploads/events/' . $current_image);
                        }
                    } else {
                        $error = "Error uploading file";
                    }
                }
            }
            
            if (empty($error)) {
                $update_query = "UPDATE events SET 
                                title = '$title',
                                description = '$description',
                                event_date = '$event_date',
                                start_time = '$start_time',
                                end_time = '$end_time',
                                location = '$location',
                                audience_type = '$audience_type',
                                target_id = '$target_id',
                                image_path = '$image_path',
                                updated_at = NOW()
                                WHERE id = '$event_id'";
                
                if (mysqli_query($conn, $update_query)) {
                    $success = "Event updated successfully!";
                    // Redirect to avoid form resubmission
                    header("Location: events.php?success=Event+updated+successfully");
                    exit();
                } else {
                    $error = "Error: " . mysqli_error($conn);
                    
                    // Delete new uploaded file if database update failed
                    if ($image_path !== $current_image && file_exists('../uploads/events/' . $image_path)) {
                        unlink('../uploads/events/' . $image_path);
                    }
                }
            }
        }
    }
}

// Handle delete actions
if (isset($_GET['action']) && isset($_GET['id'])) {
    $action = $_GET['action'];
    $id = mysqli_real_escape_string($conn, $_GET['id']);
    
    if ($action == 'delete') {
        // Get image path before deleting
        $image_query = "SELECT image_path FROM events WHERE id = '$id'";
        $image_result = mysqli_query($conn, $image_query);
        $image_data = mysqli_fetch_assoc($image_result);
        $image_path = $image_data['image_path'];
        
        $delete_query = "DELETE FROM events WHERE id = '$id'";
        if (mysqli_query($conn, $delete_query)) {
            // Delete associated image if it exists
            if (!empty($image_path) && file_exists('../uploads/events/' . $image_path)) {
                unlink('../uploads/events/' . $image_path);
            }
            $success = "Event deleted successfully!";
            // Redirect to avoid refresh issues
            header("Location: events.php?success=Event+deleted+successfully");
            exit();
        } else {
            $error = "Error: " . mysqli_error($conn);
        }
    } elseif ($action == 'view') {
        // View event details
        $view_query = "SELECT e.*, u.full_name as created_by_name 
                      FROM events e 
                      LEFT JOIN users u ON e.created_by = u.id 
                      WHERE e.id = '$id'";
        $view_result = mysqli_query($conn, $view_query);
        $event = mysqli_fetch_assoc($view_result);
    }
}

// Pagination setup
$limit = 9; // Number of events per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$offset = ($page - 1) * $limit;

// Get total number of events
$count_query = "SELECT COUNT(*) as total FROM events";
$count_result = mysqli_query($conn, $count_query);
$count_data = mysqli_fetch_assoc($count_result);
$total_events = $count_data['total'];
$total_pages = ceil($total_events / $limit);

// Fetch events with pagination
$events_query = "SELECT e.*, u.full_name as created_by_name 
                FROM events e 
                LEFT JOIN users u ON e.created_by = u.id 
                ORDER BY e.event_date DESC, e.start_time DESC
                LIMIT $limit OFFSET $offset";
$events_result = mysqli_query($conn, $events_query);

// Fetch classes for audience selection
$classes_query = "SELECT id, class_name FROM classes WHERE status='active' ORDER BY class_name";
$classes_result = mysqli_query($conn, $classes_query);

// Fetch teachers for audience selection
$teachers_query = "SELECT id, full_name FROM users WHERE role='teacher' AND status='active' ORDER BY full_name";
$teachers_result = mysqli_query($conn, $teachers_query);

// Check for success message from redirect
if (isset($_GET['success'])) {
    $success = urldecode($_GET['success']);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Event Management - School Management System</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
<div class="container mx-auto px-4 py-8">
    <div class="bg-white p-6 rounded-lg shadow-md">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold text-gray-800">Event Management</h2>
            <button onclick="openTab('add-event-tab')" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center">
                <i class="fas fa-plus mr-2"></i> Add New Event
            </button>
        </div>

        <?php if (!empty($success)): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                <i class="fas fa-check-circle mr-2"></i> <?php echo $success; ?>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <i class="fas fa-exclamation-circle mr-2"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <!-- Tab Navigation -->
        <div class="flex border-b border-gray-200 mb-6">
            <button id="events-tab-btn" class="px-4 py-2 font-medium text-blue-600 border-b-2 border-blue-600 focus:outline-none">
                <i class="fas fa-calendar-alt mr-2"></i> All Events
            </button>
            <button id="add-event-tab-btn" class="px-4 py-2 font-medium text-gray-600 hover:text-blue-600 focus:outline-none">
                <i class="fas fa-plus mr-2"></i> Add Event
            </button>
            <?php if (isset($_GET['action']) && $_GET['action'] == 'view'): ?>
                <button id="view-event-tab-btn" class="px-4 py-2 font-medium text-gray-600 hover:text-blue-600 focus:outline-none">
                    <i class="fas fa-eye mr-2"></i> View Event
                </button>
            <?php endif; ?>
        </div>

        <!-- All Events Tab -->
        <div id="events-tab" class="tab-content">
            <div class="bg-white p-4 rounded-lg shadow">
                <?php if (mysqli_num_rows($events_result) > 0): ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <?php while($event = mysqli_fetch_assoc($events_result)): 
                            $event_date = new DateTime($event['event_date']);
                            $start_time = new DateTime($event['start_time']);
                            $end_time = new DateTime($event['end_time']);
                            $is_past = $event_date < new DateTime();
                        ?>
                            <div class="border border-gray-200 rounded-lg overflow-hidden shadow-sm hover:shadow-md transition-shadow">
                                <?php if (!empty($event['image_path'])): ?>
                                    <img src="../uploads/events/<?php echo $event['image_path']; ?>" 
                                         alt="<?php echo htmlspecialchars($event['title']); ?>" 
                                         class="w-full h-48 object-cover">
                                <?php else: ?>
                                    <div class="w-full h-48 bg-gray-200 flex items-center justify-center">
                                        <i class="fas fa-calendar-day text-4xl text-gray-400"></i>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="p-4">
                                    <div class="flex justify-between items-start mb-2">
                                        <h3 class="text-lg font-semibold text-gray-800"><?php echo htmlspecialchars($event['title']); ?></h3>
                                        <span class="text-sm px-2 py-1 rounded <?php echo $is_past ? 'bg-gray-100 text-gray-800' : 'bg-blue-100 text-blue-800'; ?>">
                                            <?php echo $is_past ? 'Past Event' : 'Upcoming'; ?>
                                        </span>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <p class="text-sm text-gray-600 mb-1">
                                            <i class="fas fa-calendar-day mr-2"></i>
                                            <?php echo $event_date->format('F j, Y'); ?>
                                        </p>
                                        <p class="text-sm text-gray-600 mb-1">
                                            <i class="fas fa-clock mr-2"></i>
                                            <?php echo $start_time->format('g:i A') . ' - ' . $end_time->format('g:i A'); ?>
                                        </p>
                                        <?php if (!empty($event['location'])): ?>
                                            <p class="text-sm text-gray-600 mb-1">
                                                <i class="fas fa-map-marker-alt mr-2"></i>
                                                <?php echo htmlspecialchars($event['location']); ?>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <?php if (!empty($event['description'])): ?>
                                        <p class="text-sm text-gray-700 mb-3">
                                            <?php echo nl2br(htmlspecialchars(substr($event['description'], 0, 100) . (strlen($event['description']) > 100 ? '...' : ''))); ?>
                                        </p>
                                    <?php endif; ?>
                                    
                                    <div class="flex justify-between items-center mt-4">
                                        <span class="text-xs text-gray-500">
                                            Created by: <?php echo htmlspecialchars($event['created_by_name']); ?>
                                        </span>
                                        <div class="flex space-x-2">
                                            <a href="?action=view&id=<?php echo $event['id']; ?>" 
                                               class="text-blue-600 hover:text-blue-800" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="?action=edit&id=<?php echo $event['id']; ?>" 
                                               class="text-yellow-600 hover:text-yellow-800" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="?action=delete&id=<?php echo $event['id']; ?>" 
                                               class="text-red-600 hover:text-red-800" 
                                               onclick="return confirm('Are you sure you want to delete this event?')" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                    
                    <!-- Pagination -->
                    <?php if ($total_pages > 1): ?>
                    <div class="flex justify-center mt-8">
                        <nav class="flex items-center space-x-2">
                            <?php if ($page > 1): ?>
                                <a href="?page=<?php echo $page - 1; ?>" class="px-3 py-1 rounded border border-gray-300 text-gray-600 hover:bg-gray-100">
                                    <i class="fas fa-chevron-left"></i>
                                </a>
                            <?php endif; ?>
                            
                            <?php 
                            // Show page numbers
                            $start_page = max(1, $page - 2);
                            $end_page = min($total_pages, $start_page + 4);
                            
                            if ($end_page - $start_page < 4) {
                                $start_page = max(1, $end_page - 4);
                            }
                            
                            for ($i = $start_page; $i <= $end_page; $i++): 
                            ?>
                                <a href="?page=<?php echo $i; ?>" class="px-3 py-1 rounded border <?php echo $i == $page ? 'bg-blue-600 text-white border-blue-600' : 'border-gray-300 text-gray-600 hover:bg-gray-100'; ?>">
                                    <?php echo $i; ?>
                                </a>
                            <?php endfor; ?>
                            
                            <?php if ($page < $total_pages): ?>
                                <a href="?page=<?php echo $page + 1; ?>" class="px-3 py-1 rounded border border-gray-300 text-gray-600 hover:bg-gray-100">
                                    <i class="fas fa-chevron-right"></i>
                                </a>
                            <?php endif; ?>
                        </nav>
                    </div>
                    <?php endif; ?>
                    
                <?php else: ?>
                    <div class="text-center py-8 text-gray-500">
                        <i class="fas fa-calendar-times text-4xl mb-3"></i>
                        <h3 class="text-lg font-medium mb-2">No Events Found</h3>
                        <p>No events have been created yet. Click "Add New Event" to create your first event.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Add Event Tab -->
        <div id="add-event-tab" class="tab-content hidden">
            <div class="bg-white p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Create New Event</h3>
                <form method="POST" enctype="multipart/form-data">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Event Title <span class="text-red-500">*</span></label>
                            <input type="text" name="title" required 
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Event Date <span class="text-red-500">*</span></label>
                            <input type="date" name="event_date" required 
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Start Time <span class="text-red-500">*</span></label>
                            <input type="time" name="start_time" required 
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">End Time <span class="text-red-500">*</span></label>
                            <input type="time" name="end_time" required 
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Location</label>
                            <input type="text" name="location" 
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Audience Type</label>
                            <select name="audience_type" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                    onchange="toggleTargetField(this.value)">
                                <option value="all">Everyone</option>
                                <option value="class">Specific Class</option>
                                <option value="teacher">Specific Teacher</option>
                            </select>
                        </div>
                        
                        <div id="target-field" class="hidden">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Select Target</label>
                            <select name="target_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="">Select Target</option>
                                <optgroup label="Classes" id="class-options">
                                    <?php while($class = mysqli_fetch_assoc($classes_result)): ?>
                                        <option value="class_<?php echo $class['id']; ?>"><?php echo htmlspecialchars($class['class_name']); ?></option>
                                    <?php endwhile; ?>
                                </optgroup>
                                <optgroup label="Teachers" id="teacher-options">
                                    <?php while($teacher = mysqli_fetch_assoc($teachers_result)): ?>
                                        <option value="teacher_<?php echo $teacher['id']; ?>"><?php echo htmlspecialchars($teacher['full_name']); ?></option>
                                    <?php endwhile; ?>
                                </optgroup>
                            </select>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Event Image (Max 5MB)</label>
                            <input type="file" name="event_image" accept="image/*" 
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <p class="text-xs text-gray-500 mt-1">Supported formats: JPG, JPEG, PNG, GIF</p>
                        </div>
                    </div>
                    
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                        <textarea name="description" rows="4" 
                                  class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"></textarea>
                    </div>
                    
                    <div class="flex justify-center">
                        <button type="submit" name="add_event" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg flex items-center">
                            <i class="fas fa-plus-circle mr-2"></i> Create Event
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- View Event Tab (shown when viewing a specific event) -->
        <?php if (isset($_GET['action']) && $_GET['action'] == 'view' && isset($event)): ?>
            <div id="view-event-tab" class="tab-content">
                <div class="bg-white p-6 rounded-lg shadow">
                    <div class="flex justify-between items-start mb-6">
                        <h3 class="text-2xl font-bold text-gray-800"><?php echo htmlspecialchars($event['title']); ?></h3>
                        <div class="flex space-x-2">
                            <a href="?action=edit&id=<?php echo $event['id']; ?>" 
                               class="bg-yellow-600 hover:bg-yellow-700 text-white px-4 py-2 rounded-lg flex items-center">
                                <i class="fas fa-edit mr-2"></i> Edit
                            </a>
                            <a href="events.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg flex items-center">
                                <i class="fas fa-arrow-left mr-2"></i> Back
                            </a>
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
                        <?php if (!empty($event['image_path'])): ?>
                            <div>
                                <img src="../uploads/events/<?php echo $event['image_path']; ?>" 
                                     alt="<?php echo htmlspecialchars($event['title']); ?>" 
                                     class="w-full rounded-lg shadow">
                            </div>
                        <?php endif; ?>
                        
                        <div>
                            <div class="bg-gray-50 p-4 rounded-lg">
                                <h4 class="text-lg font-semibold text-gray-800 mb-4">Event Details</h4>
                                
                                <div class="space-y-3">
                                    <div class="flex items-center">
                                        <i class="fas fa-calendar-day text-blue-600 w-6"></i>
                                        <span class="font-medium">Date:</span>
                                        <span class="ml-2"><?php echo date('F j, Y', strtotime($event['event_date'])); ?></span>
                                    </div>
                                    
                                    <div class="flex items-center">
                                        <i class="fas fa-clock text-blue-600 w-6"></i>
                                        <span class="font-medium">Time:</span>
                                        <span class="ml-2">
                                            <?php echo date('g:i A', strtotime($event['start_time'])) . ' - ' . date('g:i A', strtotime($event['end_time'])); ?>
                                        </span>
                                    </div>
                                    
                                    <?php if (!empty($event['location'])): ?>
                                        <div class="flex items-center">
                                            <i class="fas fa-map-marker-alt text-blue-600 w-6"></i>
                                            <span class="font-medium">Location:</span>
                                            <span class="ml-2"><?php echo htmlspecialchars($event['location']); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="flex items-center">
                                        <i class="fas fa-users text-blue-600 w-6"></i>
                                        <span class="font-medium">Audience:</span>
                                        <span class="ml-2">
                                            <?php 
                                            if ($event['audience_type'] == 'all') {
                                                echo 'Everyone';
                                            } elseif ($event['audience_type'] == 'class') {
                                                echo 'Class: ' . htmlspecialchars($event['target_id']);
                                            } elseif ($event['audience_type'] == 'teacher') {
                                                echo 'Teacher: ' . htmlspecialchars($event['target_id']);
                                            }
                                            ?>
                                        </span>
                                    </div>
                                    
                                    <div class="flex items-center">
                                        <i class="fas fa-user text-blue-600 w-6"></i>
                                        <span class="font-medium">Created by:</span>
                                        <span class="ml-2"><?php echo htmlspecialchars($event['created_by_name']); ?></span>
                                    </div>
                                    
                                    <div class="flex items-center">
                                        <i class="fas fa-calendar-plus text-blue-600 w-6"></i>
                                        <span class="font-medium">Created on:</span>
                                        <span class="ml-2"><?php echo date('F j, Y g:i A', strtotime($event['created_at'])); ?></span>
                                    </div>
                                    
                                    <?php if (!empty($event['updated_at'])): ?>
                                        <div class="flex items-center">
                                            <i class="fas fa-edit text-blue-600 w-6"></i>
                                            <span class="font-medium">Last updated:</span>
                                            <span class="ml-2"><?php echo date('F j, Y g:i A', strtotime($event['updated_at'])); ?></span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <?php if (!empty($event['description'])): ?>
                        <div class="bg-white p-4 rounded-lg border border-gray-200">
                            <h4 class="text-lg font-semibold text-gray-800 mb-3">Description</h4>
                            <p class="text-gray-700"><?php echo nl2br(htmlspecialchars($event['description'])); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Edit Event Tab (shown when editing a specific event) -->
        <?php if (isset($_GET['action']) && $_GET['action'] == 'edit' && isset($_GET['id'])): 
            $edit_id = mysqli_real_escape_string($conn, $_GET['id']);
            $edit_query = "SELECT * FROM events WHERE id = '$edit_id'";
            $edit_result = mysqli_query($conn, $edit_query);
            
            if (mysqli_num_rows($edit_result) > 0) {
                $edit_event = mysqli_fetch_assoc($edit_result);
            } else {
                $error = "Event not found!";
            }
        ?>
            <?php if (isset($edit_event)): ?>
            <div id="edit-event-tab" class="tab-content">
                <div class="bg-white p-6 rounded-lg shadow">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4">Edit Event</h3>
                    <form method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="event_id" value="<?php echo $edit_event['id']; ?>">
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Event Title <span class="text-red-500">*</span></label>
                                <input type="text" name="title" value="<?php echo htmlspecialchars($edit_event['title']); ?>" required 
                                       class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Event Date <span class="text-red-500">*</span></label>
                                <input type="date" name="event_date" value="<?php echo $edit_event['event_date']; ?>" required 
                                       class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Start Time <span class="text-red-500">*</span></label>
                                <input type="time" name="start_time" value="<?php echo $edit_event['start_time']; ?>" required 
                                       class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">End Time <span class="text-red-500">*</span></label>
                                <input type="time" name="end_time" value="<?php echo $edit_event['end_time']; ?>" required 
                                       class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Location</label>
                                <input type="text" name="location" value="<?php echo htmlspecialchars($edit_event['location']); ?>" 
                                       class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Audience Type</label>
                                <select name="audience_type" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                        onchange="toggleTargetField(this.value)">
                                    <option value="all" <?php echo $edit_event['audience_type'] == 'all' ? 'selected' : ''; ?>>Everyone</option>
                                    <option value="class" <?php echo $edit_event['audience_type'] == 'class' ? 'selected' : ''; ?>>Specific Class</option>
                                    <option value="teacher" <?php echo $edit_event['audience_type'] == 'teacher' ? 'selected' : ''; ?>>Specific Teacher</option>
                                </select>
                            </div>
                            
                            <div id="target-field" class="<?php echo empty($edit_event['target_id']) ? 'hidden' : ''; ?>">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Select Target</label>
                                <select name="target_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                                    <option value="">Select Target</option>
                                    <optgroup label="Classes">
                                        <?php 
                                        mysqli_data_seek($classes_result, 0);
                                        while($class = mysqli_fetch_assoc($classes_result)): 
                                            $value = "class_{$class['id']}";
                                            $selected = $edit_event['target_id'] == $value ? 'selected' : '';
                                        ?>
                                            <option value="<?php echo $value; ?>" <?php echo $selected; ?>>
                                                <?php echo htmlspecialchars($class['class_name']); ?>
                                            </option>
                                        <?php endwhile; ?>
                                    </optgroup>
                                    <optgroup label="Teachers">
                                        <?php 
                                        mysqli_data_seek($teachers_result, 0);
                                        while($teacher = mysqli_fetch_assoc($teachers_result)): 
                                            $value = "teacher_{$teacher['id']}";
                                            $selected = $edit_event['target_id'] == $value ? 'selected' : '';
                                        ?>
                                            <option value="<?php echo $value; ?>" <?php echo $selected; ?>>
                                                <?php echo htmlspecialchars($teacher['full_name']); ?>
                                            </option>
                                        <?php endwhile; ?>
                                    </optgroup>
                                </select>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Event Image (Max 5MB)</label>
                                <input type="file" name="event_image" accept="image/*" 
                                       class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <p class="text-xs text-gray-500 mt-1">Supported formats: JPG, JPEG, PNG, GIF</p>
                                
                                <?php if (!empty($edit_event['image_path'])): ?>
                                    <div class="mt-2">
                                        <p class="text-sm text-gray-600">Current Image:</p>
                                        <img src="../uploads/events/<?php echo $edit_event['image_path']; ?>" 
                                             alt="Current event image" class="w-32 h-32 object-cover rounded mt-1">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="mb-6">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                            <textarea name="description" rows="4" 
                                      class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo htmlspecialchars($edit_event['description']); ?></textarea>
                        </div>
                        
                        <div class="flex justify-center space-x-4">
                            <button type="submit" name="edit_event" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg flex items-center">
                                <i class="fas fa-save mr-2"></i> Update Event
                            </button>
                            <a href="events.php" class="bg-gray-600 hover:bg-gray-700 text-white px-6 py-2 rounded-lg flex items-center">
                                <i class="fas fa-times mr-2"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<script>
// Tab navigation
function openTab(tabId) {
    // Hide all tab contents
    document.querySelectorAll('.tab-content').forEach(tab => {
        tab.classList.add('hidden');
    });
    
    // Remove active class from all tabs
    document.querySelectorAll('.flex.border-b button').forEach(btn => {
        btn.classList.remove('text-blue-600', 'border-blue-600');
        btn.classList.add('text-gray-600');
    });
    
    // Show the selected tab content and mark tab as active
    document.getElementById(tabId).classList.remove('hidden');
    
    // Update the button styles
    const activeBtn = document.getElementById(tabId + '-btn');
    if (activeBtn) {
        activeBtn.classList.remove('text-gray-600');
        activeBtn.classList.add('text-blue-600', 'border-blue-600');
    }
}

// Initialize tabs
document.addEventListener('DOMContentLoaded', function() {
    // Check which tab to show based on URL parameters
    const urlParams = new URLSearchParams(window.location.search);
    const action = urlParams.get('action');
    
    if (action === 'view') {
        openTab('view-event-tab');
    } else if (action === 'edit') {
        openTab('edit-event-tab');
    } else {
        openTab('events-tab');
    }
    
    // Add click events to tab buttons
    document.getElementById('events-tab-btn').addEventListener('click', function() {
        openTab('events-tab');
    });
    
    document.getElementById('add-event-tab-btn').addEventListener('click', function() {
        openTab('add-event-tab');
    });
    
    <?php if (isset($_GET['action']) && $_GET['action'] == 'view'): ?>
        document.getElementById('view-event-tab-btn').addEventListener('click', function() {
            openTab('view-event-tab');
        });
    <?php endif; ?>
});

// Toggle target field based on audience type
function toggleTargetField(audienceType) {
    const targetField = document.getElementById('target-field');
    if (audienceType === 'class' || audienceType === 'teacher') {
        targetField.classList.remove('hidden');
    } else {
        targetField.classList.add('hidden');
    }
}

// Form validation
const forms = document.querySelectorAll('form');
forms.forEach(form => {
    form.addEventListener('submit', function(e) {
        const requiredFields = form.querySelectorAll('[required]');
        let valid = true;
        
        requiredFields.forEach(field => {
            if (!field.value.trim()) {
                valid = false;
                field.classList.add('border-red-500');
            } else {
                field.classList.remove('border-red-500');
            }
        });
        
        // Validate image file size
        const imageInput = form.querySelector('input[type="file"]');
        if (imageInput && imageInput.files.length > 0) {
            const fileSize = imageInput.files[0].size;
            if (fileSize > 5242880) { // 5MB
                valid = false;
                alert('Image file size must be less than 5MB');
                imageInput.classList.add('border-red-500');
            }
        }
        
        if (!valid) {
            e.preventDefault();
            alert('Please fill in all required fields correctly');
        }
    });
});
</script>

</body>
</html>

<?php
include 'include/footer.php';
?>