<?php
include '../config/conn.php';

// Fetch all teachers
$export_query = "SELECT * FROM users WHERE role='teacher' ORDER BY created_at DESC";
$result = mysqli_query($conn, $export_query);

// Set headers for Excel
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment; filename="teachers_export_' . date('Y-m-d') . '.xls"');
header('Pragma: no-cache');
header('Expires: 0');

// Column headers
echo "ID\tTeacher ID\tFull Name\tEmail\tPhone\tSubjects\tStatus\tCreated At\n";

// Output data
while ($teacher = mysqli_fetch_assoc($result)) {
    echo $teacher['id'] . "\t";
    echo $teacher['teacher_id'] . "\t";
    echo $teacher['full_name'] . "\t";
    echo $teacher['email'] . "\t";
    echo $teacher['phone'] . "\t";
    echo $teacher['subjects'] . "\t";
    echo $teacher['status'] . "\t";
    echo $teacher['created_at'] . "\n";
}

mysqli_close($conn);
exit();
?>

