<?php
include '../config/conn.php';
require '../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Validate month input
if (!isset($_GET['month']) || empty($_GET['month'])) {
    die("No month selected for export.");
}

$month = $_GET['month']; // format: YYYY-MM
if (!preg_match('/^\d{4}-\d{2}$/', $month)) {
    die("Invalid month format. Use YYYY-MM.");
}

// Fetch teacher attendance for the given month
$query = "
    SELECT u.teacher_id, u.full_name, u.email, u.phone, ta.status, ta.attendance_date, ta.recorded_at
    FROM teacher_attendance ta
    JOIN users u ON ta.teacher_id = u.id
    WHERE DATE_FORMAT(ta.attendance_date, '%Y-%m') = '$month'
    ORDER BY u.full_name, ta.attendance_date
";
$result = mysqli_query($conn, $query);

// Create spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Headers
$sheet->setCellValue('A1', 'Teacher ID');
$sheet->setCellValue('B1', 'Full Name');
$sheet->setCellValue('C1', 'Email');
$sheet->setCellValue('D1', 'Phone');
$sheet->setCellValue('E1', 'Attendance Date');
$sheet->setCellValue('F1', 'Status');
$sheet->setCellValue('G1', 'Recorded At');

// Fill data
$row = 2;
while ($teacher = mysqli_fetch_assoc($result)) {
    $sheet->setCellValue('A'.$row, $teacher['teacher_id']);
    $sheet->setCellValue('B'.$row, $teacher['full_name']);
    $sheet->setCellValue('C'.$row, $teacher['email']);
    $sheet->setCellValue('D'.$row, $teacher['phone']);
    $sheet->setCellValue('E'.$row, $teacher['attendance_date']);
    $sheet->setCellValue('F'.$row, ucfirst($teacher['status']));
    $sheet->setCellValue('G'.$row, $teacher['recorded_at']);
    $row++;
}

// Export file
$writer = new Xlsx($spreadsheet);
$filename = "Teacher_Attendance_$month.xlsx";

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment; filename=\"$filename\"");
$writer->save("php://output");
exit;
