<?php
require_once '../config/conn.php';
session_start();

// Check if user is logged in and is admin
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('HTTP/1.1 403 Forbidden');
    echo json_encode(['error' => 'Access denied']);
    exit();
}

if (!isset($_GET['id'])) {
    header('HTTP/1.1 400 Bad Request');
    echo json_encode(['error' => 'Notice ID is required']);
    exit();
}

$notice_id = intval($_GET['id']);

// Fetch notice details
$query = "SELECT n.*, u.full_name as created_by_name 
          FROM notices n 
          LEFT JOIN users u ON n.created_by = u.id 
          WHERE n.id = $notice_id";
$result = mysqli_query($conn, $query);

if (!$result || mysqli_num_rows($result) === 0) {
    header('HTTP/1.1 404 Not Found');
    echo json_encode(['error' => 'Notice not found']);
    exit();
}

$notice = mysqli_fetch_assoc($result);

// Determine audience display text
$audience_text = '';
if ($notice['audience_type'] === 'all') {
    $audience_text = 'All Students';
} elseif ($notice['audience_type'] === 'class') {
    $class_query = "SELECT class_name FROM classes WHERE id = " . $notice['target_id'];
    $class_result = mysqli_query($conn, $class_query);
    if ($class_result && mysqli_num_rows($class_result) > 0) {
        $class_name = mysqli_fetch_assoc($class_result)['class_name'];
        $audience_text = 'Class: ' . $class_name;
    } else {
        $audience_text = 'Class: Not found';
    }
} elseif ($notice['audience_type'] === 'section') {
    $section_query = "SELECT s.section_name, c.class_name 
                      FROM sections s 
                      LEFT JOIN classes c ON s.class_id = c.id 
                      WHERE s.id = " . $notice['target_id'];
    $section_result = mysqli_query($conn, $section_query);
    if ($section_result && mysqli_num_rows($section_result) > 0) {
        $section = mysqli_fetch_assoc($section_result);
        $audience_text = 'Section: ' . $section['class_name'] . ' - ' . $section['section_name'];
    } else {
        $audience_text = 'Section: Not found';
    }
} elseif ($notice['audience_type'] === 'student') {
    $student_query = "SELECT full_name, student_id FROM students WHERE id = " . $notice['target_id'];
    $student_result = mysqli_query($conn, $student_query);
    if ($student_result && mysqli_num_rows($student_result) > 0) {
        $student = mysqli_fetch_assoc($student_result);
        $audience_text = 'Student: ' . $student['full_name'] . ' (' . $student['student_id'] . ')';
    } else {
        $audience_text = 'Student: Not found';
    }
}

// Prepare response
$response = [
    'id' => $notice['id'],
    'title' => $notice['title'],
    'content' => $notice['content'],
    'audience' => $audience_text,
    'priority' => $notice['priority'],
    'author' => $notice['created_by_name'],
    'created_at' => date('M j, Y', strtotime($notice['created_at'])),
    'expiry_date' => $notice['expiry_date'] ? date('M j, Y', strtotime($notice['expiry_date'])) : null
];

header('Content-Type: application/json');
echo json_encode($response);
?>