<?php
ob_start();
include '../config/conn.php';

// Check if user is logged in
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    die("Unauthorized access");
}

// Validate payment ID
$payment_id = isset($_GET['payment_id']) ? intval($_GET['payment_id']) : 0;
if ($payment_id <= 0) {
    die("Invalid payment ID");
}

// Get payment details with proper column names
$receipt_query = "SELECT p.*, i.description as invoice_description, s.full_name, s.student_id, 
                         c.class_name, sec.section_name
                  FROM payments p
                  JOIN invoices i ON p.invoice_id = i.id
                  JOIN students s ON p.student_id = s.id
                  LEFT JOIN classes c ON s.class = c.id
                  LEFT JOIN sections sec ON s.section = sec.id
                  WHERE p.id = $payment_id";

$receipt_result = mysqli_query($conn, $receipt_query);

if (!$receipt_result || mysqli_num_rows($receipt_result) == 0) {
    die("Receipt not found for payment ID: $payment_id");
}

$payment_data = mysqli_fetch_assoc($receipt_result);

// Generate receipt HTML
ob_clean();
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .header { text-align: center; margin-bottom: 30px; border-bottom: 2px solid #333; padding-bottom: 20px; }
        .school-name { font-size: 24px; font-weight: bold; color: #2c3e50; }
        .receipt-title { font-size: 20px; color: #3498db; margin-top: 10px; }
        .details { margin: 20px 0; }
        .detail-row { margin: 10px 0; padding: 5px 0; }
        .label { font-weight: bold; display: inline-block; width: 150px; }
        .footer { margin-top: 40px; text-align: center; color: #7f8c8d; }
        .signature { margin-top: 60px; border-top: 1px solid #000; width: 200px; margin: 0 auto; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background-color: #f2f2f2; font-weight: bold; }
    </style>
</head>
<body>
    <div class="header">
        <div class="school-name">ADINOHEIGHT COLLEGE</div>
        <div class="receipt-title">PAYMENT RECEIPT</div>
    </div>
    
    <div class="details">
        <div class="detail-row"><span class="label">Receipt Number:</span> REC<?php echo str_pad($payment_id, 6, '0', STR_PAD_LEFT); ?></div>
        <div class="detail-row"><span class="label">Date Issued:</span> <?php echo date('F j, Y', strtotime($payment_data['payment_date'])); ?></div>
        <div class="detail-row"><span class="label">Student ID:</span> <?php echo htmlspecialchars($payment_data['student_id']); ?></div>
        <div class="detail-row"><span class="label">Student Name:</span> <?php echo htmlspecialchars($payment_data['full_name']); ?></div>
        <?php if (!empty($payment_data['class_name'])): ?>
            <div class="detail-row"><span class="label">Class:</span> <?php echo htmlspecialchars($payment_data['class_name']); ?></div>
        <?php endif; ?>
        <?php if (!empty($payment_data['section_name'])): ?>
            <div class="detail-row"><span class="label">Section:</span> <?php echo htmlspecialchars($payment_data['section_name']); ?></div>
        <?php endif; ?>
        <div class="detail-row"><span class="label">Description:</span> <?php echo htmlspecialchars($payment_data['invoice_description']); ?></div>
        <div class="detail-row"><span class="label">Amount Paid:</span> ₦ <?php echo number_format($payment_data['amount'], 2); ?></div>
        <div class="detail-row"><span class="label">Payment Method:</span> <?php echo ucfirst($payment_data['payment_method']); ?></div>
        <div class="detail-row"><span class="label">Transaction ID:</span> <?php echo $payment_data['transaction_id']; ?></div>
    </div>
    
    <div class="footer">
        <div>Thank you for your payment!</div>
        <div>AdinoHeight College</div>
        <div class="signature">Authorized Signature</div>
    </div>
</body>
</html>
<?php
ob_end_flush();
?>