<?php
include '../config/conn.php';

if (isset($_GET['class_id']) && isset($_GET['section_id'])) {
    $class_id = mysqli_real_escape_string($conn, $_GET['class_id']);
    $section_id = mysqli_real_escape_string($conn, $_GET['section_id']);
    $for_promotion = isset($_GET['for_promotion']);
    
    $students_query = "SELECT s.id, s.student_id, s.full_name, s.roll_number, 
                              c.class_name, sec.section_name
                       FROM students s
                       JOIN classes c ON s.class = c.id
                       JOIN sections sec ON s.section = sec.id
                       WHERE s.class = $class_id AND s.section = $section_id 
                       AND s.status = 'active'
                       ORDER BY s.roll_number";
    
    $students_result = mysqli_query($conn, $students_query);
    
    if ($for_promotion) {
        // Fetch all classes for target selection
        $classes_query = "SELECT id, class_name FROM classes WHERE status = 'active' ORDER BY class_name";
        $classes_result = mysqli_query($conn, $classes_query);
        
        echo '<div class="promotion-form">';
        echo '<h3 class="text-lg font-semibold text-gray-800 mb-4">Promote Students</h3>';
        
        echo '<form id="promotion-form" method="POST">';
        echo '<input type="hidden" name="current_class" value="' . $class_id . '">';
        echo '<input type="hidden" name="current_section" value="' . $section_id . '">';
        
        echo '<div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">';
        echo '<div>';
        echo '<label class="block text-sm font-medium text-gray-700 mb-1">Target Class</label>';
        echo '<select name="target_class" id="target_class" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>';
        echo '<option value="">Select Target Class</option>';
        while ($class = mysqli_fetch_assoc($classes_result)) {
            echo '<option value="' . $class['id'] . '">' . $class['class_name'] . '</option>';
        }
        echo '</select>';
        echo '</div>';
        
        echo '<div>';
        echo '<label class="block text-sm font-medium text-gray-700 mb-1">Target Section</label>';
        echo '<select name="target_section" id="target_section" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" disabled required>';
        echo '<option value="">Select Target Section</option>';
        echo '</select>';
        echo '</div>';
        echo '</div>';
        
        echo '<div class="overflow-x-auto">';
        echo '<table class="student-table">';
        echo '<thead>';
        echo '<tr>';
        echo '<th><input type="checkbox" id="select_all"></th>';
        echo '<th>Roll No</th>';
        echo '<th>Student ID</th>';
        echo '<th>Name</th>';
        echo '<th>Current Class</th>';
        echo '</tr>';
        echo '</thead>';
        echo '<tbody>';
        
        if (mysqli_num_rows($students_result) > 0) {
            while ($student = mysqli_fetch_assoc($students_result)) {
                echo '<tr>';
                echo '<td><input type="checkbox" name="student_ids[]" value="' . $student['id'] . '" class="student-checkbox"></td>';
                echo '<td>' . $student['roll_number'] . '</td>';
                echo '<td>' . $student['student_id'] . '</td>';
                echo '<td>' . $student['full_name'] . '</td>';
                echo '<td>' . $student['class_name'] . ' - ' . $student['section_name'] . '</td>';
                echo '</tr>';
            }
        } else {
            echo '<tr><td colspan="5" class="text-center py-4 text-gray-500">No students found in this class and section.</td></tr>';
        }
        
        echo '</tbody>';
        echo '</table>';
        echo '</div>';
        
        if (mysqli_num_rows($students_result) > 0) {
            echo '<div class="mt-6 flex justify-center">';
            echo '<button type="submit" id="promote-btn" class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-lg flex items-center">';
            echo '<i class="fas fa-graduation-cap mr-2"></i> Promote Selected Students';
            echo '</button>';
            echo '</div>';
        }
        
        echo '</form>';
        echo '</div>';
    }
}
?>