<!-- Header -->
<header class="bg-white shadow-sm z-10">
    <div class="flex items-center justify-between px-6 py-4 header-content">
        <div class="flex items-center">
            <button class="text-gray-500 focus:outline-none lg:hidden menu-btn">
                <i class="fas fa-bars text-xl"></i>
            </button>
            <h2 class="heading text-xl font-semibold text-gray-800 ml-4">Dashboard</h2>
        </div>
        
        <div class="flex items-center">
            <!-- Mobile search button -->
            <button class="mobile-search-btn text-gray-500 focus:outline-none mx-4 lg:hidden">
                <i class="fas fa-search text-xl"></i>
            </button>
            
            <!-- Desktop search container -->
            <div class="relative search-container hidden lg:block">
                <div class="flex items-center">
                  
                    
                </div>
                
                <!-- Search suggestions -->
                <div class="search-suggestions absolute w-full mt-1 bg-white rounded-lg shadow-medium z-20 overflow-hidden">
                    <div class="p-2 border-b border-gray-100">
                        <p class="text-xs text-gray-500 uppercase tracking-wide">Recent Searches</p>
                    </div>
                    <div class="p-2 hover:bg-gray-50 cursor-pointer">
                        <div class="flex items-center">
                            <i class="fas fa-history text-gray-400 mr-2"></i>
                            <span class="text-sm">Student attendance reports</span>
                        </div>
                    </div>
                    <div class="p-2 hover:bg-gray-50 cursor-pointer">
                        <div class="flex items-center">
                            <i class="fas fa-history text-gray-400 mr-2"></i>
                            <span class="text-sm">Grade 10 science results</span>
                        </div>
                    </div>
                    <div class="p-2 border-b border-gray-100">
                        <p class="text-xs text-gray-500 uppercase tracking-wide">Quick Access</p>
                    </div>
                    <div class="p-2 hover:bg-gray-50 cursor-pointer">
                        <div class="flex items-center">
                            <i class="fas fa-user-graduate text-primary mr-2"></i>
                            <span class="text-sm">Student directory</span>
                        </div>
                    </div>
                    <div class="p-2 hover:bg-gray-50 cursor-pointer">
                        <div class="flex items-center">
                            <i class="fas fa-book text-success mr-2"></i>
                            <span class="text-sm">Library resources</span>
                        </div>
                    </div>
                    <div class="p-2 hover:bg-gray-50 cursor-pointer">
                        <div class="flex items-center">
                            <i class="fas fa-chart-bar text-warning mr-2"></i>
                            <span class="text-sm">Financial reports</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="relative ml-4">
                <button class="text-gray-500 focus:outline-none mx-4 relative">
                    <i class="far fa-bell text-xl"></i>
                    <span class="absolute top-0 right-2 h-3 w-3 rounded-full bg-accent"></span>
                </button>
                
                <button class="text-gray-500 focus:outline-none mx-4 relative">
                    <i class="far fa-envelope text-xl"></i>
                    <span class="absolute top-0 right-0 h-3 w-3 rounded-full bg-accent"></span>
                </button>
            </div>
        </div>
    </div>
</header>

<!-- Mobile search container -->
<div class="mobile-search-overlay"></div>
<div class="mobile-search-container">
    <div class="flex items-center">
        <input type="text" placeholder="Search students, staff, documents..." 
               class="flex-1 px-4 py-3 rounded-l-lg border border-gray-200 focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
        <button class="mobile-search-close bg-gray-100 text-gray-700 px-4 py-3 border border-l-0 border-gray-200 rounded-r-lg">
            <i class="fas fa-times"></i>
        </button>
    </div>
    
    <!-- Mobile search suggestions -->
    <div class="mt-2 bg-white rounded-lg shadow-medium overflow-hidden">
        <div class="p-2 border-b border-gray-100">
            <p class="text-xs text-gray-500 uppercase tracking-wide">Recent Searches</p>
        </div>
        <div class="p-2 hover:bg-gray-50 cursor-pointer">
            <div class="flex items-center">
                <i class="fas fa-history text-gray-400 mr-2"></i>
                <span class="text-sm">Student attendance reports</span>
            </div>
        </div>
        <div class="p-2 hover:bg-gray-50 cursor-pointer">
            <div class="flex items-center">
                <i class="fas fa-history text-gray-400 mr-2"></i>
                <span class="text-sm">Grade 10 science results</span>
            </div>
        </div>
        <div class="p-2 border-b border-gray-100">
            <p class="text-xs text-gray-500 uppercase tracking-wide">Quick Access</p>
        </div>
        <div class="p-2 hover:bg-gray-50 cursor-pointer">
            <div class="flex items-center">
                <i class="fas fa-user-graduate text-primary mr-2"></i>
                <span class="text-sm">Student directory</span>
            </div>
        </div>
        <div class="p-2 hover:bg-gray-50 cursor-pointer">
            <div class="flex items-center">
                <i class="fas fa-book text-success mr-2"></i>
                <span class="text-sm">Library resources</span>
            </div>
        </div>
    </div>
</div>