<!-- Sidebar -->
<div class="sidebar bg-white w-64 md:w-72 py-6 px-4 flex flex-col justify-between shadow-sm overflow-y-auto">

    <!-- Logo -->
    <div class="mb-10 px-2">
       <h1 class="heading text-xl font-semibold text-primary flex items-center">
    <img src="../img/logotwo.png" alt="Adinoheight Logo" 
         class="h-20 w-20 mr-3 object-contain"> 
    Adinoheight
</h1>

        <p class="text-xs text-gray-500 mt-1">Admin Portal</p>
    </div>
    <!-- Navigation -->
    <nav class="flex-1">
        <ul class="space-y-1">
            <!-- Dashboard -->
            <li>
                <a href="index.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item hover:bg-gray-100">
                    <i class="fas fa-home mr-3 w-5 text-center"></i>
                    <span>Dashboard</span>
                </a>
            </li>

            <!-- Student Management -->
            <li>
                <button class="flex items-center justify-between w-full px-4 py-3 text-gray-700 rounded-lg nav-item student-btn">
                    <div class="flex items-center">
                        <i class="fas fa-user-graduate mr-3 w-5 text-center"></i>
                        <span>Student</span>
                    </div>
                    <i class="fas fa-chevron-down text-xs transition-transform"></i>
                </button>
                <ul class="submenu pl-9 mt-1">
                    <li class="py-2"><a href="add_student.php" class="text-gray-600 hover:text-primary">Add New Student</a></li>
                    <li class="py-2"><a href="student_table.php" class="text-gray-600 hover:text-primary">View Students</a></li>
                    <li class="py-2"><a href="promote.php" class="text-gray-600 hover:text-primary">Student Promotion</a></li>
                    <li class="py-2"><a href="student_attendance.php" class="text-gray-600 hover:text-primary">Attendance</a></li>
                </ul>
            </li>
            
            <!-- Teacher Management -->
            <li>
                <button class="flex items-center justify-between w-full px-4 py-3 text-gray-700 rounded-lg nav-item staff-btn">
                    <div class="flex items-center">
                        <i class="fas fa-chalkboard-teacher mr-3 w-5 text-center"></i>
                        <span>Teacher</span>
                    </div>
                    <i class="fas fa-chevron-down text-xs transition-transform"></i>
                </button>
                <ul class="submenu pl-9 mt-1">
                    <li class="py-2"><a href="add_teacher.php" class="text-gray-600 hover:text-primary">Add Teachers</a></li>
                    <li class="py-2"><a href="teacher_table.php" class="text-gray-600 hover:text-primary">View Teachers</a></li>
                    <li class="py-2"><a href="teacher_attendance.php" class="text-gray-600 hover:text-primary">Attendance</a></li>
                    <li class="py-2"><a href="admin_leave.php" class="text-gray-600 hover:text-primary">Leave</a></li>
                </ul>
            </li>
                
            <!-- Parent Management -->
            <li>
                <button class="flex items-center justify-between w-full px-4 py-3 text-gray-700 rounded-lg nav-item transport-btn">
                    <div class="flex items-center">
                        <i class="fas fa-users mr-3 w-5 text-center"></i>
                        <span>Parent</span>
                    </div>
                    <i class="fas fa-chevron-down text-xs transition-transform"></i>
                </button>
                <ul class="submenu pl-9 mt-1">
                    <li class="py-2"><a href="add_parent.php" class="text-gray-600 hover:text-primary">Add Parent</a></li>
                    <li class="py-2"><a href="parents.php" class="text-gray-600 hover:text-primary">View Parents</a></li>
                </ul>
            </li>
            
            <!-- Examinations -->
            <li>
                <button class="flex items-center justify-between w-full px-4 py-3 text-gray-700 rounded-lg nav-item hostel-btn">
                    <div class="flex items-center">
                        <i class="fas fa-file-alt mr-3 w-5 text-center"></i>
                        <span>Examinations</span>
                    </div>
                    <i class="fas fa-chevron-down text-xs transition-transform"></i>
                </button>
                <ul class="submenu pl-9 mt-1">
                    <li class="py-2"><a href="manage_exam.php" class="text-gray-600 hover:text-primary">Manage Exams</a></li>
                    <li class="py-2"><a href="add_score.php" class="text-gray-600 hover:text-primary">Upload Grade</a></li>
                    <li class="py-2"><a href="logo.php" class="text-gray-600 hover:text-primary">Upload Logo</a></li>
                    <li class="py-2"><a href="result.php" class="text-gray-600 hover:text-primary">Examinations</a></li>
                </ul>
            </li>

            <!-- Academic -->
            <li>
                <button class="flex items-center justify-between w-full px-4 py-3 text-gray-700 rounded-lg nav-item academic-btn">
                    <div class="flex items-center">
                        <i class="fas fa-book-open mr-3 w-5 text-center"></i>
                        <span>Academic</span>
                    </div>
                    <i class="fas fa-chevron-down text-xs transition-transform"></i>
                </button>
                <ul class="submenu pl-9 mt-1">
                    <li class="py-2"><a href="classes.php" class="text-gray-600 hover:text-primary">Classes</a></li>
                    <li class="py-2"><a href="subject.php" class="text-gray-600 hover:text-primary">Subjects</a></li>
                    <li class="py-2"><a href="timetable.php" class="text-gray-600 hover:text-primary">Timetable</a></li>
                </ul>
            </li>
            
            <!-- Finance -->
            <li>
                <button class="flex items-center justify-between w-full px-4 py-3 text-gray-700 rounded-lg nav-item finance-btn">
                    <div class="flex items-center">
                        <i class="fas fa-wallet mr-3 w-5 text-center"></i>
                        <span>Finance</span>
                    </div>
                    <i class="fas fa-chevron-down text-xs transition-transform"></i>
                </button>
                <ul class="submenu pl-9 mt-1">
                    <li class="py-2"><a href="payment.php" class="text-gray-600 hover:text-primary">Create Invoice</a></li>
                    <li class="py-2"><a href="view_invoices.php" class="text-gray-600 hover:text-primary">Invoice</a></li>
                </ul>
            </li>
            
            <!-- CBT -->
            <li>
                <button class="flex items-center justify-between w-full px-4 py-3 text-gray-700 rounded-lg nav-item library-btn">
                    <div class="flex items-center">
                        <i class="fas fa-laptop-code mr-3 w-5 text-center"></i>
                        <span>CBT</span>
                    </div>
                    <i class="fas fa-chevron-down text-xs transition-transform"></i>
                </button>
                <ul class="submenu pl-9 mt-1">
                    <li class="py-2"><a href="quiz.php" class="text-gray-600 hover:text-primary">Quiz</a></li>
                    <li class="py-2"><a href="release.php" class="text-gray-600 hover:text-primary">Result</a></li>
                </ul>
            </li>
            
            <!-- Noticeboard -->
            <li>
                <a href="noticeboard.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-bullhorn mr-3 w-5 text-center"></i>
                    <span>Noticeboard</span>
                </a>
            </li>
         <!-- CCTV -->
<li>
    <a href="cctv.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
        <i class="fas fa-video mr-3 w-5 text-center"></i>
        <span>CCTV</span>
    </a>
</li>

<!-- Event -->
<li>
    <a href="event.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
        <i class="fas fa-calendar-alt mr-3 w-5 text-center"></i>
        <span>Event</span>
    </a>
</li>

            
            <!-- Settings -->
            <li>
                <a href="edit_profile.php" class="flex items-center px-4 py-3 text-gray-700 rounded-lg nav-item">
                    <i class="fas fa-cog mr-3 w-5 text-center"></i>
                    <span>Settings</span>
                </a>
            </li>
        </ul>
    </nav>

    <!-- User section -->
    <div class="pt-6 mt-6 border-t border-gray-100">
        <div class="relative">
            <button class="flex items-center w-full px-4 py-2 hover:bg-gray-100 rounded-lg focus:outline-none user-dropdown-btn">
                <div class="flex-shrink-0">
                    <img src="../uploads/<?php echo htmlspecialchars($user_image); ?>" 
                        alt="Profile" 
                        class="profile-img"
                        style="width:60px; height:60px; object-fit:cover; border-radius:50%; border:3px solid #4CAF50; box-shadow:0px 4px 10px rgba(0,0,0,0.2);">
                </div>
                <div class="ml-3 text-left">
                    <p class="text-sm font-medium text-gray-700"><?= htmlspecialchars($user_name) ?></p>
                    <p class="text-xs font-medium text-gray-500"><?= htmlspecialchars($user_role) ?></p>
                </div>
                <i class="fas fa-chevron-down ml-auto text-xs text-gray-500"></i>
            </button>

            <!-- Dropdown -->
            <div class="hidden absolute bottom-12 left-4 w-48 bg-white border rounded-lg shadow-md user-dropdown">
                <a href="profile.php" class="block px-4 py-2 text-sm text-gray-600 hover:bg-gray-100">My Profile</a>
                <a href="edit_profile.php" class="block px-4 py-2 text-sm text-gray-600 hover:bg-gray-100">Settings</a>
                <a href="logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-red-50">Logout</a>
            </div>
        </div>
    </div>
</div>

<!-- Overlay for mobile -->
<div class="overlay"></div>

<!-- JS for dropdown -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const userBtn = document.querySelector(".user-dropdown-btn");
        const dropdown = document.querySelector(".user-dropdown");

        if (userBtn && dropdown) {
            userBtn.addEventListener("click", () => {
                dropdown.classList.toggle("hidden");
            });
        }
    });
</script>
