<?php
// Start output buffering to prevent any output
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Initialize variables
$success = '';
$error = '';

// Handle logo upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['logo'])) {
    $uploadDir = '../uploads/';
    
    // Create upload directory if it doesn't exist
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }
    
    $fileName = basename($_FILES['logo']['name']);
    $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
    $newFileName = 'school_logo_' . time() . '.' . $fileExt;
    $targetPath = $uploadDir . $newFileName;
    
    // Validate file type
    $allowedExtensions = ['jpg', 'jpeg', 'png', 'gif'];
    if (!in_array($fileExt, $allowedExtensions)) {
        $error = "Only JPG, JPEG, PNG, and GIF files are allowed.";
    } elseif ($_FILES['logo']['size'] > 5000000) { // 5MB limit
        $error = "File size must be less than 5MB.";
    } elseif (move_uploaded_file($_FILES['logo']['tmp_name'], $targetPath)) {
        // Save to database
        $school_name = isset($_POST['school_name']) ? mysqli_real_escape_string($conn, $_POST['school_name']) : 'Adino Height School';
        $address = isset($_POST['address']) ? mysqli_real_escape_string($conn, $_POST['address']) : '123 School Street, City, State';
        $phone = isset($_POST['phone']) ? mysqli_real_escape_string($conn, $_POST['phone']) : '+1234567890';
        $email = isset($_POST['email']) ? mysqli_real_escape_string($conn, $_POST['email']) : 'info@adinoheight.edu';
        $motto = isset($_POST['motto']) ? mysqli_real_escape_string($conn, $_POST['motto']) : 'Excellence in Education';
        
        // Check if school info already exists
        $check_query = "SELECT id FROM school_info LIMIT 1";
        $check_result = mysqli_query($conn, $check_query);
        
        if (mysqli_num_rows($check_result) > 0) {
            // Update existing record
            $query = "UPDATE school_info SET school_name = '$school_name', address = '$address', phone = '$phone', email = '$email', logo = '$newFileName', motto = '$motto'";
        } else {
            // Insert new record
            $query = "INSERT INTO school_info (school_name, address, phone, email, logo, motto) 
                     VALUES ('$school_name', '$address', '$phone', '$email', '$newFileName', '$motto')";
        }
        
        if (mysqli_query($conn, $query)) {
            $success = "Logo uploaded successfully!";
            // Update the school_info array with new values
            $school_info['logo'] = $newFileName;
            $school_info['school_name'] = $school_name;
            $school_info['address'] = $address;
            $school_info['phone'] = $phone;
            $school_info['email'] = $email;
            $school_info['motto'] = $motto;
        } else {
            $error = "Database error: " . mysqli_error($conn);
        }
    } else {
        $error = "Sorry, there was an error uploading your file.";
    }
}

// Fetch school information
$query = "SELECT * FROM school_info LIMIT 1";
$result = mysqli_query($conn, $query);
$school_info = mysqli_fetch_assoc($result);

// If no school info exists, create default
if (!$school_info) {
    $school_info = [
        'school_name' => 'Adino Height School',
        'address' => '123 School Street, City, State',
        'phone' => '+1234567890',
        'email' => 'info@adinoheight.edu',
        'logo' => '',
        'motto' => 'Excellence in Education'
    ];
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>School Logo Management</title>
    <style>
        .logo-preview {
            width: 400px;
            height: 400px;
            border: 2px dashed #ccc;
            padding: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .logo-preview img {
            width: 200px;
            height: 200px;
        }
    </style>
</head>
<body class="bg-gray-100 min-h-screen">
    <div class="container mx-auto px-2 py-2">
        <div class="max-w-4xl mx-auto bg-white overflow-hidden">
            <div class="bg-blue-600 py-4 px-6">
                <h1 class="text-2xl font-bold text-white">School Logo Management</h1>
            </div>
            
            <div class="p-6">
                <?php if (!empty($success)): ?>
                    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                        <?php echo $success; ?>
                    </div>
                <?php endif; ?>
                
                <?php if (!empty($error)): ?>
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                        <?php echo $error; ?>
                    </div>
                <?php endif; ?>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Logo Upload Form -->
                    <div>
                        <h2 class="text-xl font-semibold mb-4">Upload School Logo</h2>
                        <form action="" method="POST" enctype="multipart/form-data">
                            <div class="mb-4">
                                <label class="block text-gray-700 text-sm font-bold mb-2" for="logo">
                                    Select Logo Image
                                </label>
                                <input type="file" name="logo" id="logo" accept="image/*" class="w-full px-3 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                                <p class="text-xs text-gray-500 mt-1">Allowed formats: JPG, PNG, GIF. Max size: 5MB</p>
                            </div>
                            
                            <div class="mb-4">
                                <label class="block text-gray-700 text-sm font-bold mb-2" for="school_name">
                                    School Name
                                </label>
                                <input type="text" name="school_name" value="<?php echo htmlspecialchars($school_info['school_name']); ?>" class="w-full px-3 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            
                            <div class="mb-4">
                                <label class="block text-gray-700 text-sm font-bold mb-2" for="address">
                                    Address
                                </label>
                                <input type="text" name="address" value="<?php echo htmlspecialchars($school_info['address']); ?>" class="w-full px-3 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            
                            <div class="mb-4">
                                <label class="block text-gray-700 text-sm font-bold mb-2" for="phone">
                                    Phone
                                </label>
                                <input type="text" name="phone" value="<?php echo htmlspecialchars($school_info['phone']); ?>" class="w-full px-3 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            
                            <div class="mb-4">
                                <label class="block text-gray-700 text-sm font-bold mb-2" for="email">
                                    Email
                                </label>
                                <input type="email" name="email" value="<?php echo htmlspecialchars($school_info['email']); ?>" class="w-full px-3 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            
                            <div class="mb-4">
                                <label class="block text-gray-700 text-sm font-bold mb-2" for="motto">
                                    School Motto
                                </label>
                                <input type="text" name="motto" value="<?php echo htmlspecialchars($school_info['motto']); ?>" class="w-full px-3 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            
                            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4">
                                <i class="fas fa-upload mr-2"></i> Upload Logo
                            </button>
                        </form>
                    </div>
                    
                    <!-- Logo Preview -->
                    <div>
                        <h2 class="text-xl font-semibold mb-4">Logo Preview</h2>
                        <div class="logo-preview mb-4">
                            <?php if (!empty($school_info['logo']) && file_exists('../uploads/' . $school_info['logo'])): ?>
                                <img src="../uploads/<?php echo $school_info['logo']; ?>" alt="School Logo">
                            <?php else: ?>
                                <div class="text-gray-500 text-center">
                                    <i class="fas fa-image text-4xl mb-2"></i>
                                    <p>No logo uploaded</p>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="bg-gray-100 p-4">
                            <h3 class="font-semibold mb-2">Current School Information:</h3>
                            <p><strong>Name:</strong> <?php echo htmlspecialchars($school_info['school_name']); ?></p>
                            <p><strong>Motto:</strong> <?php echo htmlspecialchars($school_info['motto']); ?></p>
                            <p><strong>Address:</strong> <?php echo htmlspecialchars($school_info['address']); ?></p>
                            <p><strong>Phone:</strong> <?php echo htmlspecialchars($school_info['phone']); ?></p>
                            <p><strong>Email:</strong> <?php echo htmlspecialchars($school_info['email']); ?></p>
                        </div>
                    </div>
                </div>
                
                <hr class="my-6">
                
                <!-- Result Sheet Preview -->
                <div>
                    <h2 class="text-xl font-semibold mb-4">Result Sheet Preview</h2>
                    <div class="border p-4 bg-white">
                        <div style="text-align: center;">
                            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                <tr>
                                    <td width="20%" style="text-align: left; vertical-align: middle;">
                                        <?php if (!empty($school_info['logo']) && file_exists('../uploads/' . $school_info['logo'])): ?>
                                            <img src="../uploads/<?php echo $school_info['logo']; ?>" style="height: 60px;">
                                        <?php endif; ?>
                                    </td>
                                    <td width="60%" style="text-align: center; vertical-align: middle;">
                                        <h1 style="font-size: 18px; margin-bottom: 5px;"><?php echo htmlspecialchars($school_info['school_name']); ?></h1>
                                        <p style="font-size: 12px; margin: 0;"><?php echo htmlspecialchars($school_info['address']); ?></p>
                                        <p style="font-size: 12px; margin: 0;">Phone: <?php echo htmlspecialchars($school_info['phone']); ?> | Email: <?php echo htmlspecialchars($school_info['email']); ?></p>
                                        <p style="font-size: 12px; margin: 0; font-style: italic;"><?php echo htmlspecialchars($school_info['motto']); ?></p>
                                    </td>
                                    <td width="20%" style="text-align: right; vertical-align: middle;">
                                        <!-- Empty space for alignment -->
                                    </td>
                                </tr>
                            </table>
                            <hr style="margin: 10px 0;">
                        </div>
                        
                        <h2 style="text-align: center; font-size: 16px; margin: 10px 0;">STUDENT REPORT CARD</h2>
                        
                        <table border="0" cellpadding="5" width="100%">
                            <tr>
                                <td width="50%">
                                    <strong>Student Name:</strong> John Doe<br>
                                    <strong>Student ID:</strong> STU001<br>
                                    <strong>Roll Number:</strong> 15
                                </td>
                                <td width="50%">
                                    <strong>Class:</strong> 10 - A<br>
                                    <strong>Academic Year:</strong> 2023/2024<br>
                                    <strong>Term:</strong> First Term
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <strong>Exam:</strong> Mid-Term Examination<br>
                                    <strong>Exam Date:</strong> October 15, 2023
                                </td>
                                <td>
                                    <strong>Date Issued:</strong> November 5, 2023
                                </td>
                            </tr>
                        </table>
                        
                        <br>
                        
                        <h3 style="font-size: 14px; margin: 10px 0;">ACADEMIC PERFORMANCE</h3>
                        <table border="1" cellpadding="5" width="100%" style="border-collapse: collapse;">
                            <tr style="background-color: #f2f2f2;">
                                <th width="40%"><strong>Subject</strong></th>
                                <th width="15%"><strong>CA Score</strong></th>
                                <th width="15%"><strong>Exam Score</strong></th>
                                <th width="15%"><strong>Total</strong></th>
                                <th width="15%"><strong>Grade</strong></th>
                            </tr>
                            <tr>
                                <td>Mathematics</td>
                                <td>18</td>
                                <td>62</td>
                                <td>80</td>
                                <td>A</td>
                            </tr>
                            <tr>
                                <td>English</td>
                                <td>20</td>
                                <td>65</td>
                                <td>85</td>
                                <td>A</td>
                            </tr>
                            <tr>
                                <td>Science</td>
                                <td>17</td>
                                <td>58</td>
                                <td>75</td>
                                <td>B+</td>
                            </tr>
                            <tr style="background-color: #f2f2f2;">
                                <td colspan="3" align="right"><strong>Overall Total:</strong></td>
                                <td><strong>240/300</strong></td>
                                <td><strong>A</strong></td>
                            </tr>
                            <tr style="background-color: #f2f2f2;">
                                <td colspan="3" align="right"><strong>Overall Percentage:</strong></td>
                                <td colspan="2"><strong>80.00%</strong></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Preview image before upload
        document.getElementById('logo').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.querySelector('.logo-preview').innerHTML = 
                        `<img src="${e.target.result}" alt="Logo Preview">`;
                }
                reader.readAsDataURL(file);
            }
        });
    </script>
</body>
</html>

<?php
include 'include/footer.php';
// Close connection
mysqli_close($conn);
?>