<?php
include 'include/header.php';
include '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$admin_id = $_SESSION['user_id'];
$admin_name = $_SESSION['user_name'];

$success = '';
$error = '';

// Get a default subject ID to use (first active subject)
$default_subject_query = "SELECT id FROM subjects WHERE status='active' LIMIT 1";
$default_subject_result = mysqli_query($conn, $default_subject_query);
$default_subject = mysqli_fetch_assoc($default_subject_result);
$default_subject_id = $default_subject ? $default_subject['id'] : null;

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Add Exam
    if (isset($_POST['add_exam'])) {
        $exam_name = mysqli_real_escape_string($conn, $_POST['exam_name']);
        $date = mysqli_real_escape_string($conn, $_POST['date']);
        
        if (empty($exam_name) || empty($date)) {
            $error = "Required fields are missing";
        } else if (!$default_subject_id) {
            $error = "No active subjects available. Please add a subject first.";
        } else {
            // Check if exam with same name already exists
            $check_query = "SELECT * FROM exams WHERE exam_name='$exam_name' AND subject_id='$default_subject_id'";
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "Exam with this name already exists";
            } else {
                // Use default values for removed fields
                $start_time = '00:00:00';
                $end_time = '23:59:59';
                $total_marks = 100;
                
                $insert_query = "INSERT INTO exams (exam_name, subject_id, exam_date, start_time, end_time, total_marks, created_by) 
                                VALUES ('$exam_name', '$default_subject_id', '$date', '$start_time', '$end_time', '$total_marks', '$admin_id')";
                
                if (mysqli_query($conn, $insert_query)) {
                    $success = "Exam added successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        }
    }
    
    // Edit Exam
    if (isset($_POST['edit_exam'])) {
        $exam_id = mysqli_real_escape_string($conn, $_POST['exam_id']);
        $exam_name = mysqli_real_escape_string($conn, $_POST['exam_name']);
        $date = mysqli_real_escape_string($conn, $_POST['date']);
        
        if (empty($exam_name) || empty($date)) {
            $error = "Required fields are required";
        } else {
            // Check if another exam with same name exists
            $check_query = "SELECT * FROM exams WHERE exam_name='$exam_name' AND subject_id='$default_subject_id' AND id != '$exam_id'";
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "Exam with this name already exists";
            } else {
                $update_query = "UPDATE exams SET exam_name='$exam_name', exam_date='$date' WHERE id='$exam_id'";
                
                if (mysqli_query($conn, $update_query)) {
                    $success = "Exam updated successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        }
    }
}

// Handle delete actions
if (isset($_GET['action']) && isset($_GET['type']) && isset($_GET['id'])) {
    $action = $_GET['action'];
    $type = $_GET['type'];
    $id = $_GET['id'];
    
    if ($action == 'delete') {
        if ($type == 'exam') {
            // Check if exam has any results before deleting
            $check_results = "SELECT * FROM exam_results WHERE exam_id='$id'";
            $result_check = mysqli_query($conn, $check_results);
            
            if (mysqli_num_rows($result_check) > 0) {
                $error = "Cannot delete exam. It has results recorded.";
            } else {
                $delete_query = "DELETE FROM exams WHERE id='$id'";
                if (mysqli_query($conn, $delete_query)) {
                    $success = "Exam deleted successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        }
    }
}

// Get exams with subject names (for display only)
$exam_query = "SELECT e.*, s.subject_name 
               FROM exams e 
               JOIN subjects s ON e.subject_id = s.id 
               ORDER BY e.exam_date DESC, e.exam_name";
$exam_result = mysqli_query($conn, $exam_query);
?>

<div class="bg-white p-6  ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Exam Management</h2>
        <button onclick="openTab('exam-tab')" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2  flex items-center">
            <i class="fas fa-plus mr-2"></i> Add New Exam
        </button>
    </div>

    <?php if (!empty($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <i class="fas fa-check-circle mr-2"></i> <?php echo $success; ?>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <i class="fas fa-exclamation-circle mr-2"></i> <?php echo $error; ?>
        </div>
    <?php endif; ?>
    
    <div class="flex border-b border-gray-200 mb-6">
        <button id="exam-tab-btn" class="px-4 py-2 font-medium text-blue-600 border-b-2 border-blue-600 focus:outline-none">
            <i class="fas fa-book mr-2"></i> Manage Exams
        </button>
        <button id="view-tab-btn" class="px-4 py-2 font-medium text-gray-600 hover:text-blue-600 focus:outline-none">
            <i class="fas fa-list mr-2"></i> View Exams
        </button>
    </div>
    
    <!-- Exam Management Tab -->
    <div id="exam-tab" class="tab-content">
        <div class="bg-white p-6   mb-6">
            <h3 class="text-lg font-medium text-gray-800 mb-4"><i class="fas fa-plus-circle mr-2"></i> Add New Exam</h3>
            <form method="POST">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <label for="exam_name" class="block text-sm font-medium text-gray-700 mb-1">Exam Name <span class="text-red-500">*</span></label>
                        <input type="text" id="exam_name" name="exam_name" required 
                               placeholder="e.g., Midterm, Final, Quiz 1, etc."
                               class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <div>
                        <label for="date" class="block text-sm font-medium text-gray-700 mb-1">Exam Date <span class="text-red-500">*</span></label>
                        <input type="date" id="date" name="date" required 
                               class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                </div>
                
                <div class="text-center">
                    <button type="submit" name="add_exam" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 ">
                        <i class="fas fa-plus mr-2"></i> Add Exam
                    </button>
                </div>
            </form>
        </div>
        
        <div class="bg-white p-6  ">
            <h3 class="text-lg font-medium text-gray-800 mb-4"><i class="fas fa-list mr-2"></i> Existing Exams</h3>
            <?php if (mysqli_num_rows($exam_result) > 0): ?>
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white">
                        <thead class="bg-gray-200 text-gray-700">
                            <tr>
                                <th class="py-3 px-4 text-left">Exam Name</th>
                                <th class="py-3 px-4 text-left">Date</th>
                                <th class="py-3 px-4 text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600">
                            <?php while($exam = mysqli_fetch_assoc($exam_result)): ?>
                                <tr class="border-b border-gray-200 hover:bg-gray-50">
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($exam['exam_name']); ?></td>
                                    <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($exam['exam_date'])); ?></td>
                                    <td class="py-3 px-4">
                                        <div class="flex space-x-2">
                                            <button onclick="openEditExamModal(
                                                <?php echo $exam['id']; ?>, 
                                                '<?php echo htmlspecialchars($exam['exam_name']); ?>', 
                                                '<?php echo $exam['exam_date']; ?>'
                                            )" class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button onclick="confirmDelete('exam', <?php echo $exam['id']; ?>, '<?php echo htmlspecialchars($exam['exam_name']); ?>')" 
                                                    class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-8 text-gray-500">
                    <i class="fas fa-inbox text-4xl mb-3"></i>
                    <p class="mb-4">No exams found. Please add exams using the form above.</p>
                    <button class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 " onclick="document.getElementById('exam_name').focus()">
                        <i class="fas fa-plus mr-2"></i> Add Your First Exam
                    </button>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- View Exams Tab -->
    <div id="view-tab" class="tab-content hidden">
        <div class="bg-white p-6  ">
            <h3 class="text-lg font-medium text-gray-800 mb-4"><i class="fas fa-list-check mr-2"></i> All Exams</h3>
            <?php 
            // Re-fetch exams for this tab
            $exam_view_result = mysqli_query($conn, $exam_query);
            if (mysqli_num_rows($exam_view_result) > 0): ?>
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white">
                        <thead class="bg-gray-200 text-gray-700">
                            <tr>
                                <th class="py-3 px-4 text-left">Exam Name</th>
                                <th class="py-3 px-4 text-left">Date</th>
                                <th class="py-3 px-4 text-left">Status</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600">
                            <?php while($exam = mysqli_fetch_assoc($exam_view_result)): 
                                // Determine exam status
                                $current_date = date('Y-m-d');
                                $status = '';
                                
                                if ($exam['exam_date'] > $current_date) {
                                    $status = 'Upcoming';
                                    $status_class = 'bg-blue-100 text-blue-800';
                                } else if ($exam['exam_date'] == $current_date) {
                                    $status = 'Today';
                                    $status_class = 'bg-green-100 text-green-800';
                                } else {
                                    $status = 'Completed';
                                    $status_class = 'bg-gray-100 text-gray-800';
                                }
                            ?>
                                <tr class="border-b border-gray-200 hover:bg-gray-50">
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($exam['exam_name']); ?></td>
                                    <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($exam['exam_date'])); ?></td>
                                    <td class="py-3 px-4">
                                        <span class="text-xs font-medium px-2.5 py-0.5 rounded <?php echo $status_class; ?>">
                                            <?php echo $status; ?>
                                        </span>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-8 text-gray-500">
                    <i class="fas fa-calendar-times text-4xl mb-3"></i>
                    <p>No exams found. Please add exams using the "Manage Exams" tab.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Edit Exam Modal -->
<div id="editExamModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white   w-11/12 md:w-1/2 max-w-2xl">
        <div class="border-b px-6 py-4 flex justify-between items-center">
            <h3 class="text-lg font-medium text-gray-800">Edit Exam</h3>
            <button onclick="closeModal('editExamModal')" class="text-gray-500 hover:text-gray-700">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <form method="POST" id="editExamForm">
            <div class="p-6">
                <input type="hidden" name="exam_id" id="edit_exam_id">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <label for="edit_exam_name" class="block text-sm font-medium text-gray-700 mb-1">Exam Name <span class="text-red-500">*</span></label>
                        <input type="text" id="edit_exam_name" name="exam_name" required
                               class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <div>
                        <label for="edit_date" class="block text-sm font-medium text-gray-700 mb-1">Exam Date <span class="text-red-500">*</span></label>
                        <input type="date" id="edit_date" name="date" required 
                               class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                </div>
            </div>
            <div class="border-t px-6 py-4 flex justify-end space-x-3">
                <button type="button" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 " onclick="closeModal('editExamModal')">Cancel</button>
                <button type="submit" name="edit_exam" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 ">
                    <i class="fas fa-save mr-2"></i> Update Exam
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white   w-11/12 md:w-1/3 max-w-md">
        <div class="border-b px-6 py-4">
            <h3 class="text-lg font-medium text-gray-800">Confirm Delete</h3>
        </div>
        <div class="p-6">
            <p id="deleteMessage" class="text-gray-700">Are you sure you want to delete this exam?</p>
        </div>
        <div class="border-t px-6 py-4 flex justify-end space-x-3">
            <button type="button" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 " onclick="closeModal('deleteModal')">Cancel</button>
            <button type="button" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 " onclick="proceedDelete()">
                <i class="fas fa-trash mr-2"></i> Delete
            </button>
        </div>
    </div>
</div>

<script>
    // Tab navigation
    function openTab(tabId) {
        // Hide all tab contents
        const tabContents = document.querySelectorAll('.tab-content');
        tabContents.forEach(tab => tab.classList.add('hidden'));
        
        // Remove active class from all tabs
        const tabButtons = document.querySelectorAll('.flex.border-b button');
        tabButtons.forEach(btn => {
            btn.classList.remove('text-blue-600', 'border-blue-600');
            btn.classList.add('text-gray-600', 'hover:text-blue-600');
        });
        
        // Show the selected tab content and mark tab as active
        document.getElementById(tabId).classList.remove('hidden');
        
        // Update the button styles
        const activeBtn = document.getElementById(tabId + '-btn');
        if (activeBtn) {
            activeBtn.classList.remove('text-gray-600', 'hover:text-blue-600');
            activeBtn.classList.add('text-blue-600', 'border-blue-600');
        }
    }
    
    // Initialize tabs
    document.addEventListener('DOMContentLoaded', function() {
        // Set the first tab as active
        openTab('exam-tab');
        
        // Add click events to tab buttons
        document.getElementById('exam-tab-btn').addEventListener('click', function() {
            openTab('exam-tab');
        });
        
        document.getElementById('view-tab-btn').addEventListener('click', function() {
            openTab('view-tab');
        });
        
        // Set today's date as default for the date field
        const today = new Date().toISOString().split('T')[0];
        document.getElementById('date').value = today;
    });
    
    // Form validation
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const requiredFields = form.querySelectorAll('[required]');
            let valid = true;
            
            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    valid = false;
                    field.classList.add('border-red-500');
                } else {
                    field.classList.remove('border-red-500');
                }
            });
            
            if (!valid) {
                e.preventDefault();
            }
        });
    });
    
    // Modal functions
    function openEditExamModal(id, name, date) {
        document.getElementById('edit_exam_id').value = id;
        document.getElementById('edit_exam_name').value = name;
        document.getElementById('edit_date').value = date;
        
        document.getElementById('editExamModal').classList.remove('hidden');
    }
    
    function closeModal(modalId) {
        document.getElementById(modalId).classList.add('hidden');
    }
    
    // Delete confirmation
    let deleteType = '';
    let deleteId = 0;
    
    function confirmDelete(type, id, name) {
        deleteType = type;
        deleteId = id;
        
        const message = `Are you sure you want to delete the exam "${name}"? This action cannot be undone.`;
        document.getElementById('deleteMessage').textContent = message;
        document.getElementById('deleteModal').classList.remove('hidden');
    }
    
    function proceedDelete() {
        window.location.href = `?action=delete&type=${deleteType}&id=${deleteId}`;
    }
    
    // Close modals when clicking outside
    document.addEventListener('click', function(event) {
        const modals = document.querySelectorAll('[id$="Modal"]');
        modals.forEach(modal => {
            if (event.target === modal) {
                modal.classList.add('hidden');
            }
        });
    });
</script>

<?php
include 'include/footer.php';
// Close database connection
mysqli_close($conn);
?>