<?php
session_start();
include '../config/conn.php';

// Check if token is provided
if (!isset($_GET['token'])) {
    die("Invalid access. No token provided.");
}

$token = mysqli_real_escape_string($conn, $_GET['token']);
$success = '';
$error = '';

// Verify token is valid and not expired
$token_query = "SELECT * FROM qr_attendance_tokens 
                WHERE token = '$token' AND expiry_time > NOW() AND used = 0";
$token_result = mysqli_query($conn, $token_query);

if (mysqli_num_rows($token_result) === 0) {
    $error = "Invalid or expired QR code";
} else {
    $token_data = mysqli_fetch_assoc($token_result);
    $attendance_date = $token_data['attendance_date'];
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_attendance'])) {
    $teacher_id = mysqli_real_escape_string($conn, $_POST['teacher_id']);
    
    // Check if teacher exists and is active
    $teacher_query = "SELECT id, teacher_id, full_name, email 
                      FROM users 
                      WHERE teacher_id = '$teacher_id' AND role='teacher' AND status='active' 
                      LIMIT 1";
    $teacher_result = mysqli_query($conn, $teacher_query);
    
    if (mysqli_num_rows($teacher_result) === 0) {
        $error = "No active teacher found with this ID";
    } else {
        $teacher = mysqli_fetch_assoc($teacher_result);
        
        // Check if attendance already recorded
        $check_query = "SELECT id FROM teacher_attendance 
                        WHERE teacher_id = {$teacher['id']} AND attendance_date = '$attendance_date'";
        $check_result = mysqli_query($conn, $check_query);
        
        if (mysqli_num_rows($check_result) > 0) {
            $error = "Attendance already recorded for today";
        } else {
            // Record attendance
            $insert_query = "INSERT INTO teacher_attendance (teacher_id, attendance_date, status, recorded_by, recorded_at)
                             VALUES ({$teacher['id']}, '$attendance_date', 'present', 1, NOW())";
            
            if (mysqli_query($conn, $insert_query)) {
                // Mark token as used
                mysqli_query($conn, "UPDATE qr_attendance_tokens SET used = 1 WHERE token = '$token'");
                $success = "Attendance recorded successfully for " . $teacher['full_name'];
            } else {
                $error = "Error saving attendance";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mobile Attendance</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
            background-color: #f3f4f6;
        }
        .container {
            max-width: 100%;
            padding: 1rem;
        }
        .card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            padding: 1.5rem;
            margin-bottom: 1rem;
        }
        .btn {
            display: block;
            width: 100%;
            padding: 0.75rem;
            border-radius: 8px;
            font-weight: 600;
            text-align: center;
            border: none;
            cursor: pointer;
        }
        .btn-primary {
            background-color: #3b82f6;
            color: white;
        }
        .btn-primary:hover {
            background-color: #2563eb;
        }
        .input-field {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #d1d5db;
            border-radius: 8px;
            font-size: 16px; /* Prevents zoom on iOS */
        }
        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
        }
        .alert-success {
            background-color: #d1fae5;
            color: #065f46;
        }
        .alert-error {
            background-color: #fee2e2;
            color: #b91c1c;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto py-8">
        <div class="max-w-md mx-auto">
            <div class="text-center mb-6">
                <h1 class="text-2xl font-bold text-gray-800">Teacher Attendance</h1>
                <p class="text-gray-600">Enter your Teacher ID to record attendance</p>
                <p class="text-sm text-gray-500 mt-1">Date: <?php echo isset($attendance_date) ? date('M j, Y', strtotime($attendance_date)) : 'N/A'; ?></p>
            </div>

            <?php if (!empty($success)): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle mr-2"></i> <?php echo $success; ?>
                </div>
            <?php endif; ?>
            
            <?php if (!empty($error)): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle mr-2"></i> <?php echo $error; ?>
                </div>
            <?php endif; ?>

            <?php if (isset($token_data) && mysqli_num_rows($token_result) > 0): ?>
                <div class="card">
                    <form method="POST" action="">
                        <div class="mb-4">
                            <label for="teacher_id" class="block text-sm font-medium text-gray-700 mb-1">Teacher ID</label>
                            <input type="text" id="teacher_id" name="teacher_id" 
                                class="input-field" placeholder="Enter your teacher ID" 
                                required autocomplete="off" autofocus>
                        </div>
                        
                        <button type="submit" name="submit_attendance" class="btn btn-primary">
                            <i class="fas fa-check-circle mr-2"></i> Submit Attendance
                        </button>
                    </form>
                </div>
                
                <div class="text-center text-sm text-gray-500 mt-4">
                    <p>This attendance session will expire at <?php echo date('h:i A', strtotime($token_data['expiry_time'])); ?></p>
                </div>
            <?php else: ?>
                <div class="card text-center">
                    <i class="fas fa-exclamation-triangle text-yellow-500 text-4xl mb-3"></i>
                    <h2 class="text-xl font-semibold text-gray-800">Invalid QR Code</h2>
                    <p class="text-gray-600 mt-2">This QR code is invalid or has expired.</p>
                    <p class="text-sm text-gray-500 mt-4">Please contact your administrator for a new QR code.</p>
                </div>
            <?php endif; ?>
            
            <div class="text-center mt-8">
                <p class="text-sm text-gray-500">School Attendance System © <?php echo date('Y'); ?></p>
            </div>
        </div>
    </div>

    <script>
        // Focus on input field when page loads
        document.addEventListener('DOMContentLoaded', function() {
            const teacherIdInput = document.getElementById('teacher_id');
            if (teacherIdInput) {
                teacherIdInput.focus();
            }
        });
        
        // Prevent form resubmission on page refresh
        if (window.history.replaceState) {
            window.history.replaceState(null, null, window.location.href);
        }
    </script>
</body>
</html>
<?php
mysqli_close($conn);
?>