<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Handle delete operation
if (isset($_GET['delete_id'])) {
    $delete_id = mysqli_real_escape_string($conn, $_GET['delete_id']);
    
    // Get parent data to delete the picture file
    $query = "SELECT picture FROM parents WHERE id = $delete_id";
    $result = mysqli_query($conn, $query);
    $parent = mysqli_fetch_assoc($result);
    
    if ($parent['picture'] && file_exists($parent['picture'])) {
        unlink($parent['picture']);
    }
    
    // Delete parent record
    $query = "DELETE FROM parents WHERE id = $delete_id";
    if (mysqli_query($conn, $query)) {
        $_SESSION['message'] = "Parent deleted successfully";
        $_SESSION['message_type'] = "success";
    } else {
        $_SESSION['message'] = "Error deleting parent: " . mysqli_error($conn);
        $_SESSION['message_type'] = "error";
    }
    
    header('Location: parents.php');
    exit();
}

// Handle Excel export
if (isset($_GET['export_excel'])) {
    // Fetch all parents from database
    $query = "SELECT * FROM parents ORDER BY created_at DESC";
    $result = mysqli_query($conn, $query);
    
    // Set headers for Excel file download
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="parents_export_' . date('Y-m-d') . '.xls"');
    
    // Start Excel content
    echo "ID\tFull Name\tUsername\tEmail\tGender\tDate of Birth\tContact\tAddress\tCreated At\n";
    
    if (mysqli_num_rows($result) > 0) {
        while ($parent = mysqli_fetch_assoc($result)) {
            echo $parent['id'] . "\t";
            echo $parent['fullname'] . "\t";
            echo $parent['username'] . "\t";
            echo $parent['email'] . "\t";
            echo $parent['gender'] . "\t";
            echo $parent['birth'] . "\t";
            echo $parent['contact'] . "\t";
            echo str_replace(["\r", "\n", "\t"], " ", $parent['address']) . "\t";
            echo $parent['created_at'] . "\n";
        }
    }
    exit();
}

// Initialize search and pagination variables
$search = isset($_GET['search']) ? mysqli_real_escape_string($conn, $_GET['search']) : '';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 10; // Number of records per page

// Build the base query
$base_query = "FROM parents WHERE 1=1";
if (!empty($search)) {
    $base_query .= " AND (fullname LIKE '%$search%' OR username LIKE '%$search%' OR email LIKE '%$search%' OR contact LIKE '%$search%')";
}

// Get total number of records for pagination
$count_query = "SELECT COUNT(*) as total $base_query";
$count_result = mysqli_query($conn, $count_query);
$total_records = mysqli_fetch_assoc($count_result)['total'];
$total_pages = ceil($total_records / $per_page);

// Ensure page is within valid range
if ($page < 1) $page = 1;
if ($page > $total_pages && $total_pages > 0) $page = $total_pages;

// Calculate offset - ensure it's not negative
$offset = max(0, ($page - 1) * $per_page);

// Build the main query with pagination
$query = "SELECT * $base_query ORDER BY created_at DESC LIMIT $offset, $per_page";
$result = mysqli_query($conn, $query);
ob_end_flush();
?>

<div class="bg-white p-6  ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Parents List</h2>
        <a href="add_parent.php" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2  flex items-center">
            <i class="fas fa-plus mr-2"></i> Add New Parent
        </a>
    </div>

    <?php if (isset($_SESSION['message'])): ?>
        <div class="<?php echo $_SESSION['message_type'] == 'success' ? 'bg-green-100 border-green-400 text-green-700' : 'bg-red-100 border-red-400 text-red-700'; ?> border px-4 py-3 rounded mb-4">
            <?php 
            echo $_SESSION['message']; 
            unset($_SESSION['message']);
            unset($_SESSION['message_type']);
            ?>
        </div>
    <?php endif; ?>

    <!-- Search and Export Section -->
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
        <!-- Search Form -->
        <form method="GET" action="" class="w-full md:w-1/2">
            <div class="relative">
                <input type="text" name="search" value="<?php echo htmlspecialchars($search); ?>" 
                    placeholder="Search by name, username, email or contact..." 
                    class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500 pr-10">
                <button type="submit" class="absolute right-2 top-2 text-gray-500 hover:text-blue-600">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </form>
        
        <!-- Export Button -->
        <a href="?export_excel=1<?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>" 
           class="bg-green-600 hover:bg-green-700 text-white px-4 py-2  flex items-center">
            <i class="fas fa-file-excel mr-2"></i> Export to Excel
        </a>
    </div>

    <!-- Results Count -->
    <div class="mb-4 text-sm text-gray-600">
        <?php if (!empty($search)): ?>
            Found <?php echo $total_records; ?> result(s) for "<?php echo htmlspecialchars($search); ?>"
            <a href="parents.php" class="text-blue-600 hover:underline ml-4">Clear search</a>
        <?php else: ?>
            Total <?php echo $total_records; ?> parent(s)
        <?php endif; ?>
    </div>

    <div class="overflow-x-auto">
        <table class="min-w-full bg-white">
            <thead class="bg-gray-200 text-gray-700">
                <tr>
                    <th class="py-3 px-4 text-left">Photo</th>
                    <th class="py-3 px-4 text-left">Full Name</th>
                    <th class="py-3 px-4 text-left">Username</th>
                    <th class="py-3 px-4 text-left">Email</th>
                    <th class="py-3 px-4 text-left">Gender</th>
                    <th class="py-3 px-4 text-left">Date of Birth</th>
                    <th class="py-3 px-4 text-left">Contact</th>
                    <th class="py-3 px-4 text-left">Actions</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <?php if (mysqli_num_rows($result) > 0): ?>
                    <?php while ($parent = mysqli_fetch_assoc($result)): ?>
                        <tr class="border-b border-gray-200 hover:bg-gray-50">
                            <td class="py-3 px-4">
                                <?php if ($parent['picture']): ?>
                                    <img src="<?php echo $parent['picture']; ?>" alt="Parent Photo" class="w-12 h-12 rounded-full object-cover">
                                <?php else: ?>
                                    <div class="w-12 h-12 rounded-full bg-gray-300 flex items-center justify-center">
                                        <i class="fas fa-user text-gray-500"></i>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td class="py-3 px-4"><?php echo $parent['fullname']; ?></td>
                            <td class="py-3 px-4"><?php echo $parent['username']; ?></td>
                            <td class="py-3 px-4"><?php echo $parent['email']; ?></td>
                            <td class="py-3 px-4"><?php echo $parent['gender']; ?></td>
                            <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($parent['birth'])); ?></td>
                            <td class="py-3 px-4"><?php echo $parent['contact']; ?></td>
                            <td class="py-3 px-4">
                                <div class="flex space-x-2">
                                    <a href="add_parent.php?edit_id=<?php echo $parent['id']; ?>" class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="parents.php?delete_id=<?php echo $parent['id']; ?>" class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded" title="Delete" onclick="return confirm('Are you sure you want to delete this parent?');">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" class="py-4 px-4 text-center">
                            <?php if (!empty($search)): ?>
                                No parents found matching "<?php echo htmlspecialchars($search); ?>". 
                                <a href="parents.php" class="text-blue-600 hover:underline">View all parents</a>
                            <?php else: ?>
                                No parents found. <a href="add_parent.php" class="text-blue-600 hover:underline">Add a new parent</a>.
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <?php if ($total_pages > 1): ?>
    <div class="flex justify-center mt-6">
        <nav class="inline-flex  ">
            <!-- Previous Page Link -->
            <?php if ($page > 1): ?>
                <a href="?page=<?php echo $page - 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>" class="py-2 px-4 border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50 rounded-l-md">
                    <i class="fas fa-chevron-left"></i>
                </a>
            <?php else: ?>
                <span class="py-2 px-4 border border-gray-300 bg-gray-100 text-sm font-medium text-gray-400 rounded-l-md">
                    <i class="fas fa-chevron-left"></i>
                </span>
            <?php endif; ?>

            <!-- Page Numbers -->
            <?php 
            // Calculate start and end of pagination links
            $start = max(1, $page - 2);
            $end = min($total_pages, $start + 4);
            $start = max(1, $end - 4);
            
            for ($i = $start; $i <= $end; $i++): 
            ?>
                <?php if ($i == $page): ?>
                    <span class="py-2 px-4 border border-gray-300 bg-blue-600 text-white text-sm font-medium">
                        <?php echo $i; ?>
                    </span>
                <?php else: ?>
                    <a href="?page=<?php echo $i; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>" class="py-2 px-4 border border-gray-300 bg-white text-sm font-medium text-gray-700 hover:bg-gray-50">
                        <?php echo $i; ?>
                    </a>
                <?php endif; ?>
            <?php endfor; ?>

            <!-- Next Page Link -->
            <?php if ($page < $total_pages): ?>
                <a href="?page=<?php echo $page + 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>" class="py-2 px-4 border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50 rounded-r-md">
                    <i class="fas fa-chevron-right"></i>
                </a>
            <?php else: ?>
                <span class="py-2 px-4 border border-gray-300 bg-gray-100 text-sm font-medium text-gray-400 rounded-r-md">
                    <i class="fas fa-chevron-right"></i>
                </span>
            <?php endif; ?>
        </nav>
    </div>
    <?php endif; ?>
</div>

<?php
include 'include/footer.php';
mysqli_close($conn);
?>