<?php
session_start();
include '../config/conn.php';

// Check if user is logged in (optional for callbacks, as Paystack calls this directly)
// if (!isset($_SESSION['user_id'])) {
//     die("Unauthorized access");
// }

// Get Paystack reference
$reference = isset($_GET['reference']) ? mysqli_real_escape_string($conn, $_GET['reference']) : '';
if (empty($reference)) {
    die("No reference provided");
}

// Paystack secret key - Use LIVE key for production!
$paystack_secret = "sk_test_e961ecf6ab503d4b5d63853a2dfc0c9ec6ac78e6"; // Replace with live key

// Verify transaction with Paystack
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://api.paystack.co/transaction/verify/" . $reference);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Bearer $paystack_secret",
    "Cache-Control: no-cache",
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Add this for better SSL handling

$response = curl_exec($ch);
$err = curl_error($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Log the response for debugging
error_log("Paystack Callback - Reference: $reference, HTTP Code: $http_code, Error: $err");

if ($err) {
    die("cURL Error: " . $err);
}

$res = json_decode($response, true);

if (!$res['status']) {
    error_log("Paystack API Error: " . $response);
    header("Location: payment_failed.php?reference=$reference&error=api");
    exit();
}

if ($res['data']['status'] == 'success') {
    $ref = $res['data']['reference'];
    $amount_paid = $res['data']['amount'] / 100;
    $payment_date = date('Y-m-d H:i:s', strtotime($res['data']['paid_at']));

    // Check if payment already exists to avoid duplicates
    $existing_payment = mysqli_query($conn, "SELECT id FROM payments WHERE transaction_id = '$ref'");
    if (mysqli_num_rows($existing_payment) > 0) {
        // Payment already processed
        $invoice = mysqli_fetch_assoc(mysqli_query($conn, "SELECT id FROM invoices WHERE reference='$ref'"));
        header("Location: payment_success.php?invoice_id=" . $invoice['id']);
        exit();
    }

    // Get invoice details
    $invoice_query = "SELECT id, student_id, amount FROM invoices WHERE reference='$ref'";
    $invoice_result = mysqli_query($conn, $invoice_query);
    
    if (mysqli_num_rows($invoice_result) == 0) {
        error_log("Invoice not found for reference: $ref");
        die("Invoice not found for reference: $ref");
    }

    $invoice = mysqli_fetch_assoc($invoice_result);
    $invoice_id = $invoice['id'];
    $student_id = $invoice['student_id'];

    // Record payment
    $insert_payment = "INSERT INTO payments (invoice_id, student_id, amount, payment_method, transaction_id, payment_date) 
                       VALUES ($invoice_id, $student_id, $amount_paid, 'paystack', '$ref', '$payment_date')";

    if (mysqli_query($conn, $insert_payment)) {
        // Update invoice status
        $update_invoice = "UPDATE invoices SET status='paid' WHERE id=$invoice_id";
        mysqli_query($conn, $update_invoice);

        // Redirect to success page
        header("Location: https://adinoheightschool.com/admin/payment_success.php?invoice_id=$invoice_id");
        exit();
    } else {
        error_log("Payment recording error: " . mysqli_error($conn));
        die("Error recording payment: " . mysqli_error($conn));
    }
} else {
    header("Location: https://adinoheightschool.com/admin/payment_failed.php?reference=$reference");
    exit();
}
?>