<?php
// payment_failed.php (Minimal Version)
session_start();
ob_start();

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

include 'include/header.php';

$reference = isset($_GET['reference']) ? htmlspecialchars($_GET['reference']) : 'N/A';
$error_type = isset($_GET['error']) ? htmlspecialchars($_GET['error']) : 'unknown';
$message = isset($_GET['message']) ? htmlspecialchars($_GET['message']) : 'Payment processing failed';
?>

<div class="bg-white p-6 rounded-lg shadow-md max-w-md mx-auto mt-8">
    <div class="text-center">
        <!-- Failure Icon -->
        <div class="mx-auto w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mb-4">
            <i class="fas fa-times text-red-600 text-2xl"></i>
        </div>
        
        <h2 class="text-2xl font-bold text-red-600 mb-2">Payment Failed</h2>
        <p class="text-gray-600 mb-4">We're sorry, but we couldn't process your payment.</p>
        
        <!-- Error Details -->
        <div class="bg-gray-50 p-3 rounded-md mb-4 text-left">
            <p class="text-sm"><strong>Reference:</strong> <?php echo $reference; ?></p>
            <p class="text-sm"><strong>Error:</strong> <?php echo $message; ?></p>
        </div>
        
        <!-- Action Buttons -->
        <div class="space-y-2">
            <button onclick="window.history.back()" 
                    class="w-full bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded-md flex items-center justify-center">
                <i class="fas fa-redo mr-2"></i> Try Again
            </button>
            
            <a href="view_invoices.php" 
               class="w-full bg-gray-600 hover:bg-gray-700 text-white py-2 px-4 rounded-md flex items-center justify-center">
                <i class="fas fa-list mr-2"></i> Back to Invoices
            </a>
            
            <a href="dashboard.php" 
               class="w-full bg-green-600 hover:bg-green-700 text-white py-2 px-4 rounded-md flex items-center justify-center">
                <i class="fas fa-tachometer-alt mr-2"></i> Dashboard
            </a>
        </div>
        
        <!-- Support Info -->
        <div class="mt-4 pt-4 border-t border-gray-200">
            <p class="text-xs text-gray-500">
                Need help? Contact: support@adinoheightschool.com
            </p>
        </div>
    </div>
</div>

<script>
// Auto-redirect after 20 seconds
setTimeout(function() {
    window.location.href = 'view_invoices.php';
}, 20000);
</script>

<?php
include 'include/footer.php';
ob_end_flush();
?>