<?php
include 'include/header.php';

// Enable output buffering
ob_start();

// Include database connection
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Get user data from database
$user_id = $_SESSION['user_id'];
$query = "SELECT `id`, `name`, `email`, `password`, `role`, `school`, `image`, `created_at`, `password_updated_at` FROM users WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

// Close database connection
$conn->close();
?>

<div class="min-h-screen bg-gray-50">
    <div class="container mx-auto px-4 py-8">
        <div class="  p-6">
            <!-- Header with title and edit button -->
            <div class="flex justify-between items-center mb-6">
                <h1 class="text-2xl font-bold text-gray-800">User Profile</h1>
                <a href="edit_profile.php" class="bg-primary hover:bg-secondary text-white font-medium py-2 px-4 rounded-lg transition duration-200 flex items-center">
                    <i class="fas fa-edit mr-2"></i> Edit Profile
                </a>
            </div>

            <!-- Profile Image -->
            <div class="flex flex-col items-center mb-8">
                <div class="relative mb-4">
                    <img src="<?php echo !empty($user['image']) ? htmlspecialchars($user['image']) : 'https://ui-avatars.com/api/?name=' . urlencode($user['name']) . '&size=120&background=0096FF&color=fff'; ?>" 
                         alt="Profile Image" class="w-32 h-32 rounded-full object-cover border-4 border-white shadow-lg">
                    <span class="absolute bottom-0 right-0 bg-primary text-white p-2 rounded-full">
                        <i class="fas fa-camera"></i>
                    </span>
                </div>
                <p class="text-sm text-gray-500">Click on camera icon to change profile picture</p>
            </div>

            <!-- Personal Information -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Full Name</label>
                    <div class="w-full px-4 py-3 bg-gray-50 rounded-lg border border-gray-200">
                        <?php echo htmlspecialchars($user['name']); ?>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Email Address</label>
                    <div class="w-full px-4 py-3 bg-gray-50 rounded-lg border border-gray-200">
                        <?php echo htmlspecialchars($user['email']); ?>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">School</label>
                    <div class="w-full px-4 py-3 bg-gray-50 rounded-lg border border-gray-200">
                        <?php echo !empty($user['school']) ? htmlspecialchars($user['school']) : 'Not specified'; ?>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Role</label>
                    <div class="w-full px-4 py-3 bg-gray-50 rounded-lg border border-gray-200">
                        <?php echo htmlspecialchars(ucfirst($user['role'])); ?>
                    </div>
                </div>
            </div>

            <!-- Account Information -->
            <div class="border-t border-gray-200 pt-6">
                <h2 class="text-lg font-medium text-gray-800 mb-4">Account Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Member Since</label>
                        <div class="w-full px-4 py-3 bg-gray-50 rounded-lg border border-gray-200">
                            <?php echo date('F j, Y', strtotime($user['created_at'])); ?>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Last Password Change</label>
                        <div class="w-full px-4 py-3 bg-gray-50 rounded-lg border border-gray-200">
                            <?php echo !empty($user['password_updated_at']) ? date('F j, Y', strtotime($user['password_updated_at'])) : 'Never changed'; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
include 'include/footer.php';
ob_end_flush();
?>