<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Initialize variables
$class_id = isset($_GET['class_id']) ? intval($_GET['class_id']) : 0;
$section_id = isset($_GET['section_id']) ? intval($_GET['section_id']) : 0;
$subject_id = isset($_GET['subject_id']) ? intval($_GET['subject_id']) : 0;
$quiz_id = isset($_GET['quiz_id']) ? intval($_GET['quiz_id']) : 0;
$question_id = isset($_GET['question_id']) ? intval($_GET['question_id']) : 0;
$action = isset($_GET['action']) ? $_GET['action'] : 'list';
$success = '';
$error = '';

// Fetch all classes
$classes_query = "SELECT id, class_name FROM classes WHERE status = 'active' ORDER BY class_name";
$classes_result = mysqli_query($conn, $classes_query);

// Fetch all subjects
$subjects_query = "SELECT id, subject_name FROM subjects WHERE status = 'active' ORDER BY subject_name";
$subjects_result = mysqli_query($conn, $subjects_query);

// Fetch sections based on selected class
$sections = [];
if ($class_id > 0) {
    $sections_query = "SELECT id, section_name FROM sections WHERE class_id = $class_id AND status = 'active' ORDER BY section_name";
    $sections_result = mysqli_query($conn, $sections_query);
    while ($section = mysqli_fetch_assoc($sections_result)) {
        $sections[] = $section;
    }
}

// Handle quiz creation/editing
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['create_quiz'])) {
        $quiz_title = mysqli_real_escape_string($conn, $_POST['quiz_title']);
        $subject_id = intval($_POST['subject_id']);
        $class_id = intval($_POST['class_id']);
        $section_id = isset($_POST['section_id']) && !empty($_POST['section_id']) ? intval($_POST['section_id']) : NULL;
        $time_limit = intval($_POST['time_limit']);
        $instructions = mysqli_real_escape_string($conn, $_POST['instructions']);
        $status = $_POST['status'];
        $start_date = !empty($_POST['start_date']) ? $_POST['start_date'] : null;
        $end_date = !empty($_POST['end_date']) ? $_POST['end_date'] : null;
        
        if (empty($quiz_title) || empty($subject_id) || empty($class_id)) {
            $error = "Please fill in all required fields.";
        } else {
            // Validate that the user exists
            $user_check = "SELECT id FROM users WHERE id = {$_SESSION['user_id']}";
            $user_result = mysqli_query($conn, $user_check);
            
            if (mysqli_num_rows($user_result) === 0) {
                $error = "Invalid user. Please log in again.";
            } else {
                $insert_query = "INSERT INTO quizzes (quiz_title, subject_id, class_id, section_id, time_limit, instructions, status, start_date, end_date, created_by, created_at) 
                                 VALUES ('$quiz_title', $subject_id, $class_id, " . 
                                 ($section_id ? "$section_id" : "NULL") . ", $time_limit, '$instructions', '$status', " . 
                                 ($start_date ? "'$start_date'" : "NULL") . ", " . 
                                 ($end_date ? "'$end_date'" : "NULL") . ", 
                                 {$_SESSION['user_id']}, NOW())";
                
                if (mysqli_query($conn, $insert_query)) {
                    $quiz_id = mysqli_insert_id($conn);
                    $success = "Quiz created successfully!";
                    $action = 'add_questions';
                } else {
                    $error = "Error creating quiz: " . mysqli_error($conn);
                }
            }
        }
    } 
    elseif (isset($_POST['update_quiz'])) {
        $quiz_id = intval($_POST['quiz_id']);
        $quiz_title = mysqli_real_escape_string($conn, $_POST['quiz_title']);
        $subject_id = intval($_POST['subject_id']);
        $class_id = intval($_POST['class_id']);
        $section_id = isset($_POST['section_id']) && !empty($_POST['section_id']) ? intval($_POST['section_id']) : NULL;
        $time_limit = intval($_POST['time_limit']);
        $instructions = mysqli_real_escape_string($conn, $_POST['instructions']);
        $status = $_POST['status'];
        $start_date = !empty($_POST['start_date']) ? $_POST['start_date'] : null;
        $end_date = !empty($_POST['end_date']) ? $_POST['end_date'] : null;
        
        if (empty($quiz_title) || empty($subject_id) || empty($class_id)) {
            $error = "Please fill in all required fields.";
        } else {
            $update_query = "UPDATE quizzes SET 
                            quiz_title = '$quiz_title', 
                            subject_id = $subject_id, 
                            class_id = $class_id, 
                            section_id = " . ($section_id ? "$section_id" : "NULL") . ", 
                            time_limit = $time_limit, 
                            instructions = '$instructions', 
                            status = '$status',
                            start_date = " . ($start_date ? "'$start_date'" : "NULL") . ",
                            end_date = " . ($end_date ? "'$end_date'" : "NULL") . "
                            WHERE id = $quiz_id";
            
            if (mysqli_query($conn, $update_query)) {
                $success = "Quiz updated successfully!";
                $action = 'list';
            } else {
                $error = "Error updating quiz: " . mysqli_error($conn);
            }
        }
    }
    elseif (isset($_POST['add_question'])) {
        $quiz_id = intval($_POST['quiz_id']);
        $question_text = mysqli_real_escape_string($conn, $_POST['question_text']);
        $question_type = $_POST['question_type'];
        $marks = floatval($_POST['marks']);
        
        if (empty($question_text) || empty($quiz_id)) {
            $error = "Please enter question text.";
        } else {
            // Insert question
            $insert_question = "INSERT INTO quiz_questions (quiz_id, question_text, question_type, marks, created_at) 
                                VALUES ($quiz_id, '$question_text', '$question_type', $marks, NOW())";
            
            if (mysqli_query($conn, $insert_question)) {
                $question_id = mysqli_insert_id($conn);
                
                // Handle options based on question type
                if ($question_type === 'multiple_choice') {
                    $options = $_POST['options'];
                    $correct_answer = intval($_POST['correct_answer']);
                    
                    foreach ($options as $index => $option_text) {
                        if (!empty(trim($option_text))) {
                            $is_correct = ($index == $correct_answer) ? 1 : 0;
                            $option_text = mysqli_real_escape_string($conn, $option_text);
                            
                            $insert_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                                              VALUES ($question_id, '$option_text', $is_correct)";
                            mysqli_query($conn, $insert_option);
                        }
                    }
                } else if ($question_type === 'true_false') {
                    $correct_answer = $_POST['true_false_answer'];
                    
                    // Add both True and False options, mark the correct one
                    $true_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                                    VALUES ($question_id, 'True', " . ($correct_answer === 'true' ? 1 : 0) . ")";
                    mysqli_query($conn, $true_option);
                    
                    $false_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                                     VALUES ($question_id, 'False', " . ($correct_answer === 'false' ? 1 : 0) . ")";
                    mysqli_query($conn, $false_option);
                } else if ($question_type === 'short_answer') {
                    $expected_answer = mysqli_real_escape_string($conn, $_POST['short_answer']);
                    if (!empty($expected_answer)) {
                        $insert_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                                          VALUES ($question_id, '$expected_answer', 1)";
                        mysqli_query($conn, $insert_option);
                    }
                } else if ($question_type === 'essay') {
                    $guidelines = mysqli_real_escape_string($conn, $_POST['essay_guidelines']);
                    if (!empty($guidelines)) {
                        $insert_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                                          VALUES ($question_id, '$guidelines', 1)";
                        mysqli_query($conn, $insert_option);
                    }
                }
                
                $success = "Question added successfully!";
            } else {
                $error = "Error adding question: " . mysqli_error($conn);
            }
        }
    }
    elseif (isset($_POST['update_question'])) {
        $question_id = intval($_POST['question_id']);
        $question_text = mysqli_real_escape_string($conn, $_POST['question_text']);
        $question_type = $_POST['question_type'];
        $marks = floatval($_POST['marks']);
        
        if (empty($question_text) || empty($question_id)) {
            $error = "Please enter question text.";
        } else {
            // Update question
            $update_question = "UPDATE quiz_questions SET 
                                question_text = '$question_text', 
                                question_type = '$question_type', 
                                marks = $marks 
                                WHERE id = $question_id";
            
            if (mysqli_query($conn, $update_question)) {
                // Delete existing options
                $delete_options = "DELETE FROM quiz_question_options WHERE question_id = $question_id";
                mysqli_query($conn, $delete_options);
                
                // Handle options based on question type
                if ($question_type === 'multiple_choice') {
                    $options = $_POST['options'];
                    $correct_answer = intval($_POST['correct_answer']);
                    
                    foreach ($options as $index => $option_text) {
                        if (!empty(trim($option_text))) {
                            $is_correct = ($index == $correct_answer) ? 1 : 0;
                            $option_text = mysqli_real_escape_string($conn, $option_text);
                            
                            $insert_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                                              VALUES ($question_id, '$option_text', $is_correct)";
                            mysqli_query($conn, $insert_option);
                        }
                    }
                } else if ($question_type === 'true_false') {
                    $correct_answer = $_POST['true_false_answer'];
                    
                    // Add both True and False options, mark the correct one
                    $true_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                                    VALUES ($question_id, 'True', " . ($correct_answer === 'true' ? 1 : 0) . ")";
                    mysqli_query($conn, $true_option);
                    
                    $false_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                                     VALUES ($question_id, 'False', " . ($correct_answer === 'false' ? 1 : 0) . ")";
                    mysqli_query($conn, $false_option);
                } else if ($question_type === 'short_answer') {
                    $expected_answer = mysqli_real_escape_string($conn, $_POST['short_answer']);
                    if (!empty($expected_answer)) {
                        $insert_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                                          VALUES ($question_id, '$expected_answer', 1)";
                        mysqli_query($conn, $insert_option);
                    }
                } else if ($question_type === 'essay') {
                    $guidelines = mysqli_real_escape_string($conn, $_POST['essay_guidelines']);
                    if (!empty($guidelines)) {
                        $insert_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                                          VALUES ($question_id, '$guidelines', 1)";
                        mysqli_query($conn, $insert_option);
                    }
                }
                
                $success = "Question updated successfully!";
                $action = 'add_questions';
            } else {
                $error = "Error updating question: " . mysqli_error($conn);
            }
        }
    }
}

// Handle delete action
if (isset($_GET['delete_quiz'])) {
    $delete_id = intval($_GET['delete_quiz']);
    
    // First delete related answers
    $delete_answers_query = "DELETE FROM quiz_answers WHERE option_id IN (
        SELECT id FROM quiz_question_options WHERE question_id IN (
            SELECT id FROM quiz_questions WHERE quiz_id = $delete_id
        )
    )";
    mysqli_query($conn, $delete_answers_query);
    
    // Then delete related options
    $delete_options_query = "DELETE FROM quiz_question_options WHERE question_id IN (
        SELECT id FROM quiz_questions WHERE quiz_id = $delete_id
    )";
    mysqli_query($conn, $delete_options_query);
    
    // Then delete related questions
    $delete_questions_query = "DELETE FROM quiz_questions WHERE quiz_id = $delete_id";
    mysqli_query($conn, $delete_questions_query);
    
    // Finally delete the quiz
    $delete_query = "DELETE FROM quizzes WHERE id = $delete_id";
    if (mysqli_query($conn, $delete_query)) {
        $success = "Quiz deleted successfully!";
    } else {
        $error = "Error deleting quiz: " . mysqli_error($conn);
    }
}

// Handle delete question action
if (isset($_GET['delete_question'])) {
    $delete_id = intval($_GET['delete_question']);
    
    // First delete related answers
    $delete_answers_query = "DELETE FROM quiz_answers WHERE option_id IN (
        SELECT id FROM quiz_question_options WHERE question_id = $delete_id
    )";
    mysqli_query($conn, $delete_answers_query);
    
    // Then delete related options
    $delete_options_query = "DELETE FROM quiz_question_options WHERE question_id = $delete_id";
    mysqli_query($conn, $delete_options_query);
    
    // Then delete the question
    $delete_query = "DELETE FROM quiz_questions WHERE id = $delete_id";
    if (mysqli_query($conn, $delete_query)) {
        $success = "Question deleted successfully!";
    } else {
        $error = "Error deleting question: " . mysqli_error($conn);
    }
}

// Get class, section, and subject names for display
$class_name = '';
$section_name = '';
$subject_name = '';

if ($class_id > 0) {
    $class_name_query = "SELECT class_name FROM classes WHERE id = $class_id";
    $class_name_result = mysqli_query($conn, $class_name_query);
    if ($class_name_result && mysqli_num_rows($class_name_result) > 0) {
        $class_name = mysqli_fetch_assoc($class_name_result)['class_name'];
    }
}

if ($section_id > 0) {
    $section_name_query = "SELECT section_name FROM sections WHERE id = $section_id";
    $section_name_result = mysqli_query($conn, $section_name_query);
    if ($section_name_result && mysqli_num_rows($section_name_result) > 0) {
        $section_name = mysqli_fetch_assoc($section_name_result)['section_name'];
    }
}

if ($subject_id > 0) {
    $subject_name_query = "SELECT subject_name FROM subjects WHERE id = $subject_id";
    $subject_name_result = mysqli_query($conn, $subject_name_query);
    if ($subject_name_result && mysqli_num_rows($subject_name_result) > 0) {
        $subject_name = mysqli_fetch_assoc($subject_name_result)['subject_name'];
    }
}

// Fetch quizzes based on filters
$quizzes = [];
$quizzes_query = "SELECT q.*, s.subject_name, c.class_name, sec.section_name 
                  FROM quizzes q 
                  LEFT JOIN subjects s ON q.subject_id = s.id 
                  LEFT JOIN classes c ON q.class_id = c.id 
                  LEFT JOIN sections sec ON q.section_id = sec.id 
                  WHERE 1=1";
                  
if ($class_id > 0) {
    $quizzes_query .= " AND q.class_id = $class_id";
}
if ($section_id > 0) {
    $quizzes_query .= " AND q.section_id = $section_id";
}
if ($subject_id > 0) {
    $quizzes_query .= " AND q.subject_id = $subject_id";
}

$quizzes_query .= " ORDER BY q.created_at DESC";
$quizzes_result = mysqli_query($conn, $quizzes_query);
while ($quiz = mysqli_fetch_assoc($quizzes_result)) {
    $quizzes[] = $quiz;
}

// Fetch quiz details if editing or adding questions
$quiz_details = [];
$quiz_questions = [];
if ($quiz_id > 0) {
    $quiz_query = "SELECT q.*, s.subject_name, c.class_name, sec.section_name 
                   FROM quizzes q 
                   LEFT JOIN subjects s ON q.subject_id = s.id 
                   LEFT JOIN classes c ON q.class_id = c.id 
                   LEFT JOIN sections sec ON q.section_id = sec.id 
                   WHERE q.id = $quiz_id";
    $quiz_result = mysqli_query($conn, $quiz_query);
    if ($quiz_result && mysqli_num_rows($quiz_result) > 0) {
        $quiz_details = mysqli_fetch_assoc($quiz_result);
    }
    
    // Fetch questions for this quiz
    $questions_query = "SELECT * FROM quiz_questions WHERE quiz_id = $quiz_id ORDER BY created_at";
    $questions_result = mysqli_query($conn, $questions_query);
    while ($question = mysqli_fetch_assoc($questions_result)) {
        // Fetch options for all question types
        $options = [];
        $options_query = "SELECT * FROM quiz_question_options WHERE question_id = {$question['id']}";
        $options_result = mysqli_query($conn, $options_query);
        while ($option = mysqli_fetch_assoc($options_result)) {
            $options[] = $option;
        }
        $question['options'] = $options;
        $quiz_questions[] = $question;
    }
}

// Fetch question details for editing
$question_details = [];
if ($question_id > 0) {
    $question_query = "SELECT * FROM quiz_questions WHERE id = $question_id";
    $question_result = mysqli_query($conn, $question_query);
    if ($question_result && mysqli_num_rows($question_result) > 0) {
        $question_details = mysqli_fetch_assoc($question_result);
        
        // Fetch options for the question
        $options = [];
        $options_query = "SELECT * FROM quiz_question_options WHERE question_id = $question_id";
        $options_result = mysqli_query($conn, $options_query);
        while ($option = mysqli_fetch_assoc($options_result)) {
            $options[] = $option;
        }
        $question_details['options'] = $options;
    }
}

// Fetch students based on class and section for e-sign page
$students = [];
if (isset($_GET['esign']) && $class_id > 0) {
    $students_query = "SELECT s.id, s.first_name, s.last_name, s.roll_number 
                       FROM students s 
                       WHERE s.class_id = $class_id";
    
    if ($section_id > 0) {
        $students_query .= " AND s.section_id = $section_id";
    }
    
    $students_query .= " ORDER BY s.roll_number";
    $students_result = mysqli_query($conn, $students_query);
    
    while ($student = mysqli_fetch_assoc($students_result)) {
        $students[] = $student;
    }
}
?>


<body class="bg-gray-100">
    <div class="container mx-auto px-4 py-8">
        <div class="bg-white p-6 rounded-lg ">
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-2xl font-bold text-gray-800">Quiz Management</h2>
                <?php if ($action === 'list'): ?>
                    <div class="flex space-x-2">
                        <a href="quiz.php?action=create" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center">
                            <i class="fas fa-plus mr-2"></i> Create New Quiz
                        </a>
                        <?php if ($class_id > 0): ?>
                            <a href="quiz.php?class_id=<?php echo $class_id; ?>&section_id=<?php echo $section_id; ?>&subject_id=<?php echo $subject_id; ?>&esign=1" 
                               class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg flex items-center">
                                <i class="fas fa-signature mr-2"></i> E-Sign
                            </a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>

            <?php if (!empty($success)): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <?php echo $success; ?>
                </div>
            <?php endif; ?>
            
            <?php if (!empty($error)): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>

            <?php if (isset($_GET['esign']) && $class_id > 0): ?>
                <!-- E-Sign Page -->
                <div class="mb-6 bg-white p-6 rounded-lg ">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-xl font-semibold text-gray-800">
                            E-Sign - <?php echo $class_name; ?>
                            <?php if ($section_id > 0): ?>
                                - <?php echo $section_name; ?>
                            <?php endif; ?>
                        </h3>
                        <a href="quiz.php?class_id=<?php echo $class_id; ?>&section_id=<?php echo $section_id; ?>&subject_id=<?php echo $subject_id; ?>" 
                           class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                            Back to Quizzes
                        </a>
                    </div>
                    
                    <?php if (!empty($students)): ?>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                            <?php foreach ($students as $student): ?>
                                <div class="border rounded-lg p-4 flex flex-col items-center">
                                    <div class="w-24 h-24 bg-gray-200 rounded-full mb-3 flex items-center justify-center">
                                        <span class="text-4xl text-gray-500"><?php echo substr($student['first_name'], 0, 1); ?></span>
                                    </div>
                                    <h4 class="font-semibold text-lg"><?php echo $student['first_name'] . ' ' . $student['last_name']; ?></h4>
                                    <p class="text-gray-600">Roll No: <?php echo $student['roll_number']; ?></p>
                                    <div class="mt-4 w-full">
                                        <div class="border-t border-dashed border-gray-300 my-2"></div>
                                        <p class="text-center text-sm text-gray-500">Student Signature</p>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <p class="text-center py-8 text-gray-500">No students found for the selected class/section.</p>
                    <?php endif; ?>
                </div>

            <?php elseif ($action === 'create' || $action === 'edit'): ?>
                <!-- Create/Edit Quiz Form -->
                <?php 
                $is_edit = ($action === 'edit' && $quiz_id > 0);
                $form_title = $is_edit ? "Edit Quiz: " . $quiz_details['quiz_title'] : "Create New Quiz";
                $button_text = $is_edit ? "Update Quiz" : "Create Quiz";
                $form_action = $is_edit ? "quiz.php?action=edit&quiz_id=$quiz_id" : "quiz.php?action=create";
                ?>
                
                <div class="mb-6 bg-white p-6 rounded-lg ">
                    <h3 class="text-xl font-semibold text-gray-800 mb-4"><?php echo $form_title; ?></h3>
                    
                    <form method="POST" action="<?php echo $form_action; ?>">
                        <?php if ($is_edit): ?>
                            <input type="hidden" name="quiz_id" value="<?php echo $quiz_id; ?>">
                        <?php endif; ?>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Quiz Title *</label>
                                <input type="text" name="quiz_title" value="<?php echo $is_edit ? $quiz_details['quiz_title'] : ''; ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Subject *</label>
                                <select name="subject_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                                    <option value="">Select Subject</option>
                                    <?php 
                                    mysqli_data_seek($subjects_result, 0);
                                    while ($subject = mysqli_fetch_assoc($subjects_result)): 
                                    ?>
                                        <option value="<?php echo $subject['id']; ?>" <?php echo (($is_edit && $quiz_details['subject_id'] == $subject['id']) || $subject_id == $subject['id']) ? 'selected' : ''; ?>>
                                            <?php echo $subject['subject_name']; ?>
                                        </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Class *</label>
                                <select name="class_id" id="class_filter" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                                    <option value="">Select Class</option>
                                    <?php 
                                    mysqli_data_seek($classes_result, 0);
                                    while ($class = mysqli_fetch_assoc($classes_result)): 
                                    ?>
                                        <option value="<?php echo $class['id']; ?>" <?php echo (($is_edit && $quiz_details['class_id'] == $class['id']) || $class_id == $class['id']) ? 'selected' : ''; ?>>
                                            <?php echo $class['class_name']; ?>
                                        </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Section</label>
                                <select name="section_id" id="section_filter" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" <?php echo (($is_edit && $quiz_details['class_id'] == 0) || $class_id == 0) ? 'disabled' : ''; ?>>
                                    <option value="">Select Section (Optional)</option>
                                    <?php foreach ($sections as $section): ?>
                                        <option value="<?php echo $section['id']; ?>" <?php echo (($is_edit && $quiz_details['section_id'] == $section['id']) || $section_id == $section['id']) ? 'selected' : ''; ?>>
                                            <?php echo $section['section_name']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Time Limit (minutes)</label>
                                <input type="number" name="time_limit" min="1" value="<?php echo $is_edit ? $quiz_details['time_limit'] : '30'; ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                                <select name="status" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                                    <option value="draft" <?php echo ($is_edit && $quiz_details['status'] == 'draft') ? 'selected' : ''; ?>>Draft</option>
                                    <option value="active" <?php echo ($is_edit && $quiz_details['status'] == 'active') ? 'selected' : ''; ?>>Active</option>
                                </select>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Start Date</label>
                                <input type="datetime-local" name="start_date" value="<?php echo $is_edit && $quiz_details['start_date'] ? date('Y-m-d\TH:i', strtotime($quiz_details['start_date'])) : ''; ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">End Date</label>
                                <input type="datetime-local" name="end_date" value="<?php echo $is_edit && $quiz_details['end_date'] ? date('Y-m-d\TH:i', strtotime($quiz_details['end_date'])) : ''; ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Instructions</label>
                                <textarea name="instructions" rows="3" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo $is_edit ? $quiz_details['instructions'] : ''; ?></textarea>
                            </div>
                        </div>
                        
                        <div class="mt-6 flex justify-end space-x-3">
                            <a href="quiz.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                                Cancel
                            </a>
                            <button type="submit" name="<?php echo $is_edit ? 'update_quiz' : 'create_quiz'; ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                                <?php echo $button_text; ?>
                            </button>
                            <?php if ($is_edit): ?>
                                <a href="quiz.php?action=add_questions&quiz_id=<?php echo $quiz_id; ?>" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg">
                                    Add Questions
                                </a>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>

            <?php elseif ($action === 'add_questions' && $quiz_id > 0): ?>
                <!-- Add/Edit Questions to Quiz -->
                <div class="mb-6 bg-white p-6 rounded-lg ">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-xl font-semibold text-gray-800">
                            <?php echo isset($question_details['id']) ? "Edit Question" : "Add Questions to: " . $quiz_details['quiz_title']; ?>
                        </h3>
                        <div class="flex space-x-2">
                            <a href="quiz.php?action=edit&quiz_id=<?php echo $quiz_id; ?>" class="bg-yellow-600 hover:bg-yellow-700 text-white px-4 py-2 rounded-lg">
                                Edit Quiz
                            </a>
                            <a href="quiz.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                                Finish
                            </a>
                        </div>
                    </div>
                    
                    <!-- Question Form -->
                    <div class="mb-8 p-4 bg-gray-50 rounded-lg">
                        <h4 class="text-lg font-medium text-gray-700 mb-3"><?php echo isset($question_details['id']) ? "Edit Question" : "Add New Question"; ?></h4>
                        
                        <form method="POST" action="">
                            <input type="hidden" name="quiz_id" value="<?php echo $quiz_id; ?>">
                            <?php if (isset($question_details['id'])): ?>
                                <input type="hidden" name="question_id" value="<?php echo $question_details['id']; ?>">
                            <?php endif; ?>
                            
                            <div class="grid grid-cols-1 gap-4 mb-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Question Type</label>
                                    <select name="question_type" id="question_type" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                                        <option value="multiple_choice" <?php echo (isset($question_details['question_type']) && $question_details['question_type'] === 'multiple_choice') ? 'selected' : ''; ?>>Multiple Choice</option>
                                        <option value="true_false" <?php echo (isset($question_details['question_type']) && $question_details['question_type'] === 'true_false') ? 'selected' : ''; ?>>True/False</option>
                                        <option value="short_answer" <?php echo (isset($question_details['question_type']) && $question_details['question_type'] === 'short_answer') ? 'selected' : ''; ?>>Short Answer</option>
                                        <option value="essay" <?php echo (isset($question_details['question_type']) && $question_details['question_type'] === 'essay') ? 'selected' : ''; ?>>Essay</option>
                                    </select>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Question Text *</label>
                                    <textarea name="question_text" rows="3" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required><?php echo isset($question_details['question_text']) ? $question_details['question_text'] : ''; ?></textarea>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-medium text-gray-70 mb-1">Marks</label>
                                    <input type="number" name="marks" min="0" step="0.5" value="<?php echo isset($question_details['marks']) ? $question_details['marks'] : '1'; ?>" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                                </div>
                            </div>
                            
                            <!-- Multiple Choice Options -->
                            <div id="multiple_choice_options" class="mb-4" style="<?php echo (isset($question_details['question_type']) && $question_details['question_type'] === 'multiple_choice') ? '' : 'display: none;'; ?>">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Options</label>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                                    <?php 
                                    $options = isset($question_details['options']) ? $question_details['options'] : array_fill(0, 4, ['option_text' => '', 'is_correct' => 0]);
                                    $correct_index = -1;
                                    
                                    for ($i = 0; $i < 4; $i++): 
                                        if (isset($options[$i]) && $options[$i]['is_correct'] == 1) {
                                            $correct_index = $i;
                                        }
                                    ?>
                                        <div class="flex items-center">
                                            <input type="radio" name="correct_answer" value="<?php echo $i; ?>" class="mr-2" <?php echo ($correct_index === $i || ($correct_index === -1 && $i === 0)) ? 'checked' : ''; ?>>
                                            <input type="text" name="options[]" placeholder="Option <?php echo $i+1; ?>" value="<?php echo isset($options[$i]) ? $options[$i]['option_text'] : ''; ?>" class="w-full px-3 py-1 border rounded">
                                        </div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                            
                            <!-- True/False Options -->
                            <div id="true_false_options" class="mb-4" style="<?php echo (isset($question_details['question_type']) && $question_details['question_type'] === 'true_false') ? '' : 'display: none;'; ?>">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Correct Answer</label>
                                <div class="flex space-x-4">
                                    <label class="inline-flex items-center">
                                        <input type="radio" name="true_false_answer" value="true" class="mr-2" 
                                            <?php 
                                            if (isset($question_details['options'])) {
                                                foreach ($question_details['options'] as $option) {
                                                    if ($option['is_correct'] == 1 && $option['option_text'] == 'True') {
                                                        echo 'checked';
                                                        break;
                                                    }
                                                }
                                            } else {
                                                echo 'checked';
                                            }
                                            ?>>
                                        <span>True</span>
                                    </label>
                                    <label class="inline-flex items-center">
                                        <input type="radio" name="true_false_answer" value="false" class="mr-2"
                                            <?php 
                                            if (isset($question_details['options'])) {
                                                foreach ($question_details['options'] as $option) {
                                                    if ($option['is_correct'] == 1 && $option['option_text'] == 'False') {
                                                        echo 'checked';
                                                        break;
                                                    }
                                                }
                                            }
                                            ?>>
                                        <span>False</span>
                                    </label>
                                </div>
                            </div>
                            
                            <!-- Short Answer Options -->
                            <div id="short_answer_options" class="mb-4" style="<?php echo (isset($question_details['question_type']) && $question_details['question_type'] === 'short_answer') ? '' : 'display: none;'; ?>">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Expected Answer (Optional)</label>
                                <input type="text" name="short_answer" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" 
                                    value="<?php 
                                    if (isset($question_details['options']) && !empty($question_details['options'])) {
                                        echo $question_details['options'][0]['option_text'];
                                    }
                                    ?>">
                            </div>
                            
                            <!-- Essay Options -->
                            <div id="essay_options" class="mb-4" style="<?php echo (isset($question_details['question_type']) && $question_details['question_type'] === 'essay') ? '' : 'display: none;'; ?>">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Answer Guidelines (Optional)</label>
                                <textarea name="essay_guidelines" rows="3" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"><?php 
                                    if (isset($question_details['options']) && !empty($question_details['options'])) {
                                        echo $question_details['options'][0]['option_text'];
                                    }
                                ?></textarea>
                            </div>
                            
                            <div class="mt-4">
                                <button type="submit" name="<?php echo isset($question_details['id']) ? 'update_question' : 'add_question'; ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                                    <?php echo isset($question_details['id']) ? 'Update Question' : 'Add Question'; ?>
                                </button>
                                <?php if (isset($question_details['id'])): ?>
                                    <a href="quiz.php?action=add_questions&quiz_id=<?php echo $quiz_id; ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg ml-2">
                                        Cancel
                                    </a>
                                <?php endif; ?>
                            </div>
                        </form>
                    </div>
                    
                    <!-- Existing Questions -->
                    <h4 class="text-lg font-medium text-gray-700 mb-3">Existing Questions</h4>
                    
                    <?php if (!empty($quiz_questions)): ?>
                        <div class="space-y-4">
                            <?php foreach ($quiz_questions as $index => $question): ?>
                                <div class="p-4 border rounded-lg">
                                    <div class="flex justify-between items-start mb-2">
                                        <p class="font-medium">Q<?php echo $index + 1; ?>: <?php echo $question['question_text']; ?></p>
                                        <span class="bg-gray-200 text-gray-700 text-xs font-medium px-2 py-1 rounded">
                                            <?php echo ucfirst(str_replace('_', ' ', $question['question_type'])); ?> (<?php echo $question['marks']; ?> marks)
                                        </span>
                                    </div>
                                    
                                    <?php if ($question['question_type'] === 'multiple_choice' && !empty($question['options'])): ?>
                                        <div class="ml-4 mt-2">
                                            <?php foreach ($question['options'] as $option): ?>
                                                <div class="flex items-center mb-1">
                                                    <input type="radio" <?php echo $option['is_correct'] ? 'checked' : ''; ?> disabled class="mr-2">
                                                    <span><?php echo $option['option_text']; ?></span>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php elseif ($question['question_type'] === 'true_false' && !empty($question['options'])): ?>
                                        <div class="ml-4 mt-2">
                                            <?php foreach ($question['options'] as $option): ?>
                                                <div class="flex items-center mb-1">
                                                    <input type="radio" <?php echo $option['is_correct'] ? 'checked' : ''; ?> disabled class="mr-2">
                                                    <span><?php echo $option['option_text']; ?></span>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php elseif ($question['question_type'] === 'short_answer' && !empty($question['options'])): ?>
                                        <div class="ml-4 mt-2">
                                            <?php foreach ($question['options'] as $option): ?>
                                                <div class="mb-1">
                                                    <span class="text-sm font-medium">Expected answer:</span>
                                                    <p class="text-sm"><?php echo $option['option_text']; ?></p>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php elseif ($question['question_type'] === 'essay' && !empty($question['options'])): ?>
                                        <div class="ml-4 mt-2">
                                            <?php foreach ($question['options'] as $option): ?>
                                                <div class="mb-1">
                                                    <span class="text-sm font-medium">Guidelines:</span>
                                                    <p class="text-sm"><?php echo $option['option_text']; ?></p>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="mt-3 flex justify-end space-x-2">
                                        <a href="quiz.php?action=add_questions&quiz_id=<?php echo $quiz_id; ?>&question_id=<?php echo $question['id']; ?>" class="text-yellow-600 hover:text-yellow-800 text-sm">
                                            <i class="fas fa-edit mr-1"></i> Edit
                                        </a>
                                        <a href="quiz.php?action=add_questions&quiz_id=<?php echo $quiz_id; ?>&delete_question=<?php echo $question['id']; ?>" class="text-red-600 hover:text-red-800 text-sm" onclick="return confirm('Are you sure you want to delete this question? This action cannot be undone.');">
                                            <i class="fas fa-trash mr-1"></i> Delete
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <p class="text-center py-4 text-gray-500">No questions added yet.</p>
                    <?php endif; ?>
                </div>

            <?php else: ?>
                <!-- Filter Section -->
                <div class="mb-6 bg-gray-50 p-4 rounded-lg">
                    <form method="GET" action="" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <!-- Class Filter -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Select Class</label>
                            <select name="class_id" id="class_filter" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="">All Classes</option>
                                <?php 
                                mysqli_data_seek($classes_result, 0);
                                while ($class = mysqli_fetch_assoc($classes_result)): 
                                ?>
                                    <option value="<?php echo $class['id']; ?>" <?php echo ($class_id == $class['id']) ? 'selected' : ''; ?>>
                                        <?php echo $class['class_name']; ?>
                                        </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        
                        <!-- Section Filter -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Select Section</label>
                            <select name="section_id" id="section_filter" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" <?php echo ($class_id == 0) ? 'disabled' : ''; ?>>
                                <option value="">All Sections</option>
                                <?php foreach ($sections as $section): ?>
                                    <option value="<?php echo $section['id']; ?>" <?php echo ($section_id == $section['id']) ? 'selected' : ''; ?>>
                                        <?php echo $section['section_name']; ?>
                                    </option>
                                <?php endforeach; ?>
                                </select>
                        </div>
                        
                        <!-- Subject Filter -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Select Subject</label>
                            <select name="subject_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="">All Subjects</option>
                                <?php 
                                mysqli_data_seek($subjects_result, 0);
                                while ($subject = mysqli_fetch_assoc($subjects_result)): 
                                ?>
                                    <option value="<?php echo $subject['id']; ?>" <?php echo ($subject_id == $subject['id']) ? 'selected' : ''; ?>>
                                        <?php echo $subject['subject_name']; ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        
                        <!-- Buttons -->
                        <div class="flex items-end space-x-2">
                            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center h-10">
                                <i class="fas fa-filter mr-2"></i> Filter
                            </button>
                            <a href="quiz.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg flex items-center h-10">
                                <i class="fas fa-times mr-2"></i> Clear
                            </a>
                        </div>
                    </form>
                </div>

                <!-- Quizzes List -->
                <div class="bg-white p-4 rounded-lg ">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4">Quizzes</h3>
                    
                    <?php if (!empty($quizzes)): ?>
                        <div class="overflow-x-auto">
                            <table class="min-w-full bg-white">
                                <thead class="bg-gray-200 text-gray-700">
                                    <tr>
                                        <th class="py-3 px-4 text-left">Title</th>
                                        <th class="py-3 px-4 text-left">Subject</th>
                                        <th class="py-3 px-4 text-left">Class</th>
                                        <th class="py-3 px-4 text-left">Section</th>
                                        <th class="py-3 px-4 text-left">Date Range</th>
                                        <th class="py-3 px-4 text-left">Questions</th>
                                        <th class="py-3 px-4 text-left">Time Limit</th>
                                        <th class="py-3 px-4 text-left">Status</th>
                                        <th class="py-3 px-4 text-left">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="text-gray-600">
                                    <?php foreach ($quizzes as $quiz): 
                                        // Count questions for this quiz
                                        $count_query = "SELECT COUNT(*) as count FROM quiz_questions WHERE quiz_id = {$quiz['id']}";
                                        $count_result = mysqli_query($conn, $count_query);
                                        $question_count = mysqli_fetch_assoc($count_result)['count'];
                                        
                                        // Format date range
                                        $date_range = '';
                                        if ($quiz['start_date'] && $quiz['end_date']) {
                                            $date_range = date('M j, Y', strtotime($quiz['start_date'])) . ' to ' . date('M j, Y', strtotime($quiz['end_date']));
                                        } elseif ($quiz['start_date']) {
                                            $date_range = 'From ' . date('M j, Y', strtotime($quiz['start_date']));
                                        } elseif ($quiz['end_date']) {
                                            $date_range = 'Until ' . date('M j, Y', strtotime($quiz['end_date']));
                                        } else {
                                            $date_range = 'No date restriction';
                                        }
                                    ?>
                                        <tr class="border-b border-gray-200 hover:bg-gray-50">
                                            <td class="py-3 px-4"><?php echo $quiz['quiz_title']; ?></td>
                                            <td class="py-3 px-4"><?php echo $quiz['subject_name']; ?></td>
                                            <td class="py-3 px-4"><?php echo $quiz['class_name']; ?></td>
                                            <td class="py-3 px-4"><?php echo $quiz['section_name'] ?: 'All'; ?></td>
                                            <td class="py-3 px-4 text-sm"><?php echo $date_range; ?></td>
                                            <td class="py-3 px-4"><?php echo $question_count; ?></td>
                                            <td class="py-3 px-4"><?php echo $quiz['time_limit']; ?> mins</td>
                                            <td class="py-3 px-4">
                                                <span class="px-2 py-1 text-xs font-medium rounded-full 
                                                    <?php echo $quiz['status'] === 'active' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'; ?>">
                                                    <?php echo ucfirst($quiz['status']); ?>
                                                </span>
                                            </td>
                                            <td class="py-3 px-4">
                                                <div class="flex space-x-2">
                                                    <a href="quiz.php?action=add_questions&quiz_id=<?php echo $quiz['id']; ?>" 
                                                       class="text-blue-600 hover:text-blue-800" title="Add Questions">
                                                        <i class="fas fa-question-circle"></i>
                                                    </a>
                                                    <a href="quiz.php?action=edit&quiz_id=<?php echo $quiz['id']; ?>" 
                                                       class="text-yellow-600 hover:text-yellow-800" title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="quiz.php?delete_quiz=<?php echo $quiz['id']; ?>" 
                                                       class="text-red-600 hover:text-red-800" title="Delete" 
                                                       onclick="return confirm('Are you sure you want to delete this quiz? This action cannot be undone.');">
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-center py-4 text-gray-500">
                            No quizzes found. <a href="quiz.php?action=create" class="text-blue-600 hover:underline">Create your first quiz</a>.
                        </p>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
    // JavaScript to handle dynamic section loading based on class selection
    document.getElementById('class_filter').addEventListener('change', function() {
        const classId = this.value;
        const sectionSelect = document.getElementById('section_filter');
        
        if (classId) {
            // Enable section dropdown
            sectionSelect.disabled = false;
            
            // Fetch sections for the selected class via AJAX
            fetch('get_section.php?class_id=' + classId)
                .then(response => response.json())
                .then(sections => {
                    // Clear existing options except the first one
                    while (sectionSelect.options.length > 1) {
                        sectionSelect.remove(1);
                    }
                    
                    // Add new options
                    sections.forEach(section => {
                        const option = document.createElement('option');
                        option.value = section.id;
                        option.textContent = section.section_name;
                        sectionSelect.appendChild(option);
                    });
                })
                .catch(error => console.error('Error fetching sections:', error));
        } else {
            // Disable and clear section dropdown if no class is selected
            sectionSelect.disabled = true;
            while (sectionSelect.options.length > 1) {
                sectionSelect.remove(1);
            }
        }
    });

    // Toggle question options based on question type
    document.getElementById('question_type').addEventListener('change', function() {
        const questionType = this.value;
        const multipleChoiceDiv = document.getElementById('multiple_choice_options');
        const trueFalseDiv = document.getElementById('true_false_options');
        const shortAnswerDiv = document.getElementById('short_answer_options');
        const essayDiv = document.getElementById('essay_options');
        
        // Hide all options first
        multipleChoiceDiv.style.display = 'none';
        trueFalseDiv.style.display = 'none';
        shortAnswerDiv.style.display = 'none';
        essayDiv.style.display = 'none';
        
        // Show only the relevant options
        if (questionType === 'multiple_choice') {
            multipleChoiceDiv.style.display = 'block';
        } else if (questionType === 'true_false') {
            trueFalseDiv.style.display = 'block';
        } else if (questionType === 'short_answer') {
            shortAnswerDiv.style.display = 'block';
        } else if (questionType === 'essay') {
            essayDiv.style.display = 'block';
        }
    });

    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
        // Set initial visibility based on question type
        const questionTypeSelect = document.getElementById('question_type');
        if (questionTypeSelect) {
            const questionType = questionTypeSelect.value;
            const multipleChoiceDiv = document.getElementById('multiple_choice_options');
            const trueFalseDiv = document.getElementById('true_false_options');
            const shortAnswerDiv = document.getElementById('short_answer_options');
            const essayDiv = document.getElementById('essay_options');
            
            // Hide all options first
            multipleChoiceDiv.style.display = 'none';
            trueFalseDiv.style.display = 'none';
            shortAnswerDiv.style.display = 'none';
            essayDiv.style.display = 'none';
            
            // Show only the relevant options
            if (questionType === 'multiple_choice') {
                multipleChoiceDiv.style.display = 'block';
            } else if (questionType === 'true_false') {
                trueFalseDiv.style.display = 'block';
            } else if (questionType === 'short_answer') {
                shortAnswerDiv.style.display = 'block';
            } else if (questionType === 'essay') {
                essayDiv.style.display = 'block';
            }
        }
        
        // Enable section dropdown if class is already selected
        const classId = document.getElementById('class_filter').value;
        const sectionSelect = document.getElementById('section_filter');
        
        if (classId) {
            sectionSelect.disabled = false;
        }
    });
    </script>

    <?php
    include 'include/footer.php';
    ob_end_flush();
    ?>
</body>
</html>