<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Handle logo upload (same as before)
if (isset($_POST['upload_logo'])) {
    // Your existing logo upload code
}

// Handle signature upload (same as before)
if (isset($_POST['upload_signature'])) {
    // Your existing signature upload code
}

// Get school logo and signature paths
$school_logo = "";
$authorized_signature = "";

$settings_query = "SELECT * FROM settings WHERE name IN ('school_logo', 'authorized_signature')";
$settings_result = mysqli_query($conn, $settings_query);
while ($setting = mysqli_fetch_assoc($settings_result)) {
    if ($setting['name'] == 'school_logo') {
        $school_logo = $setting['value'];
    } elseif ($setting['name'] == 'authorized_signature') {
        $authorized_signature = $setting['value'];
    }
}

// Fetch all classes
$classes_query = "SELECT id, class_name FROM classes WHERE status = 'active' ORDER BY class_name";
$classes_result = mysqli_query($conn, $classes_query);

// NEW: Handle single student ID card generation
if (isset($_POST['generate_single_id'])) {
    $student_id = mysqli_real_escape_string($conn, $_POST['student_id']);
    $card_type = mysqli_real_escape_string($conn, $_POST['card_type']);
    
    // Fetch specific student
    $student_query = "SELECT s.*, c.class_name, sec.section_name 
                      FROM students s 
                      LEFT JOIN classes c ON s.class = c.id 
                      LEFT JOIN sections sec ON s.section = sec.id 
                      WHERE s.id = '$student_id' AND s.status = 'active'";
    
    $student_result = mysqli_query($conn, $student_query);
    
    if (mysqli_num_rows($student_result) > 0) {
        // Store student data in session for PDF generation
        $_SESSION['id_card_data'] = [
            'students' => [mysqli_fetch_assoc($student_result)],
            'card_type' => $card_type,
            'school_logo' => $school_logo,
            'authorized_signature' => $authorized_signature
        ];
        
        // Redirect to PDF generation page
        header("Location: generate_id_pdf.php");
        exit();
    } else {
        $_SESSION['message'] = "Student not found.";
        $_SESSION['message_type'] = "error";
    }
}

// Handle bulk ID card generation (existing code)
if (isset($_POST['generate_id_cards'])) {
    // Your existing bulk generation code
}

ob_end_flush();
?>

<div class="bg-white p-6 rounded-lg">
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Student ID Card Generator</h2>
        <p class="text-gray-600">Generate ID cards for individual students or entire classes</p>
    </div>

    <?php if (isset($_SESSION['message'])): ?>
        <div class="<?php echo $_SESSION['message_type'] == 'success' ? 'bg-green-100 border-green-400 text-green-700' : 'bg-red-100 border-red-400 text-red-700'; ?> border px-4 py-3 rounded mb-4">
            <?php 
            echo $_SESSION['message']; 
            unset($_SESSION['message']);
            unset($_SESSION['message_type']);
            ?>
        </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- Single Student ID Card Generation Form -->
        <div class="bg-gray-50 p-4 rounded-lg">
            <h3 class="text-lg font-semibold text-gray-800 mb-4">Generate Single ID Card</h3>
            <form method="POST" action="">
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Select Student</label>
                    <select name="student_id" id="student_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                        <option value="">Select Student</option>
                        <?php 
                        $all_students = mysqli_query($conn, "SELECT id, full_name, student_id FROM students WHERE status='active' ORDER BY full_name");
                        while ($student = mysqli_fetch_assoc($all_students)): 
                        ?>
                            <option value="<?php echo $student['id']; ?>">
                                <?php echo $student['full_name'] . " (" . $student['student_id'] . ")"; ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">ID Card Type</label>
                    <select name="card_type" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="front">Front Only</option>
                        <option value="back">Back Only</option>
                        <option value="both" selected>Both Front & Back</option>
                    </select>
                </div>
                
                <button type="submit" name="generate_single_id" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg w-full">
                    Generate ID Card
                </button>
            </form>
        </div>
        
        <!-- Bulk ID Card Generation Form -->
        <div class="bg-gray-50 p-4 rounded-lg">
            <h3 class="text-lg font-semibold text-gray-800 mb-4">Generate Bulk ID Cards</h3>
            <form method="POST" action="">
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Select Class</label>
                    <select name="class_id" id="class_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Classes</option>
                        <?php 
                        // Reset pointer for classes result
                        mysqli_data_seek($classes_result, 0);
                        while ($class = mysqli_fetch_assoc($classes_result)): 
                        ?>
                            <option value="<?php echo $class['id']; ?>"><?php echo $class['class_name']; ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Select Section</label>
                    <select name="section_id" id="section_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" disabled>
                        <option value="">All Sections</option>
                    </select>
                </div>
                
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">ID Card Type</label>
                    <select name="card_type" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="front">Front Only</option>
                        <option value="back">Back Only</option>
                        <option value="both" selected>Both Front & Back</option>
                    </select>
                </div>
                
                <button type="submit" name="generate_id_cards" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg w-full">
                    Generate ID Cards
                </button>
            </form>
        </div>
    </div>
    
    <!-- Upload Section -->
    <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- School Logo Upload -->
        <div class="bg-gray-50 p-4 rounded-lg">
            <h4 class="text-md font-medium text-gray-700 mb-2">School Logo</h4>
            <?php if (!empty($school_logo) && file_exists("../" . $school_logo)): ?>
                <div class="mb-2">
                    <img src="../<?php echo $school_logo; ?>" alt="School Logo" class="h-16 mx-auto">
                </div>
            <?php else: ?>
                <p class="text-sm text-gray-500 mb-2">No logo uploaded</p>
            <?php endif; ?>
            
            <form method="POST" action="" enctype="multipart/form-data">
                <div class="flex items-center">
                    <input type="file" name="school_logo" accept="image/*" class="flex-1">
                    <button type="submit" name="upload_logo" class="bg-gray-600 hover:bg-gray-700 text-white px-3 py-1 rounded ml-2">
                        Upload
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Signature Upload -->
        <div class="bg-gray-50 p-4 rounded-lg">
            <h4 class="text-md font-medium text-gray-700 mb-2">Authorized Signature</h4>
            <?php if (!empty($authorized_signature) && file_exists("../" . $authorized_signature)): ?>
                <div class="mb-2">
                    <img src="../<?php echo $authorized_signature; ?>" alt="Authorized Signature" class="h-16 mx-auto">
                </div>
            <?php else: ?>
                <p class="text-sm text-gray-500 mb-2">No signature uploaded</p>
            <?php endif; ?>
            
            <form method="POST" action="" enctype="multipart/form-data">
                <div class="flex items-center">
                    <input type="file" name="signature" accept="image/*" class="flex-1">
                    <button type="submit" name="upload_signature" class="bg-gray-600 hover:bg-gray-700 text-white px-3 py-1 rounded ml-2">
                        Upload
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Preview Section -->
    <div class="mt-8 bg-gray-50 p-4 rounded-lg">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">ID Card Preview</h3>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Front Preview -->
            <div class="border border-gray-300 rounded-lg p-4">
                <h4 class="text-md font-medium text-gray-700 mb-3 text-center">Front Preview</h4>
                <div class="bg-white border border-gray-300 rounded-lg p-4 mx-auto" style="width: 300px; height: 200px;">
                    <div class="flex justify-between items-start mb-4">
                        <?php if (!empty($school_logo) && file_exists("../" . $school_logo)): ?>
                            <img src="../<?php echo $school_logo; ?>" alt="School Logo" class="h-12">
                        <?php else: ?>
                            <div class="h-12 w-12 bg-gray-200 rounded-full flex items-center justify-center">
                                <span class="text-gray-500 text-xs">Logo</span>
                            </div>
                        <?php endif; ?>
                        
                        <div class="text-center">
                            <h3 class="font-bold text-lg">ADINO HEIGHT SCHOOL</h3>
                            <p class="text-xs">Excellence in Education</p>
                        </div>
                        
                        <div class="h-16 w-16 bg-gray-200 rounded flex items-center justify-center">
                            <span class="text-gray-500 text-xs">Photo</span>
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-3 gap-2 text-xs">
                        <div class="font-medium">Name:</div>
                        <div class="col-span-2">Student Name</div>
                        
                        <div class="font-medium">Class:</div>
                        <div class="col-span-2">Class - Section</div>
                        
                        <div class="font-medium">ID:</div>
                        <div class="col-span-2">STU-001</div>
                        
                        <div class="font-medium">Valid Until:</div>
                        <div class="col-span-2">Dec 2024</div>
                    </div>
                </div>
            </div>
            
            <!-- Back Preview -->
            <div class="border border-gray-300 rounded-lg p-4">
                <h4 class="text-md font-medium text-gray-700 mb-3 text-center">Back Preview</h4>
                <div class="bg-white border border-gray-300 rounded-lg p-4 mx-auto" style="width: 300px; height: 200px;">
                    <h4 class="font-bold text-center mb-3">SCHOOL INFORMATION</h4>
                    
                    <div class="text-xs mb-4">
                        <p class="mb-1"><strong>Address:</strong> 6, Ademuyiwas Lane, Off Ayepe Road, Sagamu, Ogun State</p>
                        <p class="mb-1"><strong>Phone:</strong> +234 08093597160</p>
                        <p class="mb-1"><strong>Email:</strong> info@adinoheightschool.com</p>
                        <p><strong>Website:</strong> https://www.adinoheightschool.com/</p>
                    </div>
                    
                    <div class="text-xs">
                        <p class="mb-2"><strong>Emergency Contact:</strong> +234 08093597160</p>
                        <p class="mb-2"><strong>Blood Group:</strong> O+</p>
                        
                        <div class="flex justify-between items-end mt-4">
                            <div>
                                <?php if (!empty($authorized_signature) && file_exists("../" . $authorized_signature)): ?>
                                    <img src="../<?php echo $authorized_signature; ?>" alt="Signature" class="h-10">
                                <?php else: ?>
                                    <div class="h-10 w-24 border-t border-gray-400"></div>
                                <?php endif; ?>
                                <p class="text-xs mt-1">Authorized Signature</p>
                            </div>
                            
                            <div class="h-16 w-16 bg-gray-200 rounded flex items-center justify-center">
                                <span class="text-gray-500 text-xs">Barcode</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// JavaScript to handle dynamic section loading based on class selection
document.getElementById('class_id').addEventListener('change', function() {
    const classId = this.value;
    const sectionSelect = document.getElementById('section_id');
    
    if (classId) {
        // Enable section dropdown
        sectionSelect.disabled = false;
        
        // Fetch sections for the selected class via AJAX
        fetch('get_section.php?class_id=' + classId)
            .then(response => response.json())
            .then(sections => {
                // Clear existing options except the first one
                while (sectionSelect.options.length > 1) {
                    sectionSelect.remove(1);
                }
                
                // Add new options
                sections.forEach(section => {
                    const option = document.createElement('option');
                    option.value = section.id;
                    option.textContent = section.section_name;
                    sectionSelect.appendChild(option);
                });
            })
            .catch(error => console.error('Error fetching sections:', error));
    } else {
        // Disable and clear section dropdown if no class is selected
        sectionSelect.disabled = true;
        while (sectionSelect.options.length > 1) {
            sectionSelect.remove(1);
        }
    }
});
</script>

<?php
include 'include/footer.php';
mysqli_close($conn);
?>