<?php
include 'include/header.php';
include '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$admin_id = $_SESSION['user_id'];
$admin_name = $_SESSION['user_name'];

$success = '';
$error = '';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Add Subject
    if (isset($_POST['add_subject'])) {
        $subject_name = mysqli_real_escape_string($conn, $_POST['subject_name']);
        $description = mysqli_real_escape_string($conn, $_POST['description']);
        
        if (empty($subject_name)) {
            $error = "Subject name is required";
        } else {
            $subject_code = generateSubjectCode($subject_name);

            // Check subject name
            $check_query = "SELECT * FROM subjects WHERE subject_name='$subject_name'";
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "Subject name already exists";
            } else {
                // Check subject code
                $check_code_query = "SELECT * FROM subjects WHERE subject_code='$subject_code'";
                $check_code_result = mysqli_query($conn, $check_code_query);
                
                if (mysqli_num_rows($check_code_result) > 0) {
                    $counter = 1;
                    do {
                        $new_subject_code = $subject_code . $counter;
                        $check_code_query = "SELECT * FROM subjects WHERE subject_code='$new_subject_code'";
                        $check_code_result = mysqli_query($conn, $check_code_query);
                        $counter++;
                    } while (mysqli_num_rows($check_code_result) > 0);
                    
                    $subject_code = $new_subject_code;
                }
                
                $insert_query = "INSERT INTO subjects (subject_code, subject_name, description, created_by) 
                                VALUES ('$subject_code', '$subject_name', '$description', '$admin_id')";
                
                if (mysqli_query($conn, $insert_query)) {
                    $success = "Subject added successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        }
    }    
    
    // Assign Teacher to Subject
    if (isset($_POST['assign_teacher'])) {
        $subject_id = mysqli_real_escape_string($conn, $_POST['subject_id']);
        $teacher_id = mysqli_real_escape_string($conn, $_POST['teacher_id']);
        
        if (empty($subject_id) || empty($teacher_id)) {
            $error = "Please select both subject and teacher";
        } else {
            $check_query = "SELECT * FROM subject_teachers WHERE subject_id='$subject_id' AND teacher_id='$teacher_id'";
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "This teacher is already assigned to this subject";
            } else {
                $insert_query = "INSERT INTO subject_teachers (subject_id, teacher_id, assigned_by) 
                                VALUES ('$subject_id', '$teacher_id', '$admin_id')";
                
                if (mysqli_query($conn, $insert_query)) {
                    $success = "Teacher assigned to subject successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        }
    }
    
    // Edit Subject
    if (isset($_POST['edit_subject'])) {
        $subject_id = mysqli_real_escape_string($conn, $_POST['subject_id']);
        $subject_name = mysqli_real_escape_string($conn, $_POST['subject_name']);
        $description = mysqli_real_escape_string($conn, $_POST['description']);
        
        if (empty($subject_name)) {
            $error = "Subject name is required";
        } else {
            $check_query = "SELECT * FROM subjects WHERE subject_name='$subject_name' AND id != '$subject_id'";
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "Subject name already exists";
            } else {
                $update_query = "UPDATE subjects SET subject_name='$subject_name', 
                                description='$description' WHERE id='$subject_id'";
                
                if (mysqli_query($conn, $update_query)) {
                    $success = "Subject updated successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        }
    }
}

// Handle delete actions
if (isset($_GET['action']) && isset($_GET['type']) && isset($_GET['id'])) {
    $action = $_GET['action'];
    $type = $_GET['type'];
    $id = $_GET['id'];
    
    if ($action == 'delete') {
        if ($type == 'subject') {
            $check_assignments = "SELECT * FROM subject_teachers WHERE subject_id='$id'";
            $assignment_result = mysqli_query($conn, $check_assignments);
            
            if (mysqli_num_rows($assignment_result) > 0) {
                $error = "Cannot delete subject. It has teacher assignments.";
            } else {
                $delete_query = "DELETE FROM subjects WHERE id='$id'";
                if (mysqli_query($conn, $delete_query)) {
                    $success = "Subject deleted successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        } elseif ($type == 'assignment') {
            $delete_query = "DELETE FROM subject_teachers WHERE id='$id'";
            if (mysqli_query($conn, $delete_query)) {
                $success = "Teacher assignment removed successfully!";
            } else {
                $error = "Error: " . mysqli_error($conn);
            }
        }
    }
}

function generateSubjectCode($subject_name) {
    $code = preg_replace('/[^A-Za-z0-9]/', '', $subject_name);
    $code = strtoupper($code);
    return strlen($code) > 6 ? substr($code, 0, 6) : str_pad($code, 6, 'X', STR_PAD_RIGHT);
}

// ✅ Fetch data
$subject_query = "SELECT * FROM subjects WHERE status='active' ORDER BY subject_name";
$subject_result = mysqli_query($conn, $subject_query);

// ✅ Teachers come from users table now
$teacher_query = "SELECT id, full_name 
                  FROM users 
                  WHERE status='active' AND role='teacher' 
                  ORDER BY full_name";
$teacher_result = mysqli_query($conn, $teacher_query);

// ✅ Assignments now use users instead of teachers
$assignment_query = "SELECT st.id, s.subject_name, u.full_name as teacher_name, st.assigned_date 
                     FROM subject_teachers st 
                     JOIN subjects s ON st.subject_id = s.id 
                     JOIN users u ON st.teacher_id = u.id 
                     WHERE u.role='teacher'
                     ORDER BY s.subject_name, u.full_name";
$assignment_result = mysqli_query($conn, $assignment_query);
?>

<div class="bg-white p-6 ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Subject Management</h2>
        <button onclick="openTab('subject-tab')" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 flex items-center">
            <i class="fas fa-plus mr-2"></i> Add New Subject
        </button>
    </div>

    <?php if (!empty($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <i class="fas fa-check-circle mr-2"></i> <?php echo $success; ?>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <i class="fas fa-exclamation-circle mr-2"></i> <?php echo $error; ?>
        </div>
    <?php endif; ?>
    
    <div class="flex border-b border-gray-200 mb-6">
        <button id="subject-tab-btn" class="px-4 py-2 font-medium text-blue-600 border-b-2 border-blue-600 focus:outline-none">
            <i class="fas fa-book mr-2"></i> Manage Subjects
        </button>
      
    </div>
    
    <!-- Subject Management Tab -->
    <div id="subject-tab" class="tab-content">
        <div class="bg-white p-6  mb-6">
            <h3 class="text-lg font-medium text-gray-800 mb-4"><i class="fas fa-plus-circle mr-2"></i> Add New Subject</h3>
            <form method="POST">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <label for="subject_name" class="block text-sm font-medium text-gray-700 mb-1">Subject Name <span class="text-red-500">*</span></label>
                        <input type="text" id="subject_name" name="subject_name" required 
                               placeholder="e.g., Mathematics, Science, etc."
                               class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <div>
                        <label for="description" class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                        <textarea id="description" name="description" 
                                  placeholder="Optional subject description"
                                  class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" rows="3"></textarea>
                    </div>
                </div>
                
                <div class="text-center">
                    <button type="submit" name="add_subject" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg">
                        <i class="fas fa-plus mr-2"></i> Add Subject
                    </button>
                </div>
            </form>
        </div>
        
        <div class="bg-white p-6 ">
            <h3 class="text-lg font-medium text-gray-800 mb-4"><i class="fas fa-list mr-2"></i> Existing Subjects</h3>
            <?php if (mysqli_num_rows($subject_result) > 0): ?>
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white">
                        <thead class="bg-gray-200 text-gray-700">
                            <tr>
                                <th class="py-3 px-4 text-left">Subject Name</th>
                                <th class="py-3 px-4 text-left">Description</th>
                                <th class="py-3 px-4 text-left">Status</th>
                                <th class="py-3 px-4 text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600">
                            <?php while($subject = mysqli_fetch_assoc($subject_result)): ?>
                                <tr class="border-b border-gray-200 hover:bg-gray-50">
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($subject['subject_name']); ?></td>
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($subject['description'] ?? 'N/A'); ?></td>
                                    <td class="py-3 px-4">
                                        <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded"><?php echo htmlspecialchars(ucfirst($subject['status'])); ?></span>
                                    </td>
                                    <td class="py-3 px-4">
                                        <div class="flex space-x-2">
                                            <button onclick="openEditSubjectModal(<?php echo $subject['id']; ?>, '<?php echo htmlspecialchars($subject['subject_name']); ?>', '<?php echo htmlspecialchars($subject['description'] ?? ''); ?>')" 
                                                    class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button onclick="confirmDelete('subject', <?php echo $subject['id']; ?>, '<?php echo htmlspecialchars($subject['subject_name']); ?>')" 
                                                    class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-8 text-gray-500">
                    <i class="fas fa-inbox text-4xl mb-3"></i>
                    <p class="mb-4">No subjects found. Please add subjects using the form above.</p>
                    <button class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg" onclick="document.getElementById('subject_name').focus()">
                        <i class="fas fa-plus mr-2"></i> Add Your First Subject
                    </button>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Assign Teacher Tab -->
    <div id="assign-tab" class="tab-content hidden">
        <div class="bg-white p-6 ">
            <h3 class="text-lg font-medium text-gray-800 mb-4"><i class="fas fa-chalkboard-teacher mr-2"></i> Assign Teacher to Subject</h3>
            <form method="POST">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <label for="subject_id" class="block text-sm font-medium text-gray-700 mb-1">Subject <span class="text-red-500">*</span></label>
                        <select id="subject_id" name="subject_id" required class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Subject</option>
                            <?php 
                            $subject_assign_result = mysqli_query($conn, $subject_query);
                            while($subject = mysqli_fetch_assoc($subject_assign_result)): ?>
                                <option value="<?php echo $subject['id']; ?>">
                                    <?php echo htmlspecialchars($subject['subject_name']); ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    
                    <div>
                        <label for="teacher_id" class="block text-sm font-medium text-gray-700 mb-1">Teacher <span class="text-red-500">*</span></label>
                        <select id="teacher_id" name="teacher_id" required class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Teacher</option>
                            <?php 
                            $teacher_assign_result = mysqli_query($conn, $teacher_query);
                            while($teacher = mysqli_fetch_assoc($teacher_assign_result)): ?>
                                <option value="<?php echo $teacher['id']; ?>">
                                    <?php echo htmlspecialchars($teacher['full_name']); ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                </div>
                
                <div class="text-center">
                    <button type="submit" name="assign_teacher" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg">
                        <i class="fas fa-link mr-2"></i> Assign Teacher
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- View Assignments Tab -->
    <div id="view-tab" class="tab-content hidden">
        <div class="bg-white p-6 ">
            <h3 class="text-lg font-medium text-gray-800 mb-4"><i class="fas fa-list-check mr-2"></i> Subject-Teacher Assignments</h3>
            <?php if (mysqli_num_rows($assignment_result) > 0): ?>
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white">
                        <thead class="bg-gray-200 text-gray-700">
                            <tr>
                                <th class="py-3 px-4 text-left">Subject Name</th>
                                <th class="py-3 px-4 text-left">Teacher</th>
                                <th class="py-3 px-4 text-left">Assigned Date</th>
                                <th class="py-3 px-4 text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600">
                            <?php while($assignment = mysqli_fetch_assoc($assignment_result)): ?>
                                <tr class="border-b border-gray-200 hover:bg-gray-50">
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($assignment['subject_name']); ?></td>
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($assignment['teacher_name']); ?></td>
                                    <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($assignment['assigned_date'])); ?></td>
                                    <td class="py-3 px-4">
                                        <button onclick="confirmDeleteAssignment(<?php echo $assignment['id']; ?>, '<?php echo htmlspecialchars($assignment['subject_name']); ?>', '<?php echo htmlspecialchars($assignment['teacher_name']); ?>')" 
                                                class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded" title="Remove">
                                            <i class="fas fa-unlink"></i> Remove
                                        </button>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-8 text-gray-500">
                    <i class="fas fa-users-slash text-4xl mb-3"></i>
                    <p class="mb-4">No teacher assignments found. Please assign teachers to subjects.</p>
                    <button class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg" onclick="openTab('assign-tab')">
                        <i class="fas fa-chalkboard-teacher mr-2"></i> Assign Teachers
                    </button>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Edit Subject Modal -->
<div id="editSubjectModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white  w-11/12 md:w-1/2 max-w-2xl">
        <div class="border-b px-6 py-4 flex justify-between items-center">
            <h3 class="text-lg font-medium text-gray-800">Edit Subject</h3>
            <button onclick="closeModal('editSubjectModal')" class="text-gray-500 hover:text-gray-700">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <form method="POST" id="editSubjectForm">
            <div class="p-6">
                <input type="hidden" name="subject_id" id="edit_subject_id">
                
                <div class="mb-4">
                    <label for="edit_subject_name" class="block text-sm font-medium text-gray-700 mb-1">Subject Name <span class="text-red-500">*</span></label>
                    <input type="text" id="edit_subject_name" name="subject_name" required
                           class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                
                <div class="mb-4">
                    <label for="edit_description" class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                    <textarea id="edit_description" name="description"
                              class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" rows="3"></textarea>
                </div>
            </div>
            <div class="border-t px-6 py-4 flex justify-end space-x-3">
                <button type="button" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg" onclick="closeModal('editSubjectModal')">Cancel</button>
                <button type="submit" name="edit_subject" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                    <i class="fas fa-save mr-2"></i> Update Subject
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white  w-11/12 md:w-1/3 max-w-md">
        <div class="border-b px-6 py-4">
            <h3 class="text-lg font-medium text-gray-800">Confirm Delete</h3>
        </div>
        <div class="p-6">
            <p id="deleteMessage" class="text-gray-700">Are you sure you want to delete this item?</p>
        </div>
        <div class="border-t px-6 py-4 flex justify-end space-x-3">
            <button type="button" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg" onclick="closeModal('deleteModal')">Cancel</button>
            <button type="button" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg" onclick="proceedDelete()">
                <i class="fas fa-trash mr-2"></i> Delete
            </button>
        </div>
    </div>
</div>

<!-- Delete Assignment Confirmation Modal -->
<div id="deleteAssignmentModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white  w-11/12 md:w-1/3 max-w-md">
        <div class="border-b px-6 py-4">
            <h3 class="text-lg font-medium text-gray-800">Confirm Removal</h3>
        </div>
        <div class="p-6">
            <p id="deleteAssignmentMessage" class="text-gray-700">Are you sure you want to remove this teacher assignment?</p>
        </div>
        <div class="border-t px-6 py-4 flex justify-end space-x-3">
            <button type="button" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg" onclick="closeModal('deleteAssignmentModal')">Cancel</button>
            <button type="button" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg" onclick="proceedDeleteAssignment()">
                <i class="fas fa-unlink mr-2"></i> Remove
            </button>
        </div>
    </div>
</div>

<script>
    // Tab navigation
    function openTab(tabId) {
        // Hide all tab contents
        const tabContents = document.querySelectorAll('.tab-content');
        tabContents.forEach(tab => tab.classList.add('hidden'));
        
        // Remove active class from all tabs
        const tabButtons = document.querySelectorAll('.flex.border-b button');
        tabButtons.forEach(btn => {
            btn.classList.remove('text-blue-600', 'border-blue-600');
            btn.classList.add('text-gray-600', 'hover:text-blue-600');
        });
        
        // Show the selected tab content and mark tab as active
        document.getElementById(tabId).classList.remove('hidden');
        
        // Update the button styles
        const activeBtn = document.getElementById(tabId + '-btn');
        if (activeBtn) {
            activeBtn.classList.remove('text-gray-600', 'hover:text-blue-600');
            activeBtn.classList.add('text-blue-600', 'border-blue-600');
        }
    }
    
    // Initialize tabs
    document.addEventListener('DOMContentLoaded', function() {
        // Set the first tab as active
        openTab('subject-tab');
        
        // Add click events to tab buttons
        document.getElementById('subject-tab-btn').addEventListener('click', function() {
            openTab('subject-tab');
        });
        
        document.getElementById('assign-tab-btn').addEventListener('click', function() {
            openTab('assign-tab');
        });
        
        document.getElementById('view-tab-btn').addEventListener('click', function() {
            openTab('view-tab');
        });
    });
    
    // Form validation
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const requiredFields = form.querySelectorAll('[required]');
            let valid = true;
            
            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    valid = false;
                    field.classList.add('border-red-500');
                } else {
                    field.classList.remove('border-red-500');
                }
            });
            
            if (!valid) {
                e.preventDefault();
                alert('Please fill in all required fields');
            }
        });
    });
    
    // Modal functions
    function openEditSubjectModal(id, name, description) {
        document.getElementById('edit_subject_id').value = id;
        document.getElementById('edit_subject_name').value = name;
        document.getElementById('edit_description').value = description || '';
        
        document.getElementById('editSubjectModal').classList.remove('hidden');
    }
    
    function closeModal(modalId) {
        document.getElementById(modalId).classList.add('hidden');
    }
    
    // Delete confirmation
    let deleteType = '';
    let deleteId = 0;
    
    function confirmDelete(type, id, name) {
        deleteType = type;
        deleteId = id;
        
        const message = `Are you sure you want to delete the subject "${name}"? This action cannot be undone.`;
        document.getElementById('deleteMessage').textContent = message;
        document.getElementById('deleteModal').classList.remove('hidden');
    }
    
    function proceedDelete() {
        window.location.href = `?action=delete&type=${deleteType}&id=${deleteId}`;
    }
    
    // Assignment deletion
    let assignmentId = 0;
    
    function confirmDeleteAssignment(id, subjectName, teacherName) {
        assignmentId = id;
        
        const message = `Are you sure you want to remove ${teacherName} from teaching ${subjectName}?`;
        document.getElementById('deleteAssignmentMessage').textContent = message;
        document.getElementById('deleteAssignmentModal').classList.remove('hidden');
    }
    
    function proceedDeleteAssignment() {
        window.location.href = `?action=delete&type=assignment&id=${assignmentId}`;
    }
    
    // Close modals when clicking outside
    document.addEventListener('click', function(event) {
        const modals = document.querySelectorAll('[id$="Modal"]');
        modals.forEach(modal => {
            if (event.target === modal) {
                modal.classList.add('hidden');
            }
        });
    });
</script>

<?php
include 'include/footer.php';
// Close database connection
mysqli_close($conn);
?>