<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Fetch all classes for the filter dropdown
$classes_query = "SELECT id, class_name FROM classes WHERE status = 'active' ORDER BY class_name";
$classes_result = mysqli_query($conn, $classes_query);

// Fetch sections based on selected class
$sections = [];
if (isset($_GET['class_filter']) && !empty($_GET['class_filter'])) {
    $class_id = mysqli_real_escape_string($conn, $_GET['class_filter']);
    $sections_query = "SELECT id, section_name FROM sections WHERE class_id = $class_id AND status = 'active' ORDER BY section_name";
    $sections_result = mysqli_query($conn, $sections_query);
    while ($section = mysqli_fetch_assoc($sections_result)) {
        $sections[] = $section;
    }
}

// Handle delete operation
if (isset($_GET['delete_id'])) {
    $delete_id = mysqli_real_escape_string($conn, $_GET['delete_id']);
    
    // Get teacher image file
    $query = "SELECT image FROM users WHERE id = $delete_id AND role='teacher'";
    $result = mysqli_query($conn, $query);
    $teacher = mysqli_fetch_assoc($result);
    
    if ($teacher && $teacher['image'] && file_exists($teacher['image'])) {
        unlink($teacher['image']);
    }
    
    // Delete teacher record
    $query = "DELETE FROM users WHERE id = $delete_id AND role='teacher'";
    if (mysqli_query($conn, $query)) {
        $_SESSION['message'] = "Teacher deleted successfully";
        $_SESSION['message_type'] = "success";
    } else {
        $_SESSION['message'] = "Error deleting teacher: " . mysqli_error($conn);
        $_SESSION['message_type'] = "error";
    }
    
    // Preserve filter parameters in redirect
    $filter_params = '';
    if (!empty($_GET['class_filter'])) $filter_params .= '&class_filter=' . $_GET['class_filter'];
    if (!empty($_GET['section_filter'])) $filter_params .= '&section_filter=' . $_GET['section_filter'];
    if (!empty($_GET['search'])) $filter_params .= '&search=' . urlencode($_GET['search']);
    
    header('Location: teachers.php?' . ltrim($filter_params, '&'));
    exit();
}

// Handle Excel export
if (isset($_GET['export_excel'])) {
    $export_query = "SELECT u.* 
                     FROM users u
                     WHERE u.role = 'teacher'";
    
    if (!empty($_GET['class_filter'])) {
        $class_filter = mysqli_real_escape_string($conn, $_GET['class_filter']);
        $export_query .= " AND FIND_IN_SET('$class_filter', u.classes) > 0";
    }
    
    if (!empty($_GET['section_filter'])) {
        $section_filter = mysqli_real_escape_string($conn, $_GET['section_filter']);
        $export_query .= " AND FIND_IN_SET('$section_filter', u.sections) > 0";
    }
    
    if (!empty($_GET['search'])) {
        $search = mysqli_real_escape_string($conn, $_GET['search']);
        $export_query .= " AND (u.full_name LIKE '%$search%' OR u.teacher_id LIKE '%$search%' OR u.email LIKE '%$search%' OR u.phone LIKE '%$search%' OR u.subjects LIKE '%$search%')";
    }
    
    $export_query .= " ORDER BY u.created_at DESC";
    $result = mysqli_query($conn, $export_query);
    
    // Set headers for Excel
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="teachers_export_' . date('Y-m-d') . '.xls"');
    
    echo "ID\tTeacher ID\tFull Name\tEmail\tPhone\tSubjects\tClasses\tSections\tStatus\tCreated At\n";
    
    if (mysqli_num_rows($result) > 0) {
        while ($teacher = mysqli_fetch_assoc($result)) {
            // Class names
            $class_names = [];
            if (!empty($teacher['classes'])) {
                $class_ids = explode(',', $teacher['classes']);
                $class_ids_str = implode(',', array_filter($class_ids));
                if (!empty($class_ids_str)) {
                    $class_result = mysqli_query($conn, "SELECT class_name FROM classes WHERE id IN ($class_ids_str)");
                    while ($c = mysqli_fetch_assoc($class_result)) $class_names[] = $c['class_name'];
                }
            }
            // Section names
            $section_names = [];
            if (!empty($teacher['sections'])) {
                $section_ids = explode(',', $teacher['sections']);
                $section_ids_str = implode(',', array_filter($section_ids));
                if (!empty($section_ids_str)) {
                    $section_result = mysqli_query($conn, "SELECT section_name FROM sections WHERE id IN ($section_ids_str)");
                    while ($s = mysqli_fetch_assoc($section_result)) $section_names[] = $s['section_name'];
                }
            }
            echo $teacher['id'] . "\t" .
                 $teacher['teacher_id'] . "\t" .
                 $teacher['full_name'] . "\t" .
                 $teacher['email'] . "\t" .
                 $teacher['phone'] . "\t" .
                 $teacher['subjects'] . "\t" .
                 implode(', ', $class_names) . "\t" .
                 implode(', ', $section_names) . "\t" .
                 $teacher['status'] . "\t" .
                 $teacher['created_at'] . "\n";
        }
    }
    exit();
}

// Initialize filters
$search = isset($_GET['search']) ? mysqli_real_escape_string($conn, $_GET['search']) : '';
$class_filter = isset($_GET['class_filter']) ? mysqli_real_escape_string($conn, $_GET['class_filter']) : '';
$section_filter = isset($_GET['section_filter']) ? mysqli_real_escape_string($conn, $_GET['section_filter']) : '';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 10;

if ($page < 1) $page = 1;

// Build base query
$base_query = "FROM users u WHERE u.role='teacher'";
if (!empty($search)) {
    $base_query .= " AND (u.full_name LIKE '%$search%' OR u.teacher_id LIKE '%$search%' OR u.email LIKE '%$search%' OR u.phone LIKE '%$search%' OR u.subjects LIKE '%$search%')";
}
if (!empty($class_filter)) {
    $base_query .= " AND FIND_IN_SET('$class_filter', u.classes) > 0";
}
if (!empty($section_filter)) {
    $base_query .= " AND FIND_IN_SET('$section_filter', u.sections) > 0";
}

// Pagination
$count_query = "SELECT COUNT(*) as total $base_query";
$count_result = mysqli_query($conn, $count_query);
$total_records = mysqli_fetch_assoc($count_result)['total'];
$total_pages = ceil($total_records / $per_page);
if ($page > $total_pages && $total_pages > 0) $page = $total_pages;
$offset = max(0, ($page - 1) * $per_page);

// Fetch teachers
$query = "SELECT u.* $base_query ORDER BY u.created_at DESC LIMIT $offset, $per_page";
$result = mysqli_query($conn, $query);

$teachers = [];
if (mysqli_num_rows($result) > 0) {
    while ($teacher = mysqli_fetch_assoc($result)) {
        // Class names
        $class_names = [];
        if (!empty($teacher['classes'])) {
            $class_ids = explode(',', $teacher['classes']);
            $class_ids_str = implode(',', array_filter($class_ids));
            if (!empty($class_ids_str)) {
                $class_result = mysqli_query($conn, "SELECT class_name FROM classes WHERE id IN ($class_ids_str)");
                while ($c = mysqli_fetch_assoc($class_result)) $class_names[] = $c['class_name'];
            }
        }
        $teacher['class_names'] = implode(', ', $class_names);
        
        // Section names
        $section_names = [];
        if (!empty($teacher['sections'])) {
            $section_ids = explode(',', $teacher['sections']);
            $section_ids_str = implode(',', array_filter($section_ids));
            if (!empty($section_ids_str)) {
                $section_result = mysqli_query($conn, "SELECT section_name FROM sections WHERE id IN ($section_ids_str)");
                while ($s = mysqli_fetch_assoc($section_result)) $section_names[] = $s['section_name'];
            }
        }
        $teacher['section_names'] = implode(', ', $section_names);
        
        $teachers[] = $teacher;
    }
}
ob_end_flush();
?>

<div class="bg-white p-6 ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Teachers List</h2>
        <a href="add_teacher.php" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 flex items-center">
            <i class="fas fa-plus mr-2"></i> Add New Teacher
        </a>
    </div>

    <?php if (isset($_SESSION['message'])): ?>
        <div class="<?php echo $_SESSION['message_type'] == 'success' ? 'bg-green-100 border-green-400 text-green-700' : 'bg-red-100 border-red-400 text-red-700'; ?> border px-4 py-3 rounded mb-4">
            <?php 
            echo $_SESSION['message']; 
            unset($_SESSION['message']);
            unset($_SESSION['message_type']);
            ?>
        </div>
    <?php endif; ?>

    <!-- Filter and Search Section -->
    <div class="mb-6 bg-gray-50 p-4 ">
        <form method="GET" action="" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <!-- Class Filter -->
         
     
            <!-- Search Input -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                <input type="text" name="search" value="<?php echo htmlspecialchars($search); ?>" 
                    placeholder="Search teachers..." 
                    class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <!-- Buttons -->
            <div class="flex items-end space-x-2">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 flex items-center h-10">
                    <i class="fas fa-filter mr-2"></i> Apply Filters
                </button>
                <a href="teachers.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 flex items-center h-10">
                    <i class="fas fa-times mr-2"></i> Clear
                </a>
            </div>
        </form>
    </div>

    <!-- Search and Export Section -->
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
        <!-- Results Count -->
        <div class="text-sm text-gray-600">
            <?php if (!empty($search) || !empty($class_filter) || !empty($section_filter)): ?>
                Found <?php echo $total_records; ?> teacher(s)
                <?php if (!empty($search)): ?> matching "<?php echo htmlspecialchars($search); ?>"<?php endif; ?>
                <?php if (!empty($class_filter)): ?> in selected class<?php endif; ?>
                <?php if (!empty($section_filter)): ?> and section<?php endif; ?>
            <?php else: ?>
                Total <?php echo $total_records; ?> teacher(s)
            <?php endif; ?>
        </div>
        
        <!-- Export Button -->
        <a href="export_teacher.php?<?php 
    echo !empty($search) ? 'search=' . urlencode($search) . '&' : ''; 
    echo !empty($class_filter) ? 'class_filter=' . urlencode($class_filter) . '&' : ''; 
    echo !empty($section_filter) ? 'section_filter=' . urlencode($section_filter) : ''; 
?>" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 flex items-center">
    <i class="fas fa-file-excel mr-2"></i> Export to Excel
</a>

    </div>

    <div class="overflow-x-auto">
        <table class="min-w-full bg-white">
            <thead class="bg-gray-200 text-gray-700">
                <tr>
                    <th class="py-3 px-4 text-left">Teacher ID</th>
                    <th class="py-3 px-4 text-left">Full Name</th>
                    <th class="py-3 px-4 text-left">Email</th>
                    <th class="py-3 px-4 text-left">Phone</th>
                    <th class="py-3 px-4 text-left">Subjects</th>
                  
                    <th class="py-3 px-4 text-left">Status</th>
                    <th class="py-3 px-4 text-left">Actions</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <?php if (count($teachers) > 0): ?>
                    <?php foreach ($teachers as $teacher): ?>
                        <tr class="border-b border-gray-200 hover:bg-gray-50">
                            <td class="py-3 px-4"><?php echo $teacher['teacher_id']; ?></td>
                            <td class="py-3 px-4"><?php echo $teacher['full_name']; ?></td>
                            <td class="py-3 px-4"><?php echo $teacher['email']; ?></td>
                            <td class="py-3 px-4"><?php echo $teacher['phone']; ?></td>
                            <td class="py-3 px-4"><?php echo $teacher['subjects']; ?></td>
                            
                            <td class="py-3 px-4">
                                <?php if ($teacher['status'] == 'active'): ?>
                                    <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 ">Active</span>
                                <?php elseif ($teacher['status'] == 'banned'): ?>
                                    <span class="bg-red-100 text-red-800 text-xs font-medium px-2.5 py-0.5 ">Banned</span>
                                <?php endif; ?>
                            </td>
                            <td class="py-3 px-4">
                                <div class="flex space-x-2">
                                    <a href="view_teacher.php?id=<?php echo $teacher['id']; ?>" class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded" title="View">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="edit_teacher.php?id=<?php echo $teacher['id']; ?>" class="bg-yellow-500 hover:bg-yellow-600 text-white px-3 py-1 rounded" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="teachers.php?delete_id=<?php echo $teacher['id']; 
                                        if (!empty($class_filter)) echo '&class_filter=' . $class_filter;
                                        if (!empty($section_filter)) echo '&section_filter=' . $section_filter;
                                        if (!empty($search)) echo '&search=' . urlencode($search);
                                        ?>" class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded" title="Delete" onclick="return confirm('Are you sure you want to delete this teacher?');">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="9" class="py-4 px-4 text-center">
                            <?php if (!empty($search) || !empty($class_filter) || !empty($section_filter)): ?>
                                No teachers found with the current filters.
                                <a href="teachers.php" class="text-blue-600 hover:underline">View all teachers</a>
                            <?php else: ?>
                                No teachers found. <a href="add_teacher.php" class="text-blue-600 hover:underline">Add a new teacher</a>.
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <?php if ($total_pages > 1): ?>
    <div class="flex justify-center mt-6">
        <nav class="inline-flex  ">
            <!-- Previous Page Link -->
            <?php if ($page > 1): ?>
                <a href="?page=<?php echo $page - 1; 
                    echo !empty($search) ? '&search=' . urlencode($search) : ''; 
                    echo !empty($class_filter) ? '&class_filter=' . $class_filter : ''; 
                    echo !empty($section_filter) ? '&section_filter=' . $section_filter : ''; 
                ?>" class="py-2 px-4 border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50 rounded-l-md">
                    <i class="fas fa-chevron-left"></i>
                </a>
            <?php else: ?>
                <span class="py-2 px-4 border border-gray-300 bg-gray-100 text-sm font-medium text-gray-400 rounded-l-md">
                    <i class="fas fa-chevron-left"></i>
                </span>
            <?php endif; ?>

            <!-- Page Numbers -->
            <?php 
            // Calculate start and end of pagination links
            $start = max(1, $page - 2);
            $end = min($total_pages, $start + 4);
            $start = max(1, $end - 4);
            
            for ($i = $start; $i <= $end; $i++): 
            ?>
                <?php if ($i == $page): ?>
                    <span class="py-2 px-4 border border-gray-300 bg-blue-600 text-white text-sm font-medium">
                        <?php echo $i; ?>
                    </span>
                <?php else: ?>
                    <a href="?page=<?php echo $i; 
                        echo !empty($search) ? '&search=' . urlencode($search) : ''; 
                        echo !empty($class_filter) ? '&class_filter=' . $class_filter : ''; 
                        echo !empty($section_filter) ? '&section_filter=' . $section_filter : ''; 
                    ?>" class="py-2 px-4 border border-gray-300 bg-white text-sm font-medium text-gray-700 hover:bg-gray-50">
                        <?php echo $i; ?>
                    </a>
                <?php endif; ?>
            <?php endfor; ?>

            <!-- Next Page Link -->
            <?php if ($page < $total_pages): ?>
                <a href="?page=<?php echo $page + 1; 
                    echo !empty($search) ? '&search=' . urlencode($search) : ''; 
                    echo !empty($class_filter) ? '&class_filter=' . $class_filter : ''; 
                    echo !empty($section_filter) ? '&section_filter=' . $section_filter : ''; 
                ?>" class="py-2 px-4 border border-gray-300 bg-white text-sm font-medium text-gray-500 hover:bg-gray-50 ">
                    <i class="fas fa-chevron-right"></i>
                </a>
            <?php else: ?>
                <span class="py-2 px-4 border border-gray-300 bg-gray-100 text-sm font-medium text-gray-400 ">
                    <i class="fas fa-chevron-right"></i>
                </span>
            <?php endif; ?>
        </nav>
    </div>
    <?php endif; ?>
</div>

<script>
// JavaScript to handle dynamic section loading based on class selection
document.getElementById('class_filter').addEventListener('change', function() {
    const classId = this.value;
    const sectionSelect = document.getElementById('section_filter');
    
    if (classId) {
        // Enable section dropdown
        sectionSelect.disabled = false;
        
        // Fetch sections for the selected class via AJAX
        fetch('get_section.php?class_id=' + classId)
            .then(response => response.json())
            .then(sections => {
                // Clear existing options except the first one
                while (sectionSelect.options.length > 1) {
                    sectionSelect.remove(1);
                }
                
                // Add new options
                sections.forEach(section => {
                    const option = document.createElement('option');
                    option.value = section.id;
                    option.textContent = section.section_name;
                    sectionSelect.appendChild(option);
                });
            })
            .catch(error => console.error('Error fetching sections:', error));
    } else {
        // Disable and clear section dropdown if no class is selected
        sectionSelect.disabled = true;
        while (sectionSelect.options.length > 1) {
            sectionSelect.remove(1);
        }
    }
});
</script>

<?php
include 'include/footer.php';
mysqli_close($conn);
?>