<?php
// test_paystack_api.php
session_start();
if (!isset($_SESSION['user_id'])) {
    die("Please login first");
}

$paystack_secret = "sk_test_e961ecf6ab503d4b5d63853a2dfc0c9ec6ac78e6";

echo "<h2>Testing Paystack API Key</h2>";

// Test 1: Basic connection test
echo "<h3>Test 1: Basic Connection</h3>";
$test_ch = curl_init();
curl_setopt_array($test_ch, [
    CURLOPT_URL => "https://api.paystack.co",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 10,
    CURLOPT_SSL_VERIFYPEER => false
]);
$result = curl_exec($test_ch);

if ($result === false) {
    echo "❌ HTTPS Connection FAILED: " . curl_error($test_ch);
} else {
    echo "✅ HTTPS Connection SUCCESSFUL";
}
curl_close($test_ch);

// Test 2: Test API key with transaction list
echo "<h3>Test 2: API Key Validation</h3>";
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => "https://api.paystack.co/transaction",
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $paystack_secret",
    ],
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_TIMEOUT => 10
]);

$response = curl_exec($ch);
$err = curl_error($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

echo "HTTP Status Code: " . $http_code . "<br>";

if ($err) {
    echo "❌ cURL Error: " . $err;
} else {
    $res = json_decode($response, true);
    if (isset($res['status']) && $res['status']) {
        echo "✅ API Key is VALID";
        echo "<pre>Response: " . json_encode($res, JSON_PRETTY_PRINT) . "</pre>";
    } else {
        echo "❌ API Key is INVALID";
        echo "<pre>Error: " . $response . "</pre>";
    }
}
curl_close($ch);

// Test 3: Test payment initialization with minimal data
echo "<h3>Test 3: Payment Initialization Test</h3>";
$test_fields = [
    'email' => 'test@example.com',
    'amount' => 10000, // ₦100
    'reference' => 'TEST_' . uniqid(),
    'callback_url' => 'https://adinoheightschool.com/admin/payment_callback.php'
];

$test_ch = curl_init();
curl_setopt_array($test_ch, [
    CURLOPT_URL => "https://api.paystack.co/transaction/initialize",
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($test_fields),
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $paystack_secret",
        "Content-Type: application/json",
    ],
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_TIMEOUT => 10
]);

$test_response = curl_exec($test_ch);
$test_err = curl_error($test_ch);
$test_http_code = curl_getinfo($test_ch, CURLINFO_HTTP_CODE);

echo "HTTP Status Code: " . $test_http_code . "<br>";

if ($test_err) {
    echo "❌ Payment Test FAILED: " . $test_err;
} else {
    $test_res = json_decode($test_response, true);
    if ($test_res['status']) {
        echo "✅ Payment Test SUCCESSFUL";
        echo "<br>Authorization URL: " . $test_res['data']['authorization_url'];
        echo "<pre>Full Response: " . json_encode($test_res, JSON_PRETTY_PRINT) . "</pre>";
    } else {
        echo "❌ Payment Test FAILED";
        echo "<br>Error: " . ($test_res['message'] ?? 'Unknown error');
        echo "<pre>Full Response: " . $test_response . "</pre>";
    }
}
curl_close($test_ch);
?>