<?php
include 'include/header.php';
include '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$admin_id = $_SESSION['user_id'];
$admin_name = $_SESSION['user_name'];

$success = '';
$error = '';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Add Time Slot
    if (isset($_POST['add_time_slot'])) {
        $start_time = mysqli_real_escape_string($conn, $_POST['start_time']);
        $end_time = mysqli_real_escape_string($conn, $_POST['end_time']);
        $period_name = mysqli_real_escape_string($conn, $_POST['period_name']);
        
        if (empty($start_time) || empty($end_time)) {
            $error = "Start time and end time are required";
        } else {
            $check_query = "SELECT * FROM time_slots WHERE 
                          (start_time <= '$start_time' AND end_time > '$start_time') OR
                          (start_time < '$end_time' AND end_time >= '$end_time') OR
                          ('$start_time' <= start_time AND '$end_time' > start_time)";
            
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "Time slot overlaps with an existing time slot";
            } else {
                $insert_query = "INSERT INTO time_slots (period_name, start_time, end_time, created_by) 
                                VALUES ('$period_name', '$start_time', '$end_time', '$admin_id')";
                
                if (mysqli_query($conn, $insert_query)) {
                    $success = "Time slot added successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        }
    }
    
    // Assign Class Schedule
    if (isset($_POST['assign_schedule'])) {
        $class_id = mysqli_real_escape_string($conn, $_POST['class_id']);
        $section_id = mysqli_real_escape_string($conn, $_POST['section_id']);
        $subject_id = mysqli_real_escape_string($conn, $_POST['subject_id']);
        $teacher_id = mysqli_real_escape_string($conn, $_POST['teacher_id']);
        $time_slot_id = mysqli_real_escape_string($conn, $_POST['time_slot_id']);
        $day_of_week = mysqli_real_escape_string($conn, $_POST['day_of_week']);
        
        if (empty($class_id) || empty($section_id) || empty($subject_id) || 
            empty($teacher_id) || empty($time_slot_id) || empty($day_of_week)) {
            $error = "All fields are required";
        } else {
            $check_query = "SELECT * FROM class_schedules 
                           WHERE class_id='$class_id' 
                           AND section_id='$section_id' 
                           AND time_slot_id='$time_slot_id' 
                           AND day_of_week='$day_of_week'";
            
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "This time slot is already assigned to this class-section on the selected day";
            } else {
                $teacher_check = "SELECT * FROM class_schedules 
                                 WHERE teacher_id='$teacher_id' 
                                 AND time_slot_id='$time_slot_id' 
                                 AND day_of_week='$day_of_week'";
                
                $teacher_result = mysqli_query($conn, $teacher_check);
                
                if (mysqli_num_rows($teacher_result) > 0) {
                    $error = "This teacher is already assigned to another class at this time";
                } else {
                    $insert_query = "INSERT INTO class_schedules 
                                    (class_id, section_id, subject_id, teacher_id, time_slot_id, day_of_week, created_by) 
                                    VALUES ('$class_id', '$section_id', '$subject_id', '$teacher_id', 
                                            '$time_slot_id', '$day_of_week', '$admin_id')";
                    
                    if (mysqli_query($conn, $insert_query)) {
                        $success = "Class schedule assigned successfully!";
                    } else {
                        $error = "Error: " . mysqli_error($conn);
                    }
                }
            }
        }
    }
    
    // Edit Time Slot
    if (isset($_POST['edit_time_slot'])) {
        $time_slot_id = mysqli_real_escape_string($conn, $_POST['time_slot_id']);
        $start_time = mysqli_real_escape_string($conn, $_POST['start_time']);
        $end_time = mysqli_real_escape_string($conn, $_POST['end_time']);
        $period_name = mysqli_real_escape_string($conn, $_POST['period_name']);
        
        if (empty($start_time) || empty($end_time)) {
            $error = "Start time and end time are required";
        } else {
            $check_query = "SELECT * FROM time_slots WHERE 
                          id != '$time_slot_id' AND
                          ((start_time <= '$start_time' AND end_time > '$start_time') OR
                          (start_time < '$end_time' AND end_time >= '$end_time') OR
                          ('$start_time' <= start_time AND '$end_time' > start_time))";
            
            $check_result = mysqli_query($conn, $check_query);
            
            if (mysqli_num_rows($check_result) > 0) {
                $error = "Time slot overlaps with an existing time slot";
            } else {
                $update_query = "UPDATE time_slots SET 
                                period_name='$period_name', 
                                start_time='$start_time', 
                                end_time='$end_time' 
                                WHERE id='$time_slot_id'";
                
                if (mysqli_query($conn, $update_query)) {
                    $success = "Time slot updated successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        }
    }
}

// Handle delete actions
if (isset($_GET['action']) && isset($_GET['type']) && isset($_GET['id'])) {
    $action = $_GET['action'];
    $type = $_GET['type'];
    $id = $_GET['id'];
    
    if ($action == 'delete') {
        if ($type == 'time_slot') {
            $check_assignments = "SELECT * FROM class_schedules WHERE time_slot_id='$id'";
            $assignment_result = mysqli_query($conn, $check_assignments);
            
            if (mysqli_num_rows($assignment_result) > 0) {
                $error = "Cannot delete time slot. It has class assignments.";
            } else {
                $delete_query = "DELETE FROM time_slots WHERE id='$id'";
                if (mysqli_query($conn, $delete_query)) {
                    $success = "Time slot deleted successfully!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        } elseif ($type == 'schedule') {
            $delete_query = "DELETE FROM class_schedules WHERE id='$id'";
            if (mysqli_query($conn, $delete_query)) {
                $success = "Class schedule removed successfully!";
            } else {
                $error = "Error: " . mysqli_error($conn);
            }
        }
    }
}

// Fetch data for dropdowns and tables
$time_slot_query = "SELECT * FROM time_slots ORDER BY start_time";
$time_slot_result = mysqli_query($conn, $time_slot_query);

$class_query = "SELECT id, class_name FROM classes WHERE status='active' ORDER BY id";
$class_result = mysqli_query($conn, $class_query);

$subject_query = "SELECT id, subject_name FROM subjects WHERE status='active' ORDER BY subject_name";
$subject_result = mysqli_query($conn, $subject_query);

// ✅ FIXED: teachers now come from users
$teacher_query = "SELECT id, full_name FROM users WHERE role='teacher' AND status='active' ORDER BY full_name";
$teacher_result = mysqli_query($conn, $teacher_query);

// ✅ FIXED: schedules now join users instead of teachers
$schedule_query = "SELECT cs.id, c.class_name, s.section_name, sub.subject_name, 
                  u.full_name AS teacher_name, ts.period_name, ts.start_time, ts.end_time, 
                  cs.day_of_week, cs.created_at, cs.time_slot_id, cs.class_id, cs.section_id
                  FROM class_schedules cs 
                  JOIN classes c ON cs.class_id = c.id 
                  JOIN sections s ON cs.section_id = s.id 
                  JOIN subjects sub ON cs.subject_id = sub.id 
                  JOIN users u ON cs.teacher_id = u.id AND u.role='teacher'
                  JOIN time_slots ts ON cs.time_slot_id = ts.id 
                  ORDER BY c.class_name, s.section_name, cs.day_of_week, ts.start_time";
$schedule_result = mysqli_query($conn, $schedule_query);

// Days of week for dropdown
$days_of_week = [
    'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'
];

// Fetch all time slots for the timetable
$time_slots_timetable_query = "SELECT * FROM time_slots ORDER BY start_time";
$time_slots_timetable_result = mysqli_query($conn, $time_slots_timetable_query);
$all_time_slots = [];
while($time_slot = mysqli_fetch_assoc($time_slots_timetable_result)) {
    $all_time_slots[] = $time_slot;
}

// Group schedules by class and section for timetable display
$grouped_schedules = [];
if (mysqli_num_rows($schedule_result) > 0) {
    mysqli_data_seek($schedule_result, 0);
    while($schedule = mysqli_fetch_assoc($schedule_result)) {
        $key = $schedule['class_name'] . ' - ' . $schedule['section_name'];
        $grouped_schedules[$key][] = $schedule;
    }
}

// Get class and section data for filtering
$class_data = [];
$class_result_data = mysqli_query($conn, "SELECT id, class_name FROM classes ORDER BY id");
while($class = mysqli_fetch_assoc($class_result_data)) {
    $class_data[$class['id']] = $class['class_name'];
}

$section_data = [];
$section_result_data = mysqli_query($conn, "SELECT id, section_name, class_id FROM sections ORDER BY class_id, id");
while($section = mysqli_fetch_assoc($section_result_data)) {
    $section_data[$section['id']] = [
        'name' => $section['section_name'],
        'class_id' => $section['class_id']
    ];
}
?>


<div class="bg-white p-6  ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Time Table Management</h2>
        <button onclick="openTab('time-tab')" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2  flex items-center">
            <i class="fas fa-plus mr-2"></i> Add New Time Slot
        </button>
    </div>

    <?php if (!empty($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <i class="fas fa-check-circle mr-2"></i> <?php echo $success; ?>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <i class="fas fa-exclamation-circle mr-2"></i> <?php echo $error; ?>
        </div>
    <?php endif; ?>
    
    <div class="flex border-b border-gray-200 mb-6">
        <button id="time-tab-btn" class="px-4 py-2 font-medium text-blue-600 border-b-2 border-blue-600 focus:outline-none">
            <i class="fas fa-clock mr-2"></i> Time Slots
        </button>
        <button id="schedule-tab-btn" class="px-4 py-2 font-medium text-gray-600 hover:text-blue-600 focus:outline-none">
            <i class="fas fa-calendar-alt mr-2"></i> Assign Schedule
        </button>
        <button id="timetable-tab-btn" class="px-4 py-2 font-medium text-gray-600 hover:text-blue-600 focus:outline-none">
            <i class="fas fa-table mr-2"></i> View Time Table
        </button>
    </div>
    
    <!-- Time Slot Management Tab -->
    <div id="time-tab" class="tab-content">
        <div class="bg-white p-6   mb-6">
            <h3 class="text-lg font-medium text-gray-800 mb-4"><i class="fas fa-plus-circle mr-2"></i> Add New Time Slot</h3>
            <form method="POST">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                    <div>
                        <label for="period_name" class="block text-sm font-medium text-gray-700 mb-1">Period Name</label>
                        <input type="text" id="period_name" name="period_name" 
                               placeholder="e.g., Period 1, Morning Session, etc."
                               class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <div>
                        <label for="start_time" class="block text-sm font-medium text-gray-700 mb-1">Start Time <span class="text-red-500">*</span></label>
                        <input type="time" id="start_time" name="start_time" required 
                               class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <div>
                        <label for="end_time" class="block text-sm font-medium text-gray-700 mb-1">End Time <span class="text-red-500">*</span></label>
                        <input type="time" id="end_time" name="end_time" required 
                               class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                </div>
                
                <div class="text-center">
                    <button type="submit" name="add_time_slot" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 ">
                        <i class="fas fa-plus mr-2"></i> Add Time Slot
                    </button>
                </div>
            </form>
        </div>
        
        <div class="bg-white p-6  ">
            <h3 class="text-lg font-medium text-gray-800 mb-4"><i class="fas fa-list mr-2"></i> Existing Time Slots</h3>
            <?php if (mysqli_num_rows($time_slot_result) > 0): ?>
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white">
                        <thead class="bg-gray-200 text-gray-700">
                            <tr>
                                <th class="py-3 px-4 text-left">Period Name</th>
                                <th class="py-3 px-4 text-left">Start Time</th>
                                <th class="py-3 px-4 text-left">End Time</th>
                                <th class="py-3 px-4 text-left">Duration</th>
                                <th class="py-3 px-4 text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600">
                            <?php while($time_slot = mysqli_fetch_assoc($time_slot_result)): 
                                $start = new DateTime($time_slot['start_time']);
                                $end = new DateTime($time_slot['end_time']);
                                $duration = $start->diff($end);
                                $duration_str = $duration->h . 'h ' . $duration->i . 'm';
                            ?>
                                <tr class="border-b border-gray-200 hover:bg-gray-50">
                                    <td class="py-3 px-4"><?php echo htmlspecialchars($time_slot['period_name'] ?? 'N/A'); ?></td>
                                    <td class="py-3 px-4"><?php echo date('h:i A', strtotime($time_slot['start_time'])); ?></td>
                                    <td class="py-3 px-4"><?php echo date('h:i A', strtotime($time_slot['end_time'])); ?></td>
                                    <td class="py-3 px-4"><?php echo $duration_str; ?></td>
                                    <td class="py-3 px-4">
                                        <div class="flex space-x-2">
                                            <button onclick="openEditTimeSlotModal(<?php echo $time_slot['id']; ?>, '<?php echo htmlspecialchars($time_slot['period_name'] ?? ''); ?>', '<?php echo $time_slot['start_time']; ?>', '<?php echo $time_slot['end_time']; ?>')" 
                                                    class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button onclick="confirmDelete('time_slot', <?php echo $time_slot['id']; ?>, '<?php echo htmlspecialchars($time_slot['period_name'] ?? 'Time Slot'); ?>')" 
                                                    class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-8 text-gray-500">
                    <i class="fas fa-clock text-4xl mb-3"></i>
                    <p class="mb-4">No time slots found. Please add time slots using the form above.</p>
                    <button class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 " onclick="document.getElementById('start_time').focus()">
                        <i class="fas fa-plus mr-2"></i> Add Your First Time Slot
                    </button>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Assign Schedule Tab -->
    <div id="schedule-tab" class="tab-content hidden">
        <div class="bg-white p-6  ">
            <h3 class="text-lg font-medium text-gray-800 mb-4"><i class="fas fa-calendar-alt mr-2"></i> Assign Class Schedule</h3>
            <form method="POST">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <label for="class_id" class="block text-sm font-medium text-gray-700 mb-1">Class <span class="text-red-500">*</span></label>
                        <select id="class_id" name="class_id" required class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Class</option>
                            <?php 
                            $class_dropdown_result = mysqli_query($conn, $class_query);
                            while($class = mysqli_fetch_assoc($class_dropdown_result)): ?>
                                <option value="<?php echo $class['id']; ?>">
                                    <?php echo htmlspecialchars($class['class_name']); ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    
                    <div>
                        <label for="section_id" class="block text-sm font-medium text-gray-700 mb-1">Section <span class="text-red-500">*</span></label>
                        <select id="section_id" name="section_id" required class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Section</option>
                            <!-- Sections will be loaded dynamically via AJAX -->
                        </select>
                    </div>
                    
                    <div>
                        <label for="subject_id" class="block text-sm font-medium text-gray-700 mb-1">Subject <span class="text-red-500">*</span></label>
                        <select id="subject_id" name="subject_id" required class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Subject</option>
                            <?php 
                            $subject_dropdown_result = mysqli_query($conn, $subject_query);
                            while($subject = mysqli_fetch_assoc($subject_dropdown_result)): ?>
                                <option value="<?php echo $subject['id']; ?>">
                                    <?php echo htmlspecialchars($subject['subject_name']); ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    
                    <div>
                        <label for="teacher_id" class="block text-sm font-medium text-gray-700 mb-1">Teacher <span class="text-red-500">*</span></label>
                        <select id="teacher_id" name="teacher_id" required class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Teacher</option>
                            <?php 
                            $teacher_dropdown_result = mysqli_query($conn, $teacher_query);
                            while($teacher = mysqli_fetch_assoc($teacher_dropdown_result)): ?>
                                <option value="<?php echo $teacher['id']; ?>">
                                    <?php echo htmlspecialchars($teacher['full_name']); ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    
                    <div>
                        <label for="time_slot_id" class="block text-sm font-medium text-gray-700 mb-1">Time Slot <span class="text-red-500">*</span></label>
                        <select id="time_slot_id" name="time_slot_id" required class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Time Slot</option>
                            <?php 
                            $time_slot_dropdown_result = mysqli_query($conn, $time_slot_query);
                            while($time_slot = mysqli_fetch_assoc($time_slot_dropdown_result)): 
                                $start_time = date('h:i A', strtotime($time_slot['start_time']));
                                $end_time = date('h:i A', strtotime($time_slot['end_time']));
                                $display = ($time_slot['period_name']) ? 
                                    $time_slot['period_name'] . " ($start_time - $end_time)" : 
                                    "$start_time - $end_time";
                            ?>
                                <option value="<?php echo $time_slot['id']; ?>">
                                    <?php echo htmlspecialchars($display); ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    
                    <div>
                        <label for="day_of_week" class="block text-sm font-medium text-gray-700 mb-1">Day of Week <span class="text-red-500">*</span></label>
                        <select id="day_of_week" name="day_of_week" required class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Day</option>
                            <?php foreach($days_of_week as $day): ?>
                                <option value="<?php echo $day; ?>"><?php echo $day; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                
                <div class="text-center">
                    <button type="submit" name="assign_schedule" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 ">
                        <i class="fas fa-link mr-2"></i> Assign Schedule
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- View Time Table Tab -->
    <div id="timetable-tab" class="tab-content hidden">
        <div class="bg-white p-6  ">
            <h3 class="text-lg font-medium text-gray-800 mb-4"><i class="fas fa-table mr-2"></i> Class Time Table</h3>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <div>
                    <label for="view_class_id" class="block text-sm font-medium text-gray-700 mb-1">Select Class</label>
                    <select id="view_class_id" name="view_class_id" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Classes</option>
                        <?php 
                        $class_view_result = mysqli_query($conn, $class_query);
                        while($class = mysqli_fetch_assoc($class_view_result)): ?>
                            <option value="<?php echo $class['id']; ?>">
                                <?php echo htmlspecialchars($class['class_name']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                
                <div>
                    <label for="view_section_id" class="block text-sm font-medium text-gray-700 mb-1">Select Section</label>
                    <select id="view_section_id" name="view_section_id" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Sections</option>
                        <!-- Sections will be loaded dynamically via AJAX -->
                    </select>
                </div>
            </div>
            
            <div id="timetable-container">
                <?php if (!empty($grouped_schedules)): ?>
                    <?php foreach($grouped_schedules as $class_section => $schedules): 
                        // Extract class and section info for filtering
                        $class_section_parts = explode(' - ', $class_section);
                        $class_name = $class_section_parts[0];
                        $section_name = $class_section_parts[1];
                        
                        // Find class_id and section_id for this timetable
                        $class_id_filter = array_search($class_name, $class_data);
                        $section_id_filter = null;
                        foreach($section_data as $id => $section) {
                            if ($section['name'] === $section_name && $section['class_id'] == $class_id_filter) {
                                $section_id_filter = $id;
                                break;
                            }
                        }
                    ?>
                        <div class="mb-8 class-timetable" data-class-id="<?php echo $class_id_filter; ?>" data-section-id="<?php echo $section_id_filter; ?>">
                            <h4 class="text-xl font-semibold text-gray-800 mb-4"><?php echo $class_section; ?></h4>
                            <div class="overflow-x-auto">
                                <table class="min-w-full bg-white border border-gray-200">
                                    <thead class="bg-gray-100">
                                        <tr>
                                            <th class="py-3 px-4 border text-left">Time/Day</th>
                                            <?php foreach($days_of_week as $day): ?>
                                                <th class="py-3 px-4 border text-left"><?php echo $day; ?></th>
                                            <?php endforeach; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach($all_time_slots as $time_slot): 
                                            $start_time = date('h:i A', strtotime($time_slot['start_time']));
                                            $end_time = date('h:i A', strtotime($time_slot['end_time']));
                                        ?>
                                            <tr>
                                                <td class="py-3 px-4 border font-medium">
                                                    <?php echo $start_time . ' - ' . $end_time; ?>
                                                    <?php if (!empty($time_slot['period_name'])): ?>
                                                        <br><span class="text-xs text-gray-500">(<?php echo $time_slot['period_name']; ?>)</span>
                                                    <?php endif; ?>
                                                </td>
                                                <?php foreach($days_of_week as $day): 
                                                    $found = false;
                                                    foreach($schedules as $schedule) {
                                                        if ($schedule['time_slot_id'] == $time_slot['id'] && 
                                                            $schedule['day_of_week'] == $day) {
                                                            $found = $schedule;
                                                            break;
                                                        }
                                                    }
                                                ?>
                                                    <td class="py-3 px-4 border">
                                                        <?php if ($found): ?>
                                                            <div class="bg-blue-50 p-2 rounded border border-blue-100">
                                                                <div class="font-medium text-blue-800"><?php echo $found['subject_name']; ?></div>
                                                                <div class="text-sm text-blue-600"><?php echo $found['teacher_name']; ?></div>
                                                                <div class="mt-2">
                                                                    <button onclick="confirmDeleteSchedule(<?php echo $found['id']; ?>, '<?php echo htmlspecialchars($found['subject_name']); ?>')" 
                                                                            class="text-xs bg-red-500 hover:bg-red-600 text-white px-2 py-1 rounded" title="Remove">
                                                                        <i class="fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        <?php else: ?>
                                                            <span class="text-gray-400">-</span>
                                                        <?php endif; ?>
                                                    </td>
                                                <?php endforeach; ?>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="text-center py-8 text-gray-500">
                        <i class="fas fa-calendar-times text-4xl mb-3"></i>
                        <p class="mb-4">No class schedules found. Please assign schedules using the form above.</p>
                        <button class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 " onclick="openTab('schedule-tab')">
                            <i class="fas fa-calendar-alt mr-2"></i> Assign Schedules
                        </button>
                        </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Edit Time Slot Modal -->
<div id="editTimeSlotModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white   w-11/12 md:w-1/2 max-w-2xl">
        <div class="border-b px-6 py-4 flex justify-between items-center">
            <h3 class="text-lg font-medium text-gray-800">Edit Time Slot</h3>
            <button onclick="closeModal('editTimeSlotModal')" class="text-gray-500 hover:text-gray-700">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <form method="POST" id="editTimeSlotForm">
            <div class="p-6">
                <input type="hidden" name="time_slot_id" id="edit_time_slot_id">
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                    <div>
                        <label for="edit_period_name" class="block text-sm font-medium text-gray-700 mb-1">Period Name</label>
                        <input type="text" id="edit_period_name" name="period_name"
                               class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <div>
                        <label for="edit_start_time" class="block text-sm font-medium text-gray-700 mb-1">Start Time <span class="text-red-500">*</span></label>
                        <input type="time" id="edit_start_time" name="start_time" required
                               class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <div>
                        <label for="edit_end_time" class="block text-sm font-medium text-gray-700 mb-1">End Time <span class="text-red-500">*</span></label>
                        <input type="time" id="edit_end_time" name="end_time" required
                               class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                </div>
            </div>
            <div class="border-t px-6 py-4 flex justify-end space-x-3">
                <button type="button" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 " onclick="closeModal('editTimeSlotModal')">Cancel</button>
                <button type="submit" name="edit_time_slot" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 ">
                    <i class="fas fa-save mr-2"></i> Update Time Slot
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white   w-11/12 md:w-1/3 max-w-md">
        <div class="border-b px-6 py-4">
            <h3 class="text-lg font-medium text-gray-800">Confirm Delete</h3>
        </div>
        <div class="p-6">
            <p id="deleteMessage" class="text-gray-700">Are you sure you want to delete this item?</p>
        </div>
        <div class="border-t px-6 py-4 flex justify-end space-x-3">
            <button type="button" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 " onclick="closeModal('deleteModal')">Cancel</button>
            <button type="button" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 " onclick="proceedDelete()">
                <i class="fas fa-trash mr-2"></i> Delete
            </button>
        </div>
    </div>
</div>

<!-- Delete Schedule Confirmation Modal -->
<div id="deleteScheduleModal" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white   w-11/12 md:w-1/3 max-w-md">
        <div class="border-b px-6 py-4">
            <h3 class="text-lg font-medium text-gray-800">Confirm Removal</h3>
        </div>
        <div class="p-6">
            <p id="deleteScheduleMessage" class="text-gray-700">Are you sure you want to remove this schedule?</p>
        </div>
        <div class="border-t px-6 py-4 flex justify-end space-x-3">
            <button type="button" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 " onclick="closeModal('deleteScheduleModal')">Cancel</button>
            <button type="button" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 " onclick="proceedDeleteSchedule()">
                <i class="fas fa-trash mr-2"></i> Remove
            </button>
        </div>
    </div>
</div>

<script>
    // Tab navigation
    function openTab(tabId) {
        // Hide all tab contents
        const tabContents = document.querySelectorAll('.tab-content');
        tabContents.forEach(tab => tab.classList.add('hidden'));
        
        // Remove active class from all tabs
        const tabButtons = document.querySelectorAll('.flex.border-b button');
        tabButtons.forEach(btn => {
            btn.classList.remove('text-blue-600', 'border-blue-600');
            btn.classList.add('text-gray-600', 'hover:text-blue-600');
        });
        
        // Show the selected tab content and mark tab as active
        document.getElementById(tabId).classList.remove('hidden');
        
        // Update the button styles
        const activeBtn = document.getElementById(tabId + '-btn');
        if (activeBtn) {
            activeBtn.classList.remove('text-gray-600', 'hover:text-blue-600');
            activeBtn.classList.add('text-blue-600', 'border-blue-600');
        }
    }
    
    // Initialize tabs
    document.addEventListener('DOMContentLoaded', function() {
        // Set the first tab as active
        openTab('time-tab');
        
        // Add click events to tab buttons
        document.getElementById('time-tab-btn').addEventListener('click', function() {
            openTab('time-tab');
        });
        
        document.getElementById('schedule-tab-btn').addEventListener('click', function() {
            openTab('schedule-tab');
        });
        
        document.getElementById('timetable-tab-btn').addEventListener('click', function() {
            openTab('timetable-tab');
        });
        
        // Load sections when class is selected
        document.getElementById('class_id').addEventListener('change', function() {
            loadSections(this.value, 'section_id');
        });
        
        document.getElementById('view_class_id').addEventListener('change', function() {
            loadSections(this.value, 'view_section_id');
            filterTimetable();
        });
        
        // Filter timetable by class and section
        document.getElementById('view_class_id').addEventListener('change', filterTimetable);
        document.getElementById('view_section_id').addEventListener('change', filterTimetable);
    });
    
    // Function to load sections based on class selection
    function loadSections(classId, targetElementId) {
        if (!classId) {
            document.getElementById(targetElementId).innerHTML = '<option value="">Select Section</option>';
            return;
        }
        
        fetch(`get_section.php?class_id=${classId}`)
            .then(response => response.json())
            .then(sections => {
                const sectionSelect = document.getElementById(targetElementId);
                sectionSelect.innerHTML = '<option value="">Select Section</option>';
                
                sections.forEach(section => {
                    const option = document.createElement('option');
                    option.value = section.id;
                    option.textContent = section.section_name;
                    sectionSelect.appendChild(option);
                });
            })
            .catch(error => {
                console.error('Error loading sections:', error);
            });
    }
    
    function filterTimetable() {
        const classId = document.getElementById('view_class_id').value;
        const sectionId = document.getElementById('view_section_id').value;
        
        // Hide all timetables initially
        document.querySelectorAll('.class-timetable').forEach(el => {
            el.style.display = 'none';
        });
        
        // Show only the selected class-section timetable
        if (classId && sectionId) {
            // Show timetable for specific class and section
            document.querySelectorAll('.class-timetable').forEach(el => {
                const timetableClassId = el.getAttribute('data-class-id');
                const timetableSectionId = el.getAttribute('data-section-id');
                
                if (timetableClassId == classId && timetableSectionId == sectionId) {
                    el.style.display = 'block';
                }
            });
        } else if (classId) {
            // Show all sections of the selected class
            document.querySelectorAll('.class-timetable').forEach(el => {
                const timetableClassId = el.getAttribute('data-class-id');
                if (timetableClassId == classId) {
                    el.style.display = 'block';
                }
            });
        } else {
            // Show all timetables
            document.querySelectorAll('.class-timetable').forEach(el => {
                el.style.display = 'block';
            });
        }
        
        // Show message if no timetables are visible
        const visibleTimetables = document.querySelectorAll('.class-timetable[style="display: block"]');
        if (visibleTimetables.length === 0) {
            // Create a message element if it doesn't exist
            let noResultsMsg = document.getElementById('no-results-message');
            if (!noResultsMsg) {
                noResultsMsg = document.createElement('div');
                noResultsMsg.id = 'no-results-message';
                noResultsMsg.className = 'text-center py-8 text-gray-500';
                noResultsMsg.innerHTML = `
                    <i class="fas fa-search text-4xl mb-3"></i>
                    <p class="mb-4">No timetables found for the selected criteria.</p>
                `;
                document.getElementById('timetable-container').appendChild(noResultsMsg);
            }
            noResultsMsg.style.display = 'block';
        } else {
            // Hide the message if it exists
            const noResultsMsg = document.getElementById('no-results-message');
            if (noResultsMsg) {
                noResultsMsg.style.display = 'none';
            }
        }
    }
    
    // Form validation
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const requiredFields = form.querySelectorAll('[required]');
            let valid = true;
            
            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    valid = false;
                    field.classList.add('border-red-500');
                } else {
                    field.classList.remove('border-red-500');
                }
            });
            
            // Additional validation for time slots
            if (form.id === 'editTimeSlotForm' || form.querySelector('[name="add_time_slot"]')) {
                const startTime = form.querySelector('[name="start_time"]');
                const endTime = form.querySelector('[name="end_time"]');
                
                if (startTime.value && endTime.value && startTime.value >= endTime.value) {
                    valid = false;
                    alert('End time must be after start time');
                    startTime.classList.add('border-red-500');
                    endTime.classList.add('border-red-500');
                }
            }
            
            if (!valid) {
                e.preventDefault();
                alert('Please fill in all required fields correctly');
            }
        });
    });
    
    // Modal functions
    function openEditTimeSlotModal(id, name, startTime, endTime) {
        document.getElementById('edit_time_slot_id').value = id;
        document.getElementById('edit_period_name').value = name || '';
        document.getElementById('edit_start_time').value = startTime;
        document.getElementById('edit_end_time').value = endTime;
        
        document.getElementById('editTimeSlotModal').classList.remove('hidden');
    }
    
    function closeModal(modalId) {
        document.getElementById(modalId).classList.add('hidden');
    }
    
    // Delete confirmation
    let deleteType = '';
    let deleteId = 0;
    
    function confirmDelete(type, id, name) {
        deleteType = type;
        deleteId = id;
        
        const message = `Are you sure you want to delete "${name}"? This action cannot be undone.`;
        document.getElementById('deleteMessage').textContent = message;
        document.getElementById('deleteModal').classList.remove('hidden');
    }
    
    function proceedDelete() {
        window.location.href = `?action=delete&type=${deleteType}&id=${deleteId}`;
    }
    
    // Schedule deletion
    let scheduleId = 0;
    
    function confirmDeleteSchedule(id, subjectName) {
        scheduleId = id;
        
        const message = `Are you sure you want to remove the schedule for "${subjectName}"?`;
        document.getElementById('deleteScheduleMessage').textContent = message;
        document.getElementById('deleteScheduleModal').classList.remove('hidden');
    }
    
    function proceedDeleteSchedule() {
        window.location.href = `?action=delete&type=schedule&id=${scheduleId}`;
    }
    
    // Close modals when clicking outside
    document.addEventListener('click', function(event) {
        const modals = document.querySelectorAll('[id$="Modal"]');
        modals.forEach(modal => {
            if (event.target === modal) {
                modal.classList.add('hidden');
            }
        });
    });
</script>

<?php
include 'include/footer.php';
// Close database connection
mysqli_close($conn);
?>