<?php
include 'include/header.php';
include '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Check if teacher ID is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Location: teachers.php');
    exit();
}

$teacher_id = mysqli_real_escape_string($conn, $_GET['id']);

// ✅ Fetch teacher data from users table (role = teacher)
$sql = "SELECT `id`, `teacher_id`, `full_name`, `dob`, `gender`, `nationality`, `id_number`, `image`, 
               `address`, `phone`, `email`, `emergency_contact`, `emergency_phone`, `highest_degree`, 
               `university`, `graduation_year`, `specialization`, `certifications`, `subjects`, `grades`, 
               `experience`, `previous_school`, `salary_expectation`, `skills`, `languages`, `references_info`, 
               `hire_date`, `registration_date`, `created_at`, `status`, `salary`, `bank_account`, `bank_name`, 
               `medical_conditions`, `allergies`, `blood_group`, `created_by`
        FROM `users` 
        WHERE id = '$teacher_id' AND role = 'teacher'";

$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) == 0) {
    echo "<div class='bg-white p-6 rounded-lg shadow-md'>
            <div class='bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4'>
                Teacher not found.
            </div>
          </div>";
    include 'include/footer.php';
    exit();
}

$teacher = mysqli_fetch_assoc($result);

// ✅ Fetch admin name who created this record
$created_by = $teacher['created_by'] ?? null;
$admin_name = "Unknown";

if ($created_by) {
    $admin_sql = "SELECT name FROM users WHERE id = '$created_by'";
    $admin_result = mysqli_query($conn, $admin_sql);
    if (mysqli_num_rows($admin_result) > 0) {
        $admin_data = mysqli_fetch_assoc($admin_result);
        $admin_name = $admin_data['name'];
    }
}
?>


<div class="bg-white p-6 rounded-lg ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Teacher Profile</h2>
        <div class="flex space-x-2">
            <a href="edit_teacher.php?id=<?php echo $teacher_id; ?>" class="bg-yellow-500 hover:bg-yellow-600 text-white px-4 py-2 rounded-lg flex items-center">
                <i class="fas fa-edit mr-2"></i> Edit
            </a>
            <a href="teacher_table.php" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg flex items-center">
                <i class="fas fa-arrow-left mr-2"></i> Back to List
            </a>
        </div>
    </div>

    <!-- Teacher Header -->
    <div class="bg-blue-50 p-6 rounded-lg mb-6 flex items-center">
        <div class="mr-4">
            <?php if (!empty($teacher['image'])): ?>
                <img src="../uploads/<?php echo $teacher['image']; ?>" alt="<?php echo $teacher['full_name']; ?>" class="w-24 h-24 rounded-full object-cover border-4 border-white shadow">
            <?php else: ?>
                <div class="w-24 h-24 rounded-full bg-blue-100 flex items-center justify-center border-4 border-white shadow">
                    <i class="fas fa-user text-blue-400 text-3xl"></i>
                </div>
            <?php endif; ?>
        </div>
        <div>
            <h1 class="text-2xl font-bold text-gray-800"><?php echo htmlspecialchars($teacher['full_name']); ?></h1>
            <p class="text-gray-600">ID: <?php echo htmlspecialchars($teacher['teacher_id']); ?></p>
            <div class="flex items-center mt-2">
                <?php if ($teacher['status'] == 'active'): ?>
                    <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Active</span>
                <?php else: ?>
                    <span class="bg-red-100 text-red-800 text-xs font-medium px-2.5 py-0.5 rounded-full"><?php echo ucfirst($teacher['status']); ?></span>
                <?php endif; ?>
                <span class="mx-2 text-gray-400">•</span>
                <span class="text-gray-600"><i class="fas fa-book mr-1"></i> <?php echo htmlspecialchars($teacher['subjects']); ?></span>
            </div>
        </div>
    </div>

    <!-- Teacher Information in Table Format -->
    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Personal Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Date of Birth</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['dob']) ? date('F j, Y', strtotime($teacher['dob'])) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Gender</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['gender']) ? ucfirst($teacher['gender']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Nationality</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['nationality']) ? htmlspecialchars($teacher['nationality']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">ID Number</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['id_number']) ? htmlspecialchars($teacher['id_number']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Blood Group</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['blood_group']) ? htmlspecialchars($teacher['blood_group']) : 'Not provided'; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Contact Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Address</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['address']) ? htmlspecialchars($teacher['address']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Phone</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['phone']) ? htmlspecialchars($teacher['phone']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Email</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['email']) ? htmlspecialchars($teacher['email']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Emergency Contact</td>
                    <td class="py-3 px-4">
                        <?php if (!empty($teacher['emergency_contact'])): ?>
                            <?php echo htmlspecialchars($teacher['emergency_contact']); ?>
                            <?php if (!empty($teacher['emergency_phone'])): ?>
                                (<?php echo htmlspecialchars($teacher['emergency_phone']); ?>)
                            <?php endif; ?>
                        <?php else: ?>
                            Not provided
                        <?php endif; ?>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Educational Background</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Highest Degree</td>
                    <td class="py-3 px-4"><?php echo htmlspecialchars($teacher['highest_degree']); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">University</td>
                    <td class="py-3 px-4"><?php echo htmlspecialchars($teacher['university']); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Graduation Year</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['graduation_year']) ? htmlspecialchars($teacher['graduation_year']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Specialization</td>
                    <td class="py-3 px-4"><?php echo htmlspecialchars($teacher['specialization']); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Certifications</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['certifications']) ? htmlspecialchars($teacher['certifications']) : 'None provided'; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Professional Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Subjects</td>
                    <td class="py-3 px-4"><?php echo htmlspecialchars($teacher['subjects']); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Grades</td>
                    <td class="py-3 px-4"><?php echo htmlspecialchars($teacher['grades']); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Experience</td>
                    <td class="py-3 px-4"><?php echo htmlspecialchars($teacher['experience']); ?> years</td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Previous School</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['previous_school']) ? htmlspecialchars($teacher['previous_school']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Salary</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['salary']) ? htmlspecialchars($teacher['salary']) : (!empty($teacher['salary_expectation']) ? htmlspecialchars($teacher['salary_expectation']) : 'Not provided'); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Hire Date</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['hire_date']) ? date('F j, Y', strtotime($teacher['hire_date'])) : 'Not provided'; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Additional Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Skills</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['skills']) ? htmlspecialchars($teacher['skills']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Languages</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['languages']) ? htmlspecialchars($teacher['languages']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Medical Conditions</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['medical_conditions']) ? htmlspecialchars($teacher['medical_conditions']) : 'None'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Allergies</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['allergies']) ? htmlspecialchars($teacher['allergies']) : 'None'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Bank Details</td>
                    <td class="py-3 px-4">
                        <?php if (!empty($teacher['bank_account']) && !empty($teacher['bank_name'])): ?>
                            <?php echo htmlspecialchars($teacher['bank_name']); ?> - <?php echo htmlspecialchars($teacher['bank_account']); ?>
                        <?php else: ?>
                            Not provided
                        <?php endif; ?>
                    </td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">References</td>
                    <td class="py-3 px-4"><?php echo !empty($teacher['references_info']) ? nl2br(htmlspecialchars($teacher['references_info'])) : 'Not provided'; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">System Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Registration Date</td>
                    <td class="py-3 px-4"><?php echo date('F j, Y', strtotime($teacher['registration_date'])); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Registered By</td>
                    <td class="py-3 px-4"><?php echo htmlspecialchars($admin_name); ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Status</td>
                    <td class="py-3 px-4">
                        <?php if ($teacher['status'] == 'active'): ?>
                            <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Active</span>
                        <?php else: ?>
                            <span class="bg-red-100 text-red-800 text-xs font-medium px-2.5 py-0.5 rounded-full"><?php echo ucfirst($teacher['status']); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<?php include 'include/footer.php'; ?>