 <script src="js/script.js"></script>

<footer class="footer-section bg-gray-900 text-white pt-16 pb-8">
    <div class="container mx-auto px-4">
        <!-- Main Footer Content -->
        <div class="footer-content grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 mb-12">
            <!-- School Information -->
            <div class="footer-info">
                <div class="logo-container flex items-center mb-6">
                    <div class="logo mr-3">
                        <img src="img/logotwo.png" alt="Adinoheight College Logo" class="h-12">
                    </div>
                    <div class="school-name">
                        <h3 class="text-xl font-semibold">Adinoheight College</h3>
                        <p class="school-tagline text-blue-300 text-sm">Raising Role Model</p>
                    </div>
                </div>
                <p class="text-gray-300 mb-4 leading-relaxed">
                    Providing exceptional education from Early Years to College with a focus on character development and academic excellence.
                </p>
                <div class="contact-details space-y-3">
                    <div class="flex items-center">
                        <div class="contact-icon bg-blue-700 p-2 rounded-full mr-3">
                            <i class="fas fa-phone text-white text-sm"></i>
                        </div>
                        <span>08056255718</span>
                    </div>
                    <div class="flex items-center">
                        <div class="contact-icon bg-blue-700 p-2 rounded-full mr-3">
                            <i class="fas fa-envelope text-white text-sm"></i>
                        </div>
                        <span>info@adinoheightschool.com</span>
                    </div>
                    <div class="flex items-center">
                        <div class="contact-icon bg-blue-700 p-2 rounded-full mr-3">
                            <i class="fas fa-map-marker-alt text-white text-sm"></i>
                        </div>
                        <span>Ogun, Nigeria</span>
                    </div>
                </div>
            </div>

            <!-- Quick Links -->
            <div class="quick-links">
                <h3 class="text-lg font-semibold mb-6 relative pb-2 after:absolute after:left-0 after:bottom-0 after:w-12 after:h-0.5 after:bg-blue-500">Quick Links</h3>
                <ul class="space-y-3">
                    <li><a href="index" class="text-gray-300 hover:text-blue-300 transition-colors">Home</a></li>
                    <li><a href="about" class="text-gray-300 hover:text-blue-300 transition-colors">About Us</a></li>
                    <li><a href="admission" class="text-gray-300 hover:text-blue-300 transition-colors">Admission Process</a></li>
                  
                    <li><a href="event" class="text-gray-300 hover:text-blue-300 transition-colors">Events</a></li>
                    <li><a href="gallery" class="text-gray-300 hover:text-blue-300 transition-colors">Gallery</a></li>
                    <li><a href="contact" class="text-gray-300 hover:text-blue-300 transition-colors">Contact Us</a></li>
                </ul>
            </div>

            <!-- Academic Programs -->
            <div class="academic-programs">
                <h3 class="text-lg font-semibold mb-6 relative pb-2 after:absolute after:left-0 after:bottom-0 after:w-12 after:h-0.5 after:bg-blue-500">Academic Programs</h3>
                <ul class="space-y-3">
                    <li><a href="creche" class="text-gray-300 hover:text-blue-300 transition-colors">Early Years </a></li>
                    <li><a href="primary" class="text-gray-300 hover:text-blue-300 transition-colors">Primary School </a></li>
                    <li><a href="secondary" class="text-gray-300 hover:text-blue-300 transition-colors">Secondary School </a></li>
                    <li><a href="college" class="text-gray-300 hover:text-blue-300 transition-colors">College Preparation</a></li>
                    
                </ul>
            </div>

            <!-- Newsletter & Social Media -->
            <div class="newsletter-social">
                <h3 class="text-lg font-semibold mb-6 relative pb-2 after:absolute after:left-0 after:bottom-0 after:w-12 after:h-0.5 after:bg-blue-500">Stay Connected</h3>
                
               <?php

// Database connection
include 'config/conn.php';

// Initialize message variables
$message = '';
$message_type = ''; // success, error, warning

// Newsletter subscription processing
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['subscribe_email'])) {
    // Validate email
    $email = filter_var($_POST['subscribe_email'], FILTER_SANITIZE_EMAIL);
    
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = "Invalid email address.";
        $message_type = "error";
    } else {
        // Check connection
        if ($conn->connect_error) {
            $message = "Database connection failed.";
            $message_type = "error";
        } else {
            // Check if already subscribed using prepared statement
            $stmt = $conn->prepare("SELECT id FROM newsletter WHERE email = ?");
            if ($stmt) {
                $stmt->bind_param("s", $email);
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ($result->num_rows > 0) {
                    $message = "You are already subscribed!";
                    $message_type = "warning";
                } else {
                    // Insert using prepared statement
                    $insert_stmt = $conn->prepare("INSERT INTO newsletter (email, subscribed_at) VALUES (?, NOW())");
                    if ($insert_stmt) {
                        $insert_stmt->bind_param("s", $email);
                        
                        if ($insert_stmt->execute()) {
                            $message = "Thank you for subscribing!";
                            $message_type = "success";
                            
                            // Clear the email field on success
                            $_POST['subscribe_email'] = '';
                        } else {
                            $message = "Error: " . $insert_stmt->error;
                            $message_type = "error";
                        }
                        $insert_stmt->close();
                    } else {
                        $message = "Database error.";
                        $message_type = "error";
                    }
                }
                
                $stmt->close();
            } else {
                $message = "Database error.";
                $message_type = "error";
            }
        }
    }
    $conn->close();
}
?>

<!-- Newsletter Subscription -->
<div class="newsletter mb-6">
    <p class="text-gray-300 mb-4">Subscribe to our newsletter for updates and news:</p>
    
    <?php if (!empty($message)): ?>
        <div class="message-box mb-4 p-3 rounded 
            <?php 
            if ($message_type === 'success') echo 'bg-green-100 text-green-800 border border-green-400';
            elseif ($message_type === 'error') echo 'bg-red-100 text-red-800 border border-red-400';
            else echo 'bg-yellow-100 text-yellow-800 border border-yellow-400';
            ?>">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>
    
    <form method="POST" action="" class="subscribe-form">
        <div class="flex">
            <input type="email" name="subscribe_email" id="subscribe_email" 
                   placeholder="Your email address"
                   value="<?php echo isset($_POST['subscribe_email']) ? htmlspecialchars($_POST['subscribe_email']) : ''; ?>"
                   class="px-4 py-2 rounded-l-md focus:outline-none focus:ring-2 focus:ring-blue-500 text-gray-800 w-full" 
                   required>
            <button type="submit"
                    class="bg-blue-600 hover:bg-blue-700 px-4 py-2 rounded-r-md transition-colors">
                <i class="fas fa-paper-plane"></i>
            </button>
        </div>
    </form>
</div>

                
             
            </div>
        </div>

        <!-- Footer Bottom -->
        <div class="footer-bottom border-t border-gray-700 pt-8">
            <div class="flex flex-col md:flex-row justify-between items-center">
                <div class="copyright mb-4 md:mb-0">
                    <p class="text-gray-400 text-sm">&copy; 2025 Adinoheight College. All rights reserved.</p>
                </div>
              
            </div>
        </div>
    </div>
</footer>

<style>
    .footer-section {
        background: linear-gradient(135deg, #1e3a8a 0%, #1e40af 100%);
    }
    
    .footer-content h3 {
        font-weight: 600;
        color: white;
    }
    
    .contact-icon {
        width: 36px;
        height: 36px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .social-icon {
        transition: all 0.3s ease;
    }
    
    .social-icon:hover {
        transform: translateY(-3px);
    }
    
    .subscribe-form input:focus {
        outline: none;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.5);
    }
    
    @media (max-width: 768px) {
        .footer-content {
            grid-template-columns: 1fr;
            gap: 30px;
        }
        
        .footer-bottom {
            text-align: center;
        }
        
        .footer-links {
            margin-top: 15px;
        }
    }
</style>
