<?php
// ========================================
// EduManage Pro - Admin Login
// ========================================

// Secure session settings
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);

// Set session cookie parameters
session_set_cookie_params([
    'lifetime' => 0, // session ends when browser closes
    'path'     => '/',
    // DO NOT force domain (avoids issues on Namecheap)
    'secure'   => (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on'),
    'httponly' => true,
    'samesite' => 'Lax'
]);

// Start session
session_start();

// Include DB connection
require_once __DIR__ . '/config/conn.php';

// Variables
$error = '';
$email = '';

// If already logged in, redirect
if (isset($_SESSION['user_id'])) {
    header("Location: admin/index.php");
    exit();
}

// Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email    = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $role     = 'admin';

    if ($email === '' || $password === '') {
        $error = 'Email and password are required';
    } else {
        $sql = "SELECT * FROM users WHERE email = ? AND role = ? LIMIT 1";
        $stmt = $conn->prepare($sql);

        if ($stmt) {
            $stmt->bind_param("ss", $email, $role);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows === 1) {
                $user = $result->fetch_assoc();

                if (password_verify($password, $user['password'])) {
                    // Secure new session
                    session_regenerate_id(true);

                    $_SESSION['user_id']       = $user['id'];
                    $_SESSION['user_email']    = $user['email'];
                    $_SESSION['user_name']     = $user['name'];
                    $_SESSION['user_role']     = $user['role'];
                    $_SESSION['last_activity'] = time();

                    header("Location: admin/index.php");
                    exit();
                } else {
                    $error = "Invalid password";
                }
            } else {
                $error = "Admin account not found";
            }

            $stmt->close();
        } else {
            $error = "Database error: " . $conn->error;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Adinoheight - Admin Login</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            primary: {
              50: '#eff6ff',
              100: '#dbeafe',
              200: '#bfdbfe',
              300: '#93c5fd',
              400: '#60a5fa',
              500: '#3b82f6',
              600: '#2563eb',
              700: '#1d4ed8',
              800: '#1e40af',
              900: '#1e3a8a',
            },
            secondary: '#f59e0b',
          },
          fontFamily: {
            sans: ['Inter', 'sans-serif'],
          },
        }
      }
    }
  </script>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    .auth-container { background: linear-gradient(135deg, #2563eb 0%, #1e3a8a 100%); }
    .auth-card { box-shadow: 0 10px 30px rgba(37, 99, 235, 0.2); }
    .input-field:focus { box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.2); }
    .toast { position: fixed; top: 20px; right: 20px; padding: 16px 24px; border-radius: 8px;
      color: white; font-weight: 500; box-shadow: 0 4px 12px rgba(0,0,0,0.15); z-index: 1000;
      transform: translateX(150%); transition: transform 0.3s ease-in-out; display: flex;
      align-items: center; max-width: 350px; }
    .toast.show { transform: translateX(0); }
    .toast.success { background-color: #10B981; }
    .toast.error { background-color: #EF4444; }
    .toast.warning { background-color: #F59E0B; }
    .toast.info { background-color: #3B82F6; }
    .toast i { margin-right: 12px; font-size: 20px; }
    @media (max-width: 640px) {
      .toast { top: 10px; right: 10px; left: 10px; max-width: calc(100% - 20px); }
    }
  </style>
</head>
<body class="font-sans bg-gray-50">

<!-- Toast -->
<div id="toast" class="toast hidden">
  <i id="toastIcon"></i>
  <span id="toastMessage"></span>
</div>

<!-- Login Form -->
<div class="min-h-screen flex items-center justify-center auth-container p-4">
  <div class="auth-card bg-white rounded-xl p-8 w-full max-w-md">
    <div class="text-center mb-8">
      <div class="flex justify-center mb-4">
        <i class="fas fa-graduation-cap text-primary-600 text-4xl"></i>
      </div>
      <h1 class="text-2xl font-bold text-gray-800">Welcome Back</h1>
      <p class="text-gray-600 mt-2">Sign in to your admin account</p>
    </div>

    <?php if (!empty($error)): ?>
      <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4" role="alert">
        <p class="font-bold">Login Failed</p>
        <p><?= htmlspecialchars($error) ?></p>
      </div>
    <?php endif; ?>

    <form id="loginForm" method="POST" action="">
      <div class="mb-4">
        <label for="loginEmail" class="block text-sm font-medium text-gray-700 mb-1">Email</label>
        <input type="email" id="loginEmail" name="email"
          class="input-field w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-primary-500"
          placeholder="admin@school.edu" value="<?= htmlspecialchars($email) ?>" required>
      </div>

      <div class="mb-6">
        <label for="loginPassword" class="block text-sm font-medium text-gray-700 mb-1">Password</label>
        <div class="relative">
          <input type="password" id="loginPassword" name="password"
            class="input-field w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-primary-500"
            placeholder="••••••••" required>
          <button type="button" class="absolute right-3 top-3 text-gray-400 hover:text-gray-600"
            onclick="togglePassword('loginPassword')">
            <i class="far fa-eye"></i>
          </button>
        </div>
      </div>

      <button type="submit"
        class="w-full bg-primary-600 hover:bg-primary-700 text-white font-medium py-2 px-4 rounded-lg transition duration-200 mb-4">
        Sign In
      </button>
    </form>

    <div class="mt-4 text-center">
      <p class="text-sm text-gray-600">Don't have an account?
        <a href="portal.php" class="text-primary-600 hover:text-secondary font-medium">Register here</a>
      </p>
    </div>
  </div>
</div>

<script>
  function showToast(message, type = 'success') {
    const toast = document.getElementById('toast');
    const icon = document.getElementById('toastIcon');
    const msg = document.getElementById('toastMessage');
    msg.textContent = message;
    toast.className = 'toast ' + type + ' show';
    switch(type) {
      case 'success': icon.className = 'fas fa-check-circle'; break;
      case 'error': icon.className = 'fas fa-exclamation-circle'; break;
      case 'warning': icon.className = 'fas fa-exclamation-triangle'; break;
      default: icon.className = 'fas fa-info-circle';
    }
    setTimeout(() => { toast.classList.remove('show'); }, 5000);
  }
  function togglePassword(id) {
    const f = document.getElementById(id);
    const i = f.nextElementSibling.querySelector('i');
    if (f.type === 'password') { f.type = 'text'; i.classList.replace('fa-eye','fa-eye-slash'); }
    else { f.type = 'password'; i.classList.replace('fa-eye-slash','fa-eye'); }
  }
  document.getElementById('loginForm').addEventListener('submit', e => {
    const email = document.getElementById('loginEmail').value.trim();
    const pwd   = document.getElementById('loginPassword').value;
    if (!email || !pwd) {
      e.preventDefault();
      showToast('Email and password required','error');
    }
  });
  <?php if (!empty($error)): ?>
    showToast('<?= addslashes($error) ?>', 'error');
  <?php endif; ?>
</script>
</body>
</html>
<?php if (isset($conn)) $conn->close(); ?>
