<?php
session_start();
include '../config/conn.php';

// Check if user is logged in as parent
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    header('HTTP/1.1 401 Unauthorized');
    echo json_encode([]);
    exit();
}

$parent_id = $_SESSION['user_id'];

// Get notifications for this parent
$query = "SELECT id, title, message, type, is_read, created_at 
          FROM parent_notifications 
          WHERE parent_id = ? 
          ORDER BY created_at DESC 
          LIMIT 50";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $parent_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$notifications = [];
while ($row = mysqli_fetch_assoc($result)) {
    $notifications[] = [
        'id' => $row['id'],
        'title' => $row['title'],
        'message' => $row['message'],
        'type' => $row['type'],
        'is_read' => (bool)$row['is_read'],
        'created_at' => $row['created_at']
    ];
}

header('Content-Type: application/json');
echo json_encode($notifications);

mysqli_close($conn);
?>