<?php
// Include header
include 'include/header.php';

// Check login
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'parent') {
    header('Location: ../portal_login.php');
    exit();
}

// DB connection
include '../config/conn.php';

// Get parent info
$parent_id = $_SESSION['user_id'];
$query = "SELECT * FROM parents WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $parent_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    session_destroy();
    header('Location: ../portal_login.php');
    exit();
}

$parent = $result->fetch_assoc();
$stmt->close();

// Fetch children linked to this parent
$children_query = "SELECT s.id, s.full_name, s.student_id, s.roll_number, c.class_name, sec.section_name, s.photo, s.status
                   FROM students s
                   LEFT JOIN classes c ON s.class = c.id
                   LEFT JOIN sections sec ON s.section = sec.id
                   WHERE s.parent_id = ?";
$children_stmt = $conn->prepare($children_query);
$children_stmt->bind_param("i", $parent_id);
$children_stmt->execute();
$children_result = $children_stmt->get_result();
$children = $children_result->fetch_all(MYSQLI_ASSOC);
$children_stmt->close();

// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: ../portal_login.php');
    exit();
}
?>

<style>
    @media (max-width: 600px) {
  .parent-header {
    display: grid;
    grid-template-columns: 1fr; /* force single column */
  }
}

</style>
<div class="bg-white p-2  ">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">My Profile</h2>
       
    </div>

<!-- Parent Header -->
<div class="parent-header bg-green-50 p-6 mb-6 flex flex-col md:flex-row md:items-center gap-4">
    
    <!-- Image -->
    <div class="flex justify-center md:justify-start">
        <?php if (!empty($parent['picture'])): ?>
            <img src="../uploads/<?php echo htmlspecialchars($parent['picture']); ?>" 
                 alt="<?php echo htmlspecialchars($parent['fullname']); ?>" 
                 class="w-24 h-24 object-cover border-4 border-white shadow">
        <?php else: ?>
            <div class="w-24 h-24 bg-green-100 flex items-center justify-center border-4 border-white shadow">
                <i class="fas fa-user text-green"></i>
            </div>
        <?php endif; ?>
    </div>

    <!-- Name and Details -->
    <div class="text-center md:text-left">
        <h2 class="text-lg font-semibold text-green-900">
            <?php echo htmlspecialchars($parent['fullname']); ?>
        </h2>
        <p class="text-sm text-green-700">
            <?php echo htmlspecialchars($parent['email']); ?>
        </p>
    </div>

</div>


    <!-- Parent Information -->
    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="2" class="py-3 px-4 text-left text-gray-700 font-semibold">Personal Information</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium w-1/4">Gender</td>
                    <td class="py-3 px-4"><?php echo !empty($parent['gender']) ? ucfirst($parent['gender']) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Date of Birth</td>
                    <td class="py-3 px-4"><?php echo !empty($parent['birth']) ? date('F j, Y', strtotime($parent['birth'])) : 'Not provided'; ?></td>
                </tr>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="py-3 px-4 font-medium">Address</td>
                    <td class="py-3 px-4"><?php echo !empty($parent['address']) ? htmlspecialchars($parent['address']) : 'Not provided'; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Children Information -->
    <div class="overflow-x-auto mb-6">
        <table class="min-w-full bg-white border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th colspan="6" class="py-3 px-4 text-left text-gray-700 font-semibold">My Children</th>
                </tr>
                <tr class="bg-gray-50 text-gray-600">
                    <th class="py-3 px-4">Photo</th>
                    <th class="py-3 px-4">Name</th>
                    <th class="py-3 px-4">Student ID</th>
                    <th class="py-3 px-4">Class</th>
                    <th class="py-3 px-4">Section</th>
                    <th class="py-3 px-4">Status</th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                <?php if (!empty($children)): ?>
                    <?php foreach ($children as $child): ?>
                        <tr class="border-b border-gray-200 hover:bg-gray-50">
                            <td class="py-3 px-4">
                                <?php if (!empty($child['photo'])): ?>
                                    <img src="../uploads/<?php echo htmlspecialchars($child['photo']); ?>" 
                                         alt="<?php echo htmlspecialchars($child['full_name']); ?>" 
                                         class="w-12 h-12  object-cover border">
                                <?php else: ?>
                                    <i class="fas fa-user-graduate text-gray-400 text-xl"></i>
                                <?php endif; ?>
                            </td>
                            <td class="py-3 px-4"><?php echo htmlspecialchars($child['full_name']); ?></td>
                            <td class="py-3 px-4"><?php echo htmlspecialchars($child['student_id']); ?></td>
                            <td class="py-3 px-4"><?php echo htmlspecialchars($child['class_name']); ?></td>
                            <td class="py-3 px-4"><?php echo htmlspecialchars($child['section_name']); ?></td>
                            <td class="py-3 px-4">
                                <?php if ($child['status'] === 'active'): ?>
                                    <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 ">Active</span>
                                <?php elseif ($child['status'] === 'inactive'): ?>
                                    <span class="bg-red-100 text-red-800 text-xs font-medium px-2.5 py-0.5 ">Inactive</span>
                                <?php elseif ($child['status'] === 'graduated'): ?>
                                    <span class="bg-yellow-100 text-yellow-800 text-xs font-medium px-2.5 py-0.5 ">Graduated</span>
                                <?php else: ?>
                                    <span class="bg-gray-100 text-gray-800 text-xs font-medium px-2.5 py-0.5 ">Other</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" class="py-3 px-4 text-center text-gray-500">No children linked to your account.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'include/footer.php'; ?>
