<?php
include 'config/conn.php';

// Function to send push notification to all parents of a student
function sendPushNotificationToParents($student_id, $title, $message, $data = []) {
    global $conn;
    
    // Get all parents associated with this student
    $parent_query = "
        SELECT DISTINCT p.id, p.push_subscription 
        FROM parents p
        INNER JOIN students s ON p.id = s.parent_id
        WHERE s.student_id = '$student_id' 
        AND p.push_subscription IS NOT NULL
        AND p.push_subscription != ''
    ";
    
    $parent_result = mysqli_query($conn, $parent_query);
    $sent_count = 0;
    
    if ($parent_result && mysqli_num_rows($parent_result) > 0) {
        while ($parent = mysqli_fetch_assoc($parent_result)) {
            if (sendPushNotification($parent['push_subscription'], $title, $message, $data)) {
                $sent_count++;
            }
        }
    }
    
    return $sent_count;
}

// Function to send push notification to specific parent
function sendPushNotification($subscription_json, $title, $message, $data = []) {
    $subscription = json_decode($subscription_json, true);
    
    if (!$subscription) {
        error_log("Invalid push subscription JSON");
        return false;
    }
    
    // Your VAPID keys (generate these once for your application)
    $vapid_keys = [
        'publicKey' => 'YOUR_VAPID_PUBLIC_KEY',
        'privateKey' => 'YOUR_VAPID_PRIVATE_KEY'
    ];
    
    $payload = [
        'title' => $title,
        'body' => $message,
        'icon' => '/img/logotwo.png',
        'badge' => '/img/logotwo.png',
        'tag' => 'attendance-notification',
        'timestamp' => time(),
        'data' => array_merge([
            'url' => '/parent/',
            'click_action' => '/parent/'
        ], $data)
    ];
    
    // For web push, you would typically use a library like web-push-php
    // This is a simplified version - in production, use a proper web push library
    
    $web_push_url = 'https://fcm.googleapis.com/fcm/send';
    
    $headers = [
        'Authorization: key=YOUR_FIREBASE_SERVER_KEY',
        'Content-Type: application/json'
    ];
    
    $post_data = [
        'to' => $subscription['endpoint'],
        'notification' => [
            'title' => $title,
            'body' => $message,
            'icon' => '/img/logotwo.png',
            'badge' => '/img/logotwo.png',
            'click_action' => '/parent/'
        ],
        'data' => $payload
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $web_push_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_data));
    
    $result = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code === 200) {
        error_log("Push notification sent successfully");
        return true;
    } else {
        error_log("Push notification failed: " . $result);
        return false;
    }
}

// Function to save push subscription for parent
function savePushSubscription($parent_id, $subscription_json) {
    global $conn;
    
    $subscription_escaped = mysqli_real_escape_string($conn, $subscription_json);
    $query = "UPDATE parents SET push_subscription = '$subscription_escaped' WHERE id = $parent_id";
    
    return mysqli_query($conn, $query);
}

// Handle attendance push notification
function sendAttendancePushNotification($student_id, $student_name, $status, $class_name, $section_name, $attendance_date, $time) {
    $title = "📚 Attendance Update - " . $student_name;
    $message = "Your child was marked as " . ucfirst($status) . " in " . $class_name . " - " . $section_name;
    
    $data = [
        'student_name' => $student_name,
        'status' => $status,
        'class_name' => $class_name,
        'section_name' => $section_name,
        'attendance_date' => $attendance_date,
        'time' => $time,
        'type' => 'attendance'
    ];
    
    return sendPushNotificationToParents($student_id, $title, $message, $data);
}
?>