<?php
include 'include/header.php';
include '../config/conn.php';

// ✅ Ensure student login
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'student') {
    header('Location: login.php');
    exit();
}

$student_id = $_SESSION['user_id'];
$success = '';
$error = '';

// ✅ Pagination setup
$limit = 5; // events per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$offset = ($page - 1) * $limit;

// ✅ Fetch total events count
$count_sql = "SELECT COUNT(*) as total FROM events WHERE audience_type IN ('student', 'all')";
$count_stmt = $conn->prepare($count_sql);
$count_stmt->execute();
$count_result = $count_stmt->get_result()->fetch_assoc();
$total_events = $count_result['total'];
$total_pages = ceil($total_events / $limit);
$count_stmt->close();

// ✅ Fetch paginated events
$sql = "SELECT * FROM events 
        WHERE audience_type IN ('student', 'all') 
        ORDER BY event_date ASC, start_time ASC 
        LIMIT ? OFFSET ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $limit, $offset);
$stmt->execute();
$result = $stmt->get_result();
$events = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<div class="p-0">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-xl font-bold text-gray-800">Upcoming Events</h2>
    </div>

    <div class="space-y-4">
        <?php if (!empty($events)): ?>
            <?php foreach ($events as $event): ?>
                <a href="view_event_detail.php?id=<?php echo $event['id']; ?>" 
                   class="block p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                    <div class="flex items-start space-x-4">
                        
                        <!-- Date Badge -->
                        <div class="flex-shrink-0 w-14 h-14 bg-blue-100 rounded-lg flex flex-col items-center justify-center">
                            <span class="text-blue-600 font-bold text-lg">
                                <?php echo date('d', strtotime($event['event_date'])); ?>
                            </span>
                            <span class="text-xs text-gray-500">
                                <?php echo date('M', strtotime($event['event_date'])); ?>
                            </span>
                        </div>

                        <!-- Event Details -->
                        <div class="flex-1">
                            <h3 class="text-lg font-semibold text-gray-800">
                                <?php echo htmlspecialchars($event['title']); ?>
                            </h3>
                            <p class="text-sm text-gray-600 mt-1">
                                <?php
                                if (!empty($event['description'])) {
                                    // Limit description by words (first 40 words)
                                    $words = explode(" ", strip_tags($event['description']));
                                    $preview = implode(" ", array_slice($words, 0, 5)); // adjust 40 as needed

                                    echo nl2br(htmlspecialchars($preview));
                                    if (count($words) > 5) {
                                        echo '...';
                                    }
                                } else {
                                    echo 'No description provided';
                                }
                                ?>
                            </p>
                            <div class="mt-2 text-xs text-gray-500">
                                <p><i class="fas fa-clock mr-1"></i> 
                                    <?php echo date('g:i A', strtotime($event['start_time'])); ?> 
                                    - <?php echo date('g:i A', strtotime($event['end_time'])); ?>
                                </p>
                                <p><i class="fas fa-map-marker-alt mr-1"></i> 
                                    <?php echo htmlspecialchars($event['location']); ?>
                                </p>
                            </div>
                        </div>

                        <!-- Optional Image -->
                        <?php if (!empty($event['image_path'])): ?>
                            <div class="w-20 h-20 flex-shrink-0">
                                <img src="../uploads/events/<?php echo htmlspecialchars($event['image_path']); ?>" 
                                     alt="Event Image" 
                                     class="w-full h-full object-cover rounded-md border">
                            </div>
                        <?php endif; ?>
                    </div>
                </a>
            <?php endforeach; ?>
        <?php else: ?>
            <p class="text-gray-500 text-center py-6">No upcoming events found.</p>
        <?php endif; ?>
    </div>

    <!-- ✅ Pagination Controls -->
    <?php if ($total_pages > 1): ?>
        <div class="flex justify-center mt-6 space-x-2">
            <?php if ($page > 1): ?>
                <a href="?page=<?php echo $page - 1; ?>" class="px-3 py-1 border rounded text-gray-600 hover:bg-gray-100">Prev</a>
            <?php endif; ?>

            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <a href="?page=<?php echo $i; ?>" 
                   class="px-3 py-1 border rounded <?php echo $i == $page ? 'bg-blue-500 text-white' : 'text-gray-600 hover:bg-gray-100'; ?>">
                   <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $total_pages): ?>
                <a href="?page=<?php echo $page + 1; ?>" class="px-3 py-1 border rounded text-gray-600 hover:bg-gray-100">Next</a>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<?php include 'include/footer.php'; ?>
