<?php
session_start();
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'Not authenticated']);
    exit();
}

if (!isset($_GET['id'])) {
    echo json_encode(['error' => 'No notice ID provided']);
    exit();
}

$notice_id = intval($_GET['id']);
$student_id = $_SESSION['user_id'];

// Fetch notice details
$query = "SELECT n.*, u.full_name as author 
          FROM notices n 
          LEFT JOIN users u ON n.created_by = u.id 
          WHERE n.id = $notice_id";
$result = mysqli_query($conn, $query);

if ($result && mysqli_num_rows($result) > 0) {
    $notice = mysqli_fetch_assoc($result);
    
    // Determine audience text
    $audience_text = '';
    if ($notice['audience_type'] === 'all') {
        $audience_text = 'All Students';
    } elseif ($notice['audience_type'] === 'class') {
        $class_query = "SELECT class_name FROM classes WHERE id = " . $notice['target_id'];
        $class_result = mysqli_query($conn, $class_query);
        if ($class_result && mysqli_num_rows($class_result) > 0) {
            $class_name = mysqli_fetch_assoc($class_result)['class_name'];
            $audience_text = 'Class: ' . $class_name;
        }
    } elseif ($notice['audience_type'] === 'section') {
        $section_query = "SELECT s.section_name, c.class_name 
                          FROM sections s 
                          LEFT JOIN classes c ON s.class_id = c.id 
                          WHERE s.id = " . $notice['target_id'];
        $section_result = mysqli_query($conn, $section_query);
        if ($section_result && mysqli_num_rows($section_result) > 0) {
            $section = mysqli_fetch_assoc($section_result);
            $audience_text = 'Section: ' . $section['class_name'] . ' - ' . $section['section_name'];
        }
    } elseif ($notice['audience_type'] === 'student') {
        $student_query = "SELECT full_name FROM students WHERE id = " . $notice['target_id'];
        $student_result = mysqli_query($conn, $student_query);
        if ($student_result && mysqli_num_rows($student_result) > 0) {
            $target_student = mysqli_fetch_assoc($student_result);
            $audience_text = 'Student: ' . $target_student['full_name'];
        }
    }
    
    // Format response
    $response = [
        'title' => $notice['title'],
        'content' => nl2br($notice['content']),
        'priority' => $notice['priority'],
        'audience' => $audience_text,
        'author' => $notice['author'],
        'created_at' => date('M j, Y', strtotime($notice['created_at'])),
        'expiry_date' => $notice['expiry_date'] ? date('M j, Y', strtotime($notice['expiry_date'])) : 'Never'
    ];
    
    echo json_encode($response);
} else {
    echo json_encode(['error' => 'Notice not found']);
}
?>