<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Enhanced session handling
$sessionName = 'ADINOHEIGHT_SESSION';
session_name($sessionName);

// Start session with error handling
try {
    if (!session_start()) {
        throw new Exception('Failed to start session');
    }
} catch (Exception $e) {
    error_log("Session start failed in header: " . $e->getMessage());
    // Handle gracefully - maybe redirect to login with error
    header('Location: ../portal_login.php?error=session');
    exit();
}

// Check if user is logged in
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: ../portal_login.php');
    exit();
}

// Check session expiration (30 minutes)
$inactive = 1800; // 30 minutes in seconds
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $inactive)) {
    // Last request was more than 30 minutes ago
    session_unset();
    session_destroy();
    header('Location: ../portal_login.php?error=timeout');
    exit();
}

// Update last activity time
$_SESSION['last_activity'] = time();

// Regenerate session ID periodically to prevent fixation
if (!isset($_SESSION['created'])) {
    $_SESSION['created'] = time();
} else if (time() - $_SESSION['created'] > 1800) {
    // Session started more than 30 minutes ago
    session_regenerate_id(true);
    $_SESSION['created'] = time();
}

// Verify user type and set appropriate variables
$allowed_user_types = ['student', 'teacher', 'parent'];
if (!isset($_SESSION['user_type']) || !in_array($_SESSION['user_type'], $allowed_user_types)) {
    // Invalid user type, destroy session and redirect
    session_unset();
    session_destroy();
    header('Location: ../portal_login.php?error=invalid_user');
    exit();
}

// Set user type for use in the application
$user_type = $_SESSION['user_type'];
$user_id = $_SESSION['user_id'];
$username = $_SESSION['username'];
$full_name = $_SESSION['full_name'];

// Include database connection
include '../config/conn.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Adinoheight School College</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#2563eb',
                        primaryDark: '#1d4ed8',
                        secondary: '#F8FAFC',
                        accent: '#ef4444',
                        dark: '#1E293B',
                        light: '#F1F5F9',
                        success: '#10b981',
                        warning: '#f59e0b',
                        info: '#0ea5e9'
                    },
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                        heading: ['Poppins', 'sans-serif']
                    },
                    boxShadow: {
                        'soft': '0 4px 12px -2px rgba(0, 0, 0, 0.08)',
                        'medium': '0 6px 16px -2px rgba(0, 0, 0, 0.1)'
                    }
                }
            }
        }
    </script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Poppins:wght@400;500;600;700&display=swap');
        
        body {
            font-family: 'Inter', sans-serif;
        }
        
        .heading {
            font-family: 'Poppins', sans-serif;
        }
        
        .sidebar {
            transition: all 0.3s ease;
        }
        
        .submenu {
            transition: all 0.3s ease;
            overflow: hidden;
            max-height: 0;
        }
        
        .submenu.open {
            max-height: 500px;
        }
        
        .nav-item:hover {
            background-color: #eff6ff;
        }
        
        .dashboard-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
        }
        
        /* Search button animation */
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(37, 99, 235, 0.4); }
            70% { box-shadow: 0 0 0 10px rgba(37, 99, 235, 0); }
            100% { box-shadow: 0 0 0 0 rgba(37, 99, 235, 0); }
        }
        
        .search-btn {
            animation: pulse 2s infinite;
        }
        
        .search-btn:hover {
            animation: none;
        }
        
        /* Search suggestions */
        .search-suggestions {
            display: none;
            opacity: 0;
            transform: translateY(-10px);
            transition: all 0.3s ease;
        }
        
        .search-container:focus-within .search-suggestions,
        .search-container:hover .search-suggestions {
            display: block;
            opacity: 1;
            transform: translateY(0);
        }
        
        /* Mobile search overlay */
        .mobile-search-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 60;
        }
        
        .mobile-search-overlay.open {
            display: block;
        }
        
        .mobile-search-container {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background: white;
            padding: 1rem;
            z-index: 70;
            transform: translateY(-100%);
            transition: transform 0.3s ease;
        }
        
        .mobile-search-container.open {
            transform: translateY(0);
        }
        
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                position: absolute;
                z-index: 50;
                height: 100vh;
            }
            
            .sidebar.open {
                transform: translateX(0);
            }
            
            .overlay {
                display: none;
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background-color: rgba(0, 0, 0, 0.5);
                z-index: 40;
            }
            
            .overlay.open {
                display: block;
            }
            
            .search-container {
                display: none;
            }
            
            .mobile-search-btn {
                display: block;
            }
            
            .header-content {
                flex-direction: row;
                align-items: center;
            }
            
            .header-content h2 {
                margin-left: 0;
            }
        }
        
        @media (min-width: 769px) {
            .mobile-search-btn {
                display: none;
            }
        }
    </style>
</head>
<body class="bg-gray-50 flex h-screen">
    <?php include 'sidebar.php'; ?>

<!-- Main content -->
<div class="flex-1 flex flex-col overflow-hidden">
    <?php include 'navbar.php'; ?>
       <!-- Main content -->
    <main class="flex-1 overflow-y-auto bg-gray-50 p-6">