<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Output buffering to prevent header issues
ob_start();

session_name('ADINOHEIGHT_SESSION');
ini_set('session.cookie_lifetime', 0);
ini_set('session.cookie_secure', isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on');
ini_set('session.cookie_httponly', true);
ini_set('session.cookie_samesite', 'Lax');

session_start();

// Check if user is logged in
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: ../portal_login.php');
    exit();
}

include '../config/conn.php';

// Get reference
$reference = isset($_GET['reference']) ? mysqli_real_escape_string($conn, $_GET['reference']) : '';
if (empty($reference)) {
    ob_end_clean();
    die("No reference provided");
}

// Debug: Log the reference being searched for
error_log("Searching for reference: " . $reference);

// Paystack verification
$paystack_secret = "sk_test_e961ecf6ab503d4b5d63853a2dfc0c9ec6ac78e6";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://api.paystack.co/transaction/verify/" . $reference);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Bearer $paystack_secret",
    "Cache-Control: no-cache",
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
$err = curl_error($ch);
curl_close($ch);

if ($err) {
    ob_end_clean();
    die("cURL Error: " . $err);
}

$res = json_decode($response, true);

if (!$res || !isset($res['status'])) {
    ob_end_clean();
    die("Invalid response from Paystack");
}

if ($res['status'] && $res['data']['status'] == 'success') {
    $ref = $res['data']['reference'];
    $amount_paid = $res['data']['amount'] / 100;
    $payment_date = date('Y-m-d H:i:s', strtotime($res['data']['paid_at']));

    // Debug: Log the reference from Paystack
    error_log("Paystack reference: " . $ref);

    // Get invoice details - CORRECTED: changed 'reference' to 'reference'
    $invoice_query = "SELECT id, student_id, amount FROM invoices WHERE reference='$ref'";
    $invoice_result = mysqli_query($conn, $invoice_query);
    
    // Debug: Log the query and result
    error_log("Invoice query: " . $invoice_query);
    error_log("Number of rows found: " . mysqli_num_rows($invoice_result));

    if (!$invoice_result) {
        ob_end_clean();
        die("Query error: " . mysqli_error($conn));
    }
    
    if (mysqli_num_rows($invoice_result) === 0) {
        // Let's check what references actually exist for debugging
        $check_refs = "SELECT id, reference FROM invoices WHERE reference IS NOT NULL LIMIT 5";
        $refs_result = mysqli_query($conn, $check_refs);
        $existing_refs = [];
        while ($row = mysqli_fetch_assoc($refs_result)) {
            $existing_refs[] = $row['reference'];
        }
        error_log("Existing references: " . implode(', ', $existing_refs));
        
        ob_end_clean();
        die("Invoice not found for reference: $ref. Existing references: " . implode(', ', $existing_refs));
    }

    $invoice = mysqli_fetch_assoc($invoice_result);
    $invoice_id = $invoice['id'];
    $student_id = $invoice['student_id'];
    $invoice_amount = $invoice['amount'];

    // Verify amount matches
    if ($amount_paid != $invoice_amount) {
        error_log("Amount mismatch: Paid $amount_paid vs Invoice $invoice_amount");
        // You might want to handle this differently - perhaps update the invoice amount
        // or flag for manual review
    }

    // Record payment
    $insert_payment = "INSERT INTO payments (invoice_id, student_id, amount, payment_method, transaction_id, payment_date) 
                       VALUES ($invoice_id, $student_id, $amount_paid, 'paystack', '$ref', '$payment_date')";

    if (mysqli_query($conn, $insert_payment)) {
        // Update invoice status
        $update_invoice = "UPDATE invoices SET status='paid' WHERE id=$invoice_id";
        if (mysqli_query($conn, $update_invoice)) {
            // Successful redirect
            ob_end_clean();
            header("Location: payment_success.php?invoice_id=$invoice_id");
            exit();
        } else {
            error_log("Invoice update error: " . mysqli_error($conn));
            ob_end_clean();
            die("Error updating invoice: " . mysqli_error($conn));
        }
    } else {
        error_log("Payment insert error: " . mysqli_error($conn));
        ob_end_clean();
        die("Error recording payment: " . mysqli_error($conn));
    }
} else {
    // Failed payment redirect
    ob_end_clean();
    header("Location: payment_failed.php?reference=$reference");
    exit();
}

ob_end_flush();
?>