<?php
session_start();
include '../config/conn.php';



// Get parameters from POST or GET (for testing)
$invoice_id = isset($_POST['invoice_id']) ? intval($_POST['invoice_id']) : (isset($_GET['invoice_id']) ? intval($_GET['invoice_id']) : 0);
$email = isset($_POST['email']) ? filter_var($_POST['email'], FILTER_SANITIZE_EMAIL) : (isset($_GET['email']) ? filter_var($_GET['email'], FILTER_SANITIZE_EMAIL) : '');
$amount = isset($_POST['amount']) ? intval($_POST['amount']) : (isset($_GET['amount']) ? intval($_GET['amount']) : 0);

// Validate inputs
if ($invoice_id <= 0 || $amount <= 0 || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    die("Invalid parameters. Invoice ID: $invoice_id, Amount: $amount, Email: $email");
}

// Get invoice details
$invoice_query = "SELECT i.*, s.full_name, s.email as student_email 
                  FROM invoices i 
                  JOIN students s ON i.student_id = s.id 
                  WHERE i.id = $invoice_id";
$invoice_result = mysqli_query($conn, $invoice_query);

if (!$invoice_result || mysqli_num_rows($invoice_result) === 0) {
    die("Invoice not found");
}

$invoice = mysqli_fetch_assoc($invoice_result);

// Use student email if available, otherwise use provided email
$payer_email = !empty($invoice['student_email']) ? $invoice['student_email'] : $email;

$paystack_secret = "sk_test_e961ecf6ab503d4b5d63853a2dfc0c9ec6ac78e6"; // Replace with your Paystack secret key
$callback_url = "http://" . $_SERVER['HTTP_HOST'] . "/student/payment_callback.php";


// Generate unique reference
$reference = 'INV_' . $invoice_id . '_' . uniqid();

$fields = [
    'email' => $payer_email,
    'amount' => $amount,
    'reference' => $reference,
    'callback_url' => $callback_url,
    'metadata' => json_encode([
        'invoice_id' => $invoice_id,
        'custom_fields' => [
            [
                'display_name' => 'Invoice ID',
                'variable_name' => 'invoice_id',
                'value' => $invoice_id
            ],
            [
                'display_name' => 'Student Name',
                'variable_name' => 'student_name',
                'value' => $invoice['full_name']
            ]
        ]
    ])
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://api.paystack.co/transaction/initialize");
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Bearer $paystack_secret",
    "Content-Type: application/json",
    "Cache-Control: no-cache",
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response = curl_exec($ch);
$err = curl_error($ch);
curl_close($ch);

if ($err) {
    die("cURL Error: " . $err);
}

$res = json_decode($response, true);

if ($res['status']) {
    // Store reference in DB for tracking
    $ref = $res['data']['reference'];
    $update_query = "UPDATE invoices SET reference='$ref', payment_method='paystack' WHERE id=$invoice_id";
    mysqli_query($conn, $update_query);
    
    // Redirect to Paystack payment page
    header("Location: " . $res['data']['authorization_url']);
    exit();
} else {
    die("Error initializing Paystack payment: " . $res['message']);
}
?>