<?php
session_start();
include '../config/conn.php';

// Check if user is logged in and is a student
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'student') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit();
}

$student_id = $_SESSION['user_id'];
$response = ['success' => false, 'message' => ''];

try {
    // Validate required fields
    if (!isset($_POST['assignment_id']) || empty($_POST['assignment_id'])) {
        throw new Exception('Assignment ID is required');
    }

    $assignment_id = intval($_POST['assignment_id']);

    // Verify the assignment exists and is for the student's class
    $student_query = "SELECT s.class, s.section FROM students s WHERE s.id = $student_id";
    $student_result = mysqli_query($conn, $student_query);
    
    if (!$student_result || mysqli_num_rows($student_result) === 0) {
        throw new Exception('Student record not found');
    }
    
    $student_data = mysqli_fetch_assoc($student_result);
    $class_id = $student_data['class'];
    $section_id = $student_data['section'];

    $assignment_check = "SELECT id FROM assignments 
                        WHERE id = $assignment_id 
                        AND class_id = $class_id 
                        AND section_id = $section_id";
    $assignment_result = mysqli_query($conn, $assignment_check);
    
    if (!$assignment_result || mysqli_num_rows($assignment_result) === 0) {
        throw new Exception('Assignment not found or not assigned to your class');
    }

    // Check if assignment is overdue
    $due_date_check = "SELECT due_date FROM assignments WHERE id = $assignment_id";
    $due_date_result = mysqli_query($conn, $due_date_check);
    $due_date_data = mysqli_fetch_assoc($due_date_result);
    
    if (strtotime($due_date_data['due_date']) < time()) {
        throw new Exception('Cannot submit assignment after the due date');
    }

    // Process submission text
    $submission_text = isset($_POST['submission_text']) ? mysqli_real_escape_string($conn, $_POST['submission_text']) : '';

    // Process file upload
    $submission_file = '';
    if (isset($_FILES['submission_file']) && $_FILES['submission_file']['error'] == 0) {
        $allowed_extensions = ['pdf', 'doc', 'docx', 'txt', 'jpg', 'jpeg', 'png', 'zip', 'rar'];
        $file_name = $_FILES['submission_file']['name'];
        $file_size = $_FILES['submission_file']['size'];
        $file_tmp = $_FILES['submission_file']['tmp_name'];
        $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
        
        if (!in_array($file_ext, $allowed_extensions)) {
            throw new Exception('Invalid file type. Allowed: ' . implode(', ', $allowed_extensions));
        }
        
        if ($file_size > 10485760) { // 10MB
            throw new Exception('File size must be less than 10MB');
        }
        
        $new_file_name = 'submission_' . $student_id . '_' . $assignment_id . '_' . time() . '.' . $file_ext;
        $upload_path = '../uploads/assignment_answers/' . $new_file_name;
        
        // Create directory if it doesn't exist
        if (!file_exists('../uploads/assignment_answers/')) {
            mkdir('../uploads/assignment_answers/', 0777, true);
        }
        
        if (!move_uploaded_file($file_tmp, $upload_path)) {
            throw new Exception('Error uploading file');
        }
        
        $submission_file = $new_file_name;
    }

    // Check if submission already exists
    $existing_submission = "SELECT id, submission_file FROM assignment_submissions 
                           WHERE assignment_id = $assignment_id AND student_id = $student_id";
    $existing_result = mysqli_query($conn, $existing_submission);
    
    if ($existing_result && mysqli_num_rows($existing_result) > 0) {
        // Update existing submission
        $existing_data = mysqli_fetch_assoc($existing_result);
        $submission_id = $existing_data['id'];
        
        // Delete old file if a new one is uploaded
        if (!empty($submission_file) && !empty($existing_data['submission_file'])) {
            $old_file_path = '../uploads/assignment_answers/' . $existing_data['submission_file'];
            if (file_exists($old_file_path)) {
                unlink($old_file_path);
            }
        }
        
        $update_query = "UPDATE assignment_submissions SET 
                        submission_text = '$submission_text',
                        " . (!empty($submission_file) ? "submission_file = '$submission_file', " : "") . "
                        submitted_at = NOW()
                        WHERE id = $submission_id";
        
        if (mysqli_query($conn, $update_query)) {
            $response['success'] = true;
            $response['message'] = 'Submission updated successfully';
        } else {
            throw new Exception('Error updating submission: ' . mysqli_error($conn));
        }
    } else {
        // Create new submission
        $insert_query = "INSERT INTO assignment_submissions 
                        (assignment_id, student_id, submission_text, submission_file, submitted_at)
                        VALUES ($assignment_id, $student_id, '$submission_text', '$submission_file', NOW())";
        
        if (mysqli_query($conn, $insert_query)) {
            $response['success'] = true;
            $response['message'] = 'Assignment submitted successfully';
        } else {
            throw new Exception('Error submitting assignment: ' . mysqli_error($conn));
        }
    }

    // Get the updated submission data for the response
    $submission_query = "SELECT * FROM assignment_submissions 
                        WHERE assignment_id = $assignment_id AND student_id = $student_id";
    $submission_result = mysqli_query($conn, $submission_query);
    
    if ($submission_result && mysqli_num_rows($submission_result) > 0) {
        $submission_data = mysqli_fetch_assoc($submission_result);
        $response['submission'] = [
            'submitted_at' => date('M j, Y g:i A', strtotime($submission_data['submitted_at'])),
            'submission_text' => nl2br($submission_data['submission_text']),
            'submission_file' => $submission_data['submission_file']
        ];
    }

} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

// Ensure we're sending proper JSON
header('Content-Type: application/json');
echo json_encode($response);
exit();